/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.google.common.collect.Iterables;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DeleteTableHelper;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.script.SqlReader;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.TextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteQueryGenerator {
    private final DbDataSource myDataSource;
    private final Set<DbTable> myTables = ContainerUtil.newLinkedHashSet();
    private final Set<DbRoutine> myProcedures = ContainerUtil.newLinkedHashSet();
    private final MultiMap<DbPackage, DbElement> myPackageContent = MultiMap.createLinkedSet();
    private final Set<DbColumn> myColumns = ContainerUtil.newLinkedHashSet();
    private final Set<DbIndex> myIndices = ContainerUtil.newLinkedHashSet();
    private final Set<DbTableKey> myKeys = ContainerUtil.newLinkedHashSet();
    private final Set<DbForeignKey> myForeignKeys = ContainerUtil.newLinkedHashSet();

    public static boolean canDeleteAnything(Iterable<DbElement> elements) {
        return !JBIterable.from(elements).filter((Condition)new Condition<DbElement>(){

            public boolean value(DbElement e) {
                return e.getDbParent() instanceof DbPackage || e instanceof DbTable || e instanceof DbRoutine || e instanceof DbColumn || e instanceof DbIndex || e instanceof DbTableKey || e instanceof DbForeignKey;
            }
        }).isEmpty();
    }

    public DeleteQueryGenerator(DbDataSource dataSource, Collection<DbElement> elements) {
        this.myDataSource = dataSource;
        for (DbElement e : elements) {
            if (e.getDbParent() instanceof DbPackage) {
                this.myPackageContent.putValue((Object)((DbPackage)e.getDbParent()), (Object)e);
                continue;
            }
            if (e instanceof DbTable) {
                this.myTables.add((DbTable)e);
                continue;
            }
            if (e instanceof DbRoutine) {
                this.myProcedures.add((DbRoutine)e);
                continue;
            }
            if (e instanceof DbColumn) {
                this.myColumns.add((DbColumn)e);
                continue;
            }
            if (e instanceof DbIndex) {
                this.myIndices.add((DbIndex)e);
                continue;
            }
            if (e instanceof DbTableKey) {
                this.myKeys.add((DbTableKey)e);
                continue;
            }
            if (!(e instanceof DbForeignKey)) continue;
            this.myForeignKeys.add((DbForeignKey)e);
        }
    }

    public List<String> generateQueries(@NotNull List<String> messages) {
        DbTable table;
        List<DasTable> tablesDeletionOrder;
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/database/view/DeleteQueryGenerator", "generateQueries"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        Project project = this.myDataSource.getProject();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)this.myDataSource);
        try {
            tablesDeletionOrder = DeleteTableHelper.getDeletionOrder(((DatabaseSystem)this.myDataSource.getDelegate()).getModel(), ContainerUtil.map(this.myTables, (Function)new Function<DbTable, DasTable>(){

                @Nullable
                public DasTable fun(@NotNull DbTable element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DeleteQueryGenerator$2", "fun"));
                    }
                    Object delegate = element.getDelegate();
                    return delegate instanceof DasTable ? (DasTable)delegate : null;
                }
            }), dialect.supportsDropForeignKey());
        }
        catch (UnsupportedOperationException e) {
            DataSourceUiUtil.showNotification(project, "Deletion for dataSource " + this.myDataSource.getName() + " failed", e.getMessage(), true);
            return Collections.emptyList();
        }
        tablesDeletionOrder.remove(null);
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        DdlBuilder keyBuilder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        for (DbForeignKey dbForeignKey : this.myForeignKeys) {
            table = dbForeignKey.getTable();
            if (this.myTables.contains(table) || QNameUtil.isFakeName(dbForeignKey.getName()) || !dialect.supportsDropForeignKey()) continue;
            dialect.sqlDropForeignKey(keyBuilder, (DasTable)table, (DasForeignKey)dbForeignKey, dbForeignKey.getName()).newStatement();
        }
        for (DbTableKey dbTableKey : this.myKeys) {
            table = dbTableKey.getTable();
            if (this.myTables.contains(table) || QNameUtil.isFakeName(dbTableKey.getName())) continue;
            if (dbTableKey.isPrimary() && dialect.supportsDropConstraint()) {
                dialect.sqlDropPrimaryKey(keyBuilder, (DasTableKey)dbTableKey).newStatement();
                continue;
            }
            if (dbTableKey.isPrimary() || !dialect.supportsDropConstraint()) continue;
            dialect.sqlDropConstraint(keyBuilder, (DasTable)table, (DasObject)dbTableKey, dbTableKey.getName()).newStatement();
        }
        for (DasTable dasTable : tablesDeletionOrder) {
            ObjectKind kind = dasTable.getKind();
            if (kind == ObjectKind.TABLE) {
                for (DasForeignKey keyInfo : DasUtil.getForeignKeys((DasTable)dasTable)) {
                    if (!dialect.supportsDropForeignKey() || this.myTables.size() <= 1 || QNameUtil.isFakeName(keyInfo.getName())) continue;
                    dialect.sqlDropForeignKey(keyBuilder, dasTable, keyInfo, keyInfo.getName()).newStatement();
                }
                dialect.sqlDropTable(builder, dasTable, false, false, this.myDataSource.getModel()).newStatement();
                continue;
            }
            if (kind == ObjectKind.VIEW && dialect.supportsDropView()) {
                dialect.sqlDropView(builder, dasTable, false).newStatement();
                continue;
            }
            if (kind != ObjectKind.SEQUENCE || !dialect.supportsDropSequence()) continue;
            dialect.sqlDropSequence(builder, dasTable, false).newStatement();
        }
        result.addAll(keyBuilder.getStatements());
        result.addAll(builder.getStatements());
        result.addAll(this.generateDropColumnsAndIndexQueries(dialect, new LinkedHashSet<DasTable>(tablesDeletionOrder)).getStatements());
        for (Map.Entry entry : this.myPackageContent.entrySet()) {
            result.addAll(this.generateDropContentFromPackages((DbPackage)entry.getKey(), (Collection)entry.getValue(), messages).getStatements());
        }
        DdlBuilder procedureBuilder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        if (dialect.supportsDropProcedure()) {
            for (DbRoutine p : this.myProcedures) {
                dialect.sqlDropProcedure(procedureBuilder, (DasRoutine)p).newStatement();
            }
        }
        result.addAll(procedureBuilder.getStatements());
        return result;
    }

    @NotNull
    private DdlBuilder generateDropContentFromPackages(DbPackage pkg, Collection<DbElement> content, @NotNull List<String> msgs) {
        if (msgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgs", "com/intellij/database/view/DeleteQueryGenerator", "generateDropContentFromPackages"));
        }
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        try {
            StringBuilder pkgDef = new StringBuilder();
            DatabaseEditorHelper.loadDefinition((DbElement)pkg, pkgDef);
            SqlReader reader = SqlPsiFacade.getInstance((Project)pkg.getProject()).createSqlReader();
            SqlLanguageDialect dialect = DbImplUtil.getSqlDialect(pkg.getProject(), (DatabaseSystem)pkg.getDataSource());
            SqlFile psi = reader.getReadOnlyPsi(dialect, (CharSequence)pkgDef);
            JBIterable packages = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)psi)).expand(Conditions.not((Condition)Conditions.instanceOf(SqlStatement.class)))).filter(SqlStatement.class).filter(Conditions.instanceOf(DasObject.class));
            TextRanges dropRanges = new TextRanges();
            for (SqlStatement pkgPartDef : packages) {
                DeleteQueryGenerator.findContentRanges(dialect, pkgPartDef, content, dropRanges, msgs, pkgDef);
            }
            for (TextRange range : JBIterable.once((Iterator)dropRanges.revIterator())) {
                pkgDef.replace(range.getStartOffset(), range.getEndOffset(), "");
            }
            String res = pkgDef.toString().trim();
            if (res.endsWith(";")) {
                res = res.substring(0, res.length() - 1);
            }
            builder.plain(res);
        }
        catch (Exception e) {
            msgs.add("Failed to load definition of package `" + pkg.getName() + "`");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "generateDropContentFromPackages"));
        }
        return ddlBuilder;
    }

    private static void findContentRanges(@NotNull SqlLanguageDialect sqlDialect, @NotNull SqlStatement defRoot, @NotNull Collection<DbElement> content, @NotNull TextRanges ranges, @NotNull List<String> msgs, @NotNull CharSequence text) {
        if (sqlDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlDialect", "com/intellij/database/view/DeleteQueryGenerator", "findContentRanges"));
        }
        if (defRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defRoot", "com/intellij/database/view/DeleteQueryGenerator", "findContentRanges"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/view/DeleteQueryGenerator", "findContentRanges"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/DeleteQueryGenerator", "findContentRanges"));
        }
        if (msgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msgs", "com/intellij/database/view/DeleteQueryGenerator", "findContentRanges"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/DeleteQueryGenerator", "findContentRanges"));
        }
        List<List<DbElement>> partition = DeleteQueryGenerator.partitionByNameAndKind(content, (DatabaseDialectEx)sqlDialect.getDatabaseDialect());
        for (List<DbElement> homonyms : partition) {
            Set<PsiObject> found = DeleteQueryGenerator.filterOverloads(DeleteQueryGenerator.findObjectsByNameAndKind(defRoot, homonyms.get(0)), homonyms);
            if (found.size() < homonyms.size()) {
                if (found.isEmpty()) {
                    msgs.add("Failed to find `" + homonyms.get(0).getName() + "` definition in package. Not removed.");
                } else {
                    msgs.add("Failed to find some `" + homonyms.get(0).getName() + "` definitions in package. Not all removed.");
                }
            }
            for (PsiObject object : found) {
                ranges.union(DeleteQueryGenerator.expandedRange(sqlDialect, (PsiElement)object, text));
            }
        }
    }

    @NotNull
    private static Set<PsiObject> filterOverloads(@NotNull Set<PsiObject> found, @NotNull List<DbElement> homonyms) {
        if (found == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "found", "com/intellij/database/view/DeleteQueryGenerator", "filterOverloads"));
        }
        if (homonyms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homonyms", "com/intellij/database/view/DeleteQueryGenerator", "filterOverloads"));
        }
        if (homonyms.size() == found.size()) {
            Set<PsiObject> set = found;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "filterOverloads"));
            }
            return set;
        }
        if (homonyms.get(0).getKind() == ObjectKind.ROUTINE) {
            Set<PsiObject> set = DeleteQueryGenerator.filterRoutineOverloads(found, homonyms);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "filterOverloads"));
            }
            return set;
        }
        Set<PsiObject> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "filterOverloads"));
        }
        return set;
    }

    @NotNull
    private static Set<PsiObject> filterRoutineOverloads(@NotNull Set<PsiObject> found, @NotNull List<DbElement> homonyms) {
        if (found == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "found", "com/intellij/database/view/DeleteQueryGenerator", "filterRoutineOverloads"));
        }
        if (homonyms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homonyms", "com/intellij/database/view/DeleteQueryGenerator", "filterRoutineOverloads"));
        }
        HashSet sigs = ContainerUtil.newHashSet();
        for (DbElement homonym : homonyms) {
            sigs.add(DeleteQueryGenerator.getSig((DasObject)homonym));
        }
        HashSet res = ContainerUtil.newHashSet();
        for (PsiObject object : found) {
            if (!sigs.contains(DeleteQueryGenerator.getSig((DasObject)object))) continue;
            res.add(object);
        }
        if (res.size() == homonyms.size()) {
            HashSet hashSet = res;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "filterRoutineOverloads"));
            }
            return hashSet;
        }
        Set<PsiObject> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "filterRoutineOverloads"));
        }
        return set;
    }

    @NotNull
    private static Trinity<DasRoutine.Kind, Boolean, Integer> getSig(DasObject object) {
        DasRoutine routine = (DasRoutine)object;
        Trinity trinity = Trinity.create((Object)routine.getRoutineKind(), (Object)(routine.getReturnArgument() != null ? 1 : 0), (Object)JBIterable.from((Iterable)routine.getArguments()).size());
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "getSig"));
        }
        return trinity;
    }

    private static List<List<DbElement>> partitionByNameAndKind(@NotNull Collection<DbElement> content, @NotNull CasingProvider provider) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/view/DeleteQueryGenerator", "partitionByNameAndKind"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/view/DeleteQueryGenerator", "partitionByNameAndKind"));
        }
        ArrayList res = ContainerUtil.newArrayList();
        HashMap partition = ContainerUtil.newHashMap();
        for (DbElement element : content) {
            List homonyms;
            Map byName = (Map)partition.get(element.getKind());
            if (byName == null) {
                boolean sensitive = DasUtil.isCaseSensitive((Casing)provider.getCasing(element.getKind(), (DasObject)element.getDbParent()));
                byName = DasUtil.newCasingAwareMap((boolean)sensitive);
                partition.put(element.getKind(), byName);
            }
            if ((homonyms = (List)byName.get(element.getName())) == null) {
                homonyms = ContainerUtil.newSmartList();
                byName.put(element.getName(), homonyms);
                res.add(homonyms);
            }
            homonyms.add(element);
        }
        return res;
    }

    @NotNull
    private static Set<PsiObject> findObjectsByNameAndKind(@NotNull SqlStatement root, @NotNull DbElement element) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/DeleteQueryGenerator", "findObjectsByNameAndKind"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DeleteQueryGenerator", "findObjectsByNameAndKind"));
        }
        JBIterable objects = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)root)).expand(Conditions.or((Condition)Conditions.is((Object)root), (Condition)Conditions.not((Condition)Conditions.instanceOf(SqlStatement.class))))).filter(PsiObject.class);
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        Casing casing = dialect.getCasing(element.getKind(), (DasObject)element.getDbParent());
        HashSet res = ContainerUtil.newHashSet();
        for (PsiObject object : objects) {
            if (!DeleteQueryGenerator.areEqual((DasObject)object, (DasObject)element, casing)) continue;
            res.add(object);
        }
        HashSet hashSet = res;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "findObjectsByNameAndKind"));
        }
        return hashSet;
    }

    @NotNull
    private static TextRange expandedRange(@NotNull SqlLanguageDialect dialect, @NotNull PsiElement start, @NotNull CharSequence text) {
        int ls;
        PsiElement tmp;
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/view/DeleteQueryGenerator", "expandedRange"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/view/DeleteQueryGenerator", "expandedRange"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/DeleteQueryGenerator", "expandedRange"));
        }
        TokenSet ws = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect)).getWhitespaceTokens();
        TokenSet sep = dialect.getStatementSeparators();
        PsiElement end = start;
        boolean lineEnd = false;
        while ((tmp = PsiTreeUtil.nextLeaf((PsiElement)end)) != null) {
            IElementType type;
            IElementType iElementType = type = tmp.getNode() == null ? null : tmp.getNode().getElementType();
            if (ws.contains(type)) {
                end = tmp;
                lineEnd = tmp.getText().contains("\n");
                if (!lineEnd) continue;
                break;
            }
            if (!sep.contains(type)) break;
            end = tmp;
            break;
        }
        for (ls = start.getTextRange().getStartOffset() - 1; ls > 0 && text.charAt(ls) == ' '; --ls) {
        }
        ++ls;
        int le = end.getTextRange().getEndOffset();
        if (!lineEnd) {
            ++le;
            while (le < text.length() && text.charAt(le) == ' ') {
                ++le;
            }
            if (le < text.length() && text.charAt(le) == '\n') {
                ++le;
            }
        }
        TextRange textRange = TextRange.create((int)ls, (int)le);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteQueryGenerator", "expandedRange"));
        }
        return textRange;
    }

    private static boolean areEqual(@NotNull DasObject a, @NotNull DasObject b, @NotNull Casing casing) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/database/view/DeleteQueryGenerator", "areEqual"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/database/view/DeleteQueryGenerator", "areEqual"));
        }
        if (casing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "casing", "com/intellij/database/view/DeleteQueryGenerator", "areEqual"));
        }
        if (a.getKind() != b.getKind()) {
            return false;
        }
        return DasUtil.nameEqual((DasObject)a, (String)b.getName(), (Casing)casing);
    }

    private static boolean areRoutinesEqual(@Nullable DasRoutine a, @Nullable DasRoutine b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getRoutineKind() != b.getRoutineKind()) {
            return false;
        }
        if (!DeleteQueryGenerator.areArgumentsEqual(a.getReturnArgument(), b.getReturnArgument())) {
            return false;
        }
        Iterator ait = a.getArguments().iterator();
        Iterator bit = b.getArguments().iterator();
        do {
            boolean aOk = ait.hasNext();
            boolean bOk = bit.hasNext();
            if (aOk && bOk) continue;
            return aOk == bOk;
        } while (DeleteQueryGenerator.areArgumentsEqual((DasArgument)ait.next(), (DasArgument)bit.next()));
        return false;
    }

    private static boolean areArgumentsEqual(@Nullable DasArgument a, @Nullable DasArgument b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.getArgumentDirection() != b.getArgumentDirection()) {
            return false;
        }
        return Comparing.equal((String)a.getDataType().getSpecification(), (String)b.getDataType().getSpecification());
    }

    private DdlBuilder generateDropColumnsAndIndexQueries(DatabaseDialectEx dialect, Set<DasTable> alreadyDroppedTables) {
        DbTable table;
        DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)this.myDataSource, false);
        if (this.myColumns.isEmpty() && this.myIndices.isEmpty()) {
            return builder;
        }
        if (dialect.supportsDropIndex()) {
            for (DbIndex index : this.myIndices) {
                String indexName = index.getName();
                if (QNameUtil.isFakeName(indexName) || alreadyDroppedTables.contains((table = (DbTable)index.getParent()).getDelegate())) continue;
                dialect.sqlDropIndex(builder, (DasTable)table.getDelegate(), (DasIndex)index, indexName, true).newStatement();
            }
        }
        Map classify = ContainerUtil.classify(this.myColumns.iterator(), (Convertor)new Convertor<DbColumn, DbTable>(){

            public DbTable convert(DbColumn o) {
                return o.getDbParent();
            }
        });
        for (Map.Entry entry : classify.entrySet()) {
            table = (DbTable)entry.getKey();
            Set columns = (Set)entry.getValue();
            TreeSet<String> columnNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (DbElement c : columns) {
                columnNames.add(c.getName());
            }
            if (dialect.supportsDropForeignKey()) {
                for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)table)) {
                    TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    Iterables.addAll(treeSet, (Iterable)key.getColumnsRef().names());
                    if (!columnNames.containsAll(treeSet) || this.myForeignKeys.contains(key)) continue;
                    dialect.sqlDropForeignKey(builder, (DasTable)table, key, key.getName()).newStatement();
                }
            }
            LinkedHashSet droppedIndices = ContainerUtil.newLinkedHashSet();
            if (dialect.supportsDropIndex()) {
                for (DasIndex dasIndex : DasUtil.getIndices((DasTable)table)) {
                    TreeSet indexCols = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                    Iterables.addAll(indexCols, (Iterable)dasIndex.getColumnsRef().names());
                    if (!columnNames.containsAll(indexCols) || droppedIndices.contains(dasIndex) || this.myIndices.contains(dasIndex)) continue;
                    dialect.sqlDropIndex(builder, (DasTable)table, dasIndex, dasIndex.getName(), false).newStatement();
                    droppedIndices.add(dasIndex);
                }
            }
            if (alreadyDroppedTables.contains(table.getDelegate())) continue;
            if (Iterables.size((Iterable)DasUtil.getColumns((DasObject)table)) == columns.size() && !dialect.supportsEmptyTables()) {
                dialect.sqlDropTable(builder, (DasTable)table.getDelegate(), false, false, this.myDataSource.getModel()).newStatement();
                continue;
            }
            if (!dialect.supportsDropColumn()) continue;
            for (DbElement dbElement : this.myColumns) {
                if (!(dbElement.getDelegate() instanceof DasColumn)) continue;
                dialect.sqlDropColumn(builder, (DasColumn)dbElement.getDelegate()).newStatement();
            }
        }
        return builder;
    }
}

