/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.google.common.collect.Iterables;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteTableHelper {
    @NotNull
    public static List<DasTable> getDeletionOrder(@NotNull DasModel model, @NotNull List<DasTable> tables, boolean checkConstraints) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/DeleteTableHelper", "getDeletionOrder"));
        }
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/view/DeleteTableHelper", "getDeletionOrder"));
        }
        List<DasTable> insertionOrder = DeleteTableHelper.getInsertionOrder(model, tables);
        Collections.reverse(insertionOrder);
        if (checkConstraints) {
            DeleteTableHelper.checkConstraints(model, insertionOrder);
        }
        List<DasTable> list = insertionOrder;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteTableHelper", "getDeletionOrder"));
        }
        return list;
    }

    private static void checkConstraints(DasModel model, @NotNull List<DasTable> order) {
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/database/view/DeleteTableHelper", "checkConstraints"));
        }
        ArrayList<DasForeignKey> droppedFk = new ArrayList<DasForeignKey>(0);
        for (DasTable table : order) {
            for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)table)) {
                droppedFk.add(key);
            }
        }
        for (DasTable table : order) {
            for (DasConstraint exportKey : model.getExportedKeys(table)) {
                if (DeleteTableHelper.isDeleted(table, exportKey, droppedFk)) continue;
                String message = "Can not delete table " + table.getName() + ", because constraint " + StringUtil.notNullize((String)exportKey.getName()) + " exists on " + "table " + StringUtil.notNullize((String)exportKey.getTableName()) + ".";
                throw new UnsupportedOperationException(message);
            }
        }
    }

    private static boolean isDeleted(final @NotNull DasTable table, final @NotNull DasConstraint exportedKey, @NotNull List<DasForeignKey> fks) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/view/DeleteTableHelper", "isDeleted"));
        }
        if (exportedKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedKey", "com/intellij/database/view/DeleteTableHelper", "isDeleted"));
        }
        if (fks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fks", "com/intellij/database/view/DeleteTableHelper", "isDeleted"));
        }
        DasForeignKey deletedKey = (DasForeignKey)ContainerUtil.find(fks, (Condition)new Condition<DasForeignKey>(){

            public boolean value(@NotNull DasForeignKey o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/DeleteTableHelper$1", "value"));
                }
                return (QNameUtil.isFakeName(exportedKey.getName()) || Comparing.strEqual((String)o.getName(), (String)exportedKey.getName())) && Comparing.strEqual((String)o.getRefTableName(), (String)table.getName(), (boolean)false) && Comparing.strEqual((String)o.getRefTableSchema(), (String)DasUtil.getSchema((DasObject)table), (boolean)false) && Comparing.strEqual((String)o.getRefTableCatalog(), (String)DasUtil.getCatalog((DasObject)table), (boolean)false) && Comparing.strEqual((String)exportedKey.getTable().getName(), (String)o.getTable().getName(), (boolean)false) && Comparing.strEqual((String)DasUtil.getSchema((DasObject)exportedKey.getTable()), (String)DasUtil.getSchema((DasObject)o.getTable()), (boolean)false) && Comparing.strEqual((String)DasUtil.getCatalog((DasObject)exportedKey.getTable()), (String)DasUtil.getCatalog((DasObject)o.getTable()), (boolean)false);
            }
        });
        return deletedKey != null;
    }

    @NotNull
    public static List<DasTable> getInsertionOrder(DasModel model, @NotNull List<DasTable> tables) {
        if (tables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tables", "com/intellij/database/view/DeleteTableHelper", "getInsertionOrder"));
        }
        ArrayList<DasTable> result = new ArrayList<DasTable>();
        ArrayList<DasTable> unattached = new ArrayList<DasTable>();
        ArrayList<DasTable> children = new ArrayList<DasTable>();
        ArrayList<DasTable> parents = new ArrayList<DasTable>();
        ArrayList<DasTable> sandwiches = new ArrayList<DasTable>();
        for (DasTable table : tables) {
            JBIterable importedKeys = DasUtil.getForeignKeys((DasTable)table);
            JBIterable exportedKeys = model.getExportedKeys(table);
            if (Iterables.isEmpty((Iterable)importedKeys) && Iterables.isEmpty((Iterable)exportedKeys)) {
                unattached.add(table);
                continue;
            }
            if (!Iterables.isEmpty((Iterable)exportedKeys)) {
                if (!Iterables.isEmpty((Iterable)importedKeys)) {
                    sandwiches.add(table);
                    continue;
                }
                parents.add(table);
                continue;
            }
            children.add(table);
        }
        DeleteTableHelper.reorderTables(sandwiches);
        result.addAll(unattached);
        result.addAll(parents);
        result.addAll(sandwiches);
        result.addAll(children);
        ArrayList<DasTable> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DeleteTableHelper", "getInsertionOrder"));
        }
        return arrayList;
    }

    private static void reorderTables(@NotNull List<DasTable> sandwiches) {
        if (sandwiches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sandwiches", "com/intellij/database/view/DeleteTableHelper", "reorderTables"));
        }
        Collections.sort(sandwiches, new Comparator<DasTable>(){

            @Override
            public int compare(@NotNull DasTable t1, @NotNull DasTable t2) {
                if (t1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t1", "com/intellij/database/view/DeleteTableHelper$2", "compare"));
                }
                if (t2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t2", "com/intellij/database/view/DeleteTableHelper$2", "compare"));
                }
                JBIterable t1ImportedKeys = DasUtil.getForeignKeys((DasTable)t1);
                for (DasForeignKey info : t1ImportedKeys) {
                    if (!info.getTableName().equals(t2.getName())) continue;
                    return 1;
                }
                JBIterable t2ImportedKeys = DasUtil.getForeignKeys((DasTable)t2);
                for (DasForeignKey info : t2ImportedKeys) {
                    if (!info.getTableName().equals(t1.getName())) continue;
                    return -1;
                }
                if (Iterables.size((Iterable)DasUtil.getForeignKeys((DasTable)t1)) > Iterables.size((Iterable)t2ImportedKeys)) {
                    return 1;
                }
                if (Iterables.size((Iterable)DasUtil.getForeignKeys((DasTable)t1)) < Iterables.size((Iterable)t2ImportedKeys)) {
                    return -1;
                }
                return 0;
            }
        });
    }
}

