/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.BatchIndicesEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DatabaseBatchIndicesEditor
extends DatabaseEditorBaseEx {
    private JPanel myPanel;
    private JBTextField myNameTemplate;
    private ThreeStateCheckBox myUniqueBox;
    private JBLabel myHintLabel;
    private LinkLabel myHelpLabel;
    private final BatchIndicesEditorModel myIndicesModel;
    private Consumer<List<DeIndex>> myDefaultNameGenerator;

    public DatabaseBatchIndicesEditor(@NotNull DatabaseEditorState state, @NotNull BatchIndicesEditorModel model) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "<init>"));
        }
        super(state);
        this.myIndicesModel = model;
        this.myDefaultNameGenerator = model.getNameGenerator();
        this.$$$setupUI$$$();
        new AnAction("Help"){

            public void actionPerformed(AnActionEvent e) {
                DatabaseBatchIndicesEditor.this.showHint();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("QuickJavaDoc")), (JComponent)this.myNameTemplate);
        this.myNameTemplate.setText(this.getNameGeneratorPattern());
        this.myNameTemplate.getEmptyText().setText(this.myDefaultNameGenerator.toString());
        this.myHintLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        this.setupControls();
        this.updateFromModel();
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    private void initSubscriptions() {
        this.myNameTemplate.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!DatabaseBatchIndicesEditor.this.myUpdating) {
                    DatabaseBatchIndicesEditor.this.myIndicesModel.setNameGenerator((Consumer<List<DeIndex>>)(DatabaseBatchIndicesEditor.this.myNameTemplate.getText().isEmpty() ? DatabaseBatchIndicesEditor.this.myDefaultNameGenerator : new BatchIndicesEditorModel.PatternNameGenerator(DatabaseBatchIndicesEditor.this.myNameTemplate.getText())));
                    DatabaseBatchIndicesEditor.this.myIndicesModel.commit();
                }
            }
        });
        this.myUniqueBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DatabaseBatchIndicesEditor.this.myUpdating) {
                    ThreeStateCheckBox.State state = DatabaseBatchIndicesEditor.this.myUniqueBox.getState();
                    DatabaseBatchIndicesEditor.this.myIndicesModel.setUniqueGenerator(state == ThreeStateCheckBox.State.DONT_CARE ? BatchIndicesEditorModel.PREV_UNIQUE_GENERATOR : (state == ThreeStateCheckBox.State.SELECTED ? BatchIndicesEditorModel.TRUE_UNIQUE_GENERATOR : BatchIndicesEditorModel.FALSE_UNIQUE_GENERATOR));
                    DatabaseBatchIndicesEditor.this.myIndicesModel.commit();
                }
            }
        });
        this.myIndicesModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseBatchIndicesEditor.this.updateUi();
            }
        }, this);
    }

    @Override
    @NotNull
    public EditorModelBase getModel() {
        BatchIndicesEditorModel batchIndicesEditorModel = this.myIndicesModel;
        if (batchIndicesEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "getModel"));
        }
        return batchIndicesEditorModel;
    }

    @NotNull
    private String getNameGeneratorPattern() {
        BatchIndicesEditorModel.PatternNameGenerator generator = (BatchIndicesEditorModel.PatternNameGenerator)ObjectUtils.tryCast(this.myIndicesModel.getNameGenerator(), BatchIndicesEditorModel.PatternNameGenerator.class);
        String string = generator == null ? "" : generator.getPattern();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "getNameGeneratorPattern"));
        }
        return string;
    }

    @Override
    protected void updateFromModelImpl() {
        if (this.myIndicesModel.getNameGenerator() != this.myDefaultNameGenerator || !this.myNameTemplate.getText().isEmpty()) {
            DatabaseBatchIndicesEditor.setValue((JTextField)this.myNameTemplate, this.getNameGeneratorPattern());
        }
        DatabaseBatchIndicesEditor.setValue(this.myUniqueBox, this.myIndicesModel.isUnique());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.myNameTemplate;
        if (jBTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "getPreferredFocusedComponent"));
        }
        return jBTextField;
    }

    public void setUniqueRevertStateEnabled(boolean enabled) {
        this.myUniqueBox.setThirdStateEnabled(enabled);
    }

    private void createUIComponents() {
        this.myHelpLabel = new LinkLabel("[?]", null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel aSource, Void aLinkData) {
                DatabaseBatchIndicesEditor.this.showHint();
            }
        });
    }

    public void setHintText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor", "setHintText"));
        }
        this.myHintLabel.setText(text);
    }

    public void showHint() {
        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createInformationLabel((String)"Template can contain:<ul><li><b>{table}</b> table name;</li><li><b>{columns}</b> concatenated list of columns</li></ul>Default: {table}_{columns}_index")).setFillColor(HintUtil.INFORMATION_COLOR).setHideOnClickOutside(true).setHideOnAction(true).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/editors/DatabaseBatchIndicesEditor$6", "actionPerformed"));
                }
            }
        }, true).createBalloon().show(RelativePoint.getSouthWestOf((JComponent)this.myNameTemplate), Balloon.Position.below);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        ThreeStateCheckBox threeStateCheckBox;
        JBTextField jBTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myNameTemplate = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUniqueBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setText("Unique");
        threeStateCheckBox.setMnemonic('U');
        threeStateCheckBox.setDisplayedMnemonicIndex(0);
        threeStateCheckBox.setThirdStateEnabled(true);
        jPanel2.add((Component)threeStateCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myHintLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name template:");
        jBLabel2.setDisplayedMnemonic('N');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        LinkLabel linkLabel = this.myHelpLabel;
        linkLabel.setText("[?]");
        jPanel3.add((Component)linkLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        jBLabel2.setLabelFor((Component)jBTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

