/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.view.editors.DatabaseColumnRefEditor;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseForeignKeyEditor;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.ForeignKeyEditorModel;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DatabaseForeignKeyRefEditor
implements DatabaseEditorUtil.EmbeddableEditor {
    private final DatabaseForeignKeyEditor myForeignKeyEditor;
    private JPanel myPanel;
    private final DatabaseColumnRefEditor myRefEditor;
    private final DatabaseColumnRefEditor myTargetEditor;
    private EditorTextField myRefEditorComponent;
    private EditorTextField myTargetEditorComponent;
    private boolean myValid;

    public DatabaseForeignKeyRefEditor(@NotNull DatabaseForeignKeyEditor foreignKeyEditor) {
        if (foreignKeyEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreignKeyEditor", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "<init>"));
        }
        this.myForeignKeyEditor = foreignKeyEditor;
        this.myRefEditor = new DatabaseColumnRefEditor(this.myForeignKeyEditor.getContext());
        this.myTargetEditor = new DatabaseColumnRefEditor(this.myForeignKeyEditor.getContext());
        this.$$$setupUI$$$();
        this.myRefEditor.getEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!((DatabaseForeignKeyRefEditor)DatabaseForeignKeyRefEditor.this).myForeignKeyEditor.myUpdating) {
                    ArrayList refs = ContainerUtil.newArrayList(DatabaseForeignKeyRefEditor.this.getForeignKeyModel().getRefs());
                    int index = DatabaseForeignKeyRefEditor.this.myForeignKeyEditor.getIndex(DatabaseForeignKeyRefEditor.this);
                    DeColumn item = DatabaseForeignKeyRefEditor.this.getRef();
                    refs.set(index, new DeForeignKey.Ref(item, ((DeForeignKey.Ref)refs.get((int)index)).target));
                    DatabaseForeignKeyRefEditor.this.getForeignKeyModel().setRefs(refs);
                    DatabaseForeignKeyRefEditor.this.getForeignKeyModel().commit();
                }
            }
        });
        this.myTargetEditor.getEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!((DatabaseForeignKeyRefEditor)DatabaseForeignKeyRefEditor.this).myForeignKeyEditor.myUpdating) {
                    ArrayList refs = ContainerUtil.newArrayList(DatabaseForeignKeyRefEditor.this.getForeignKeyModel().getRefs());
                    int index = DatabaseForeignKeyRefEditor.this.myForeignKeyEditor.getIndex(DatabaseForeignKeyRefEditor.this);
                    DeColumn item = DatabaseForeignKeyRefEditor.this.getTarget();
                    refs.set(index, new DeForeignKey.Ref(((DeForeignKey.Ref)refs.get((int)index)).ref, item));
                    DatabaseForeignKeyRefEditor.this.getForeignKeyModel().setRefs(refs);
                    DatabaseForeignKeyRefEditor.this.getForeignKeyModel().commit();
                }
            }
        });
    }

    @NotNull
    private ForeignKeyEditorModel getForeignKeyModel() {
        ForeignKeyEditorModel foreignKeyEditorModel = this.myForeignKeyEditor.getForeignKeyModel();
        if (foreignKeyEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getForeignKeyModel"));
        }
        return foreignKeyEditorModel;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        DeColumn target = this.getTarget();
        Iterable<Pair<String, TextAttributesKey>> iterable = new DatabaseEditorUtil.ColoredFragmentsBuilder().append(this.myForeignKeyEditor.getObjectName(this.getRef())).append(" REFERENCES ").appendRef(this.myForeignKeyEditor.getObjectName(target), !EditorModelUtil.isStub(target)).build();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getRowText"));
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myValid;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myRefEditorComponent.getFocusTarget();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = new JComponent[]{this.myRefEditorComponent.getFocusTarget(), this.myTargetEditorComponent.getFocusTarget()};
        if (jComponentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getFocusableComponents"));
        }
        return jComponentArray;
    }

    @NotNull
    public DeColumn getRef() {
        DeColumn deColumn = this.myRefEditor.getObjectOrStub(this.myForeignKeyEditor.getTable());
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getRef"));
        }
        return deColumn;
    }

    @NotNull
    public DeColumn getTarget() {
        DeColumn deColumn = this.myTargetEditor.getObjectOrStub(this.myForeignKeyEditor.getTable());
        if (deColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getTarget"));
        }
        return deColumn;
    }

    public void updateFromModel(int idx) {
        DeForeignKey.Ref ref = this.getForeignKeyModel().getRefs().get(idx);
        this.myRefEditor.setTable(this.myForeignKeyEditor.getTable());
        this.myTargetEditor.setTable(this.myForeignKeyEditor.getTargetTable());
        this.myRefEditor.setObject(ref.ref);
        this.myTargetEditor.setObject(ref.target);
        this.myValid = ref.ref != null && !EditorModelUtil.isStub(ref.ref) && ref.ref.isInTable() && ref.target != null && !EditorModelUtil.isStub(ref.target) && ref.target.isInTable();
    }

    @NotNull
    public DeForeignKey.Ref getItem() {
        DeForeignKey.Ref ref = this.myForeignKeyEditor.getForeignKey().refs.get(this.myForeignKeyEditor.getIndex(this));
        if (ref == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getItem"));
        }
        return ref;
    }

    @NotNull
    public DatabaseForeignKeyEditor getForeignKeyEditor() {
        DatabaseForeignKeyEditor databaseForeignKeyEditor = this.myForeignKeyEditor;
        if (databaseForeignKeyEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getForeignKeyEditor"));
        }
        return databaseForeignKeyEditor;
    }

    @Override
    public boolean canDoAnything() {
        return true;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public EditorTextField getRefEditor() {
        EditorTextField editorTextField = this.myRefEditorComponent;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getRefEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField getTargetEditor() {
        EditorTextField editorTextField = this.myTargetEditorComponent;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseForeignKeyRefEditor", "getTargetEditor"));
        }
        return editorTextField;
    }

    private void createUIComponents() {
        this.myRefEditorComponent = this.myRefEditor.getEditor();
        this.myTargetEditorComponent = this.myTargetEditor.getEditor();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("From:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("To:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        EditorTextField editorTextField = this.myRefEditorComponent;
        jPanel.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        EditorTextField editorTextField2 = this.myTargetEditorComponent;
        jPanel.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

