/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectRefEditor<Das extends DasObject> {
    private final EditorTextField myEditor;
    private final DatabaseEditorContext myContext;
    private JBIterable<Das> myItems;

    public DatabaseObjectRefEditor(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DatabaseObjectRefEditor", "<init>"));
        }
        this.myItems = JBIterable.empty();
        this.myContext = context;
        this.myEditor = new TextFieldWithAutoCompletion(this.myContext.getProject(), (TextFieldWithAutoCompletionListProvider)new MyCompletionProvider(), false, "");
        this.myEditor.addSettingsProvider(new EditorSettingsProvider(){

            public void customizeSettings(EditorEx editor) {
                editor.setHighlighter((EditorHighlighter)new EmptyEditorHighlighter(editor.getColorsScheme().getAttributes(HighlighterColors.TEXT)));
                DatabaseObjectRefEditor.this.updateAdditionalHighlighting((Editor)editor);
            }
        });
    }

    public void setItems(@NotNull JBIterable<Das> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/view/editors/DatabaseObjectRefEditor", "setItems"));
        }
        this.myItems = items;
    }

    @NotNull
    public EditorTextField getEditor() {
        EditorTextField editorTextField = this.myEditor;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectRefEditor", "getEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public String getName() {
        String string = this.myContext.getDialect().unquoteIdentifier(this.myEditor.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectRefEditor", "getName"));
        }
        return string;
    }

    @Nullable
    public Das getObject() {
        return (Das)((DasObject)this.myItems.filter(DasUtil.byName((String)this.getName(), (CasingProvider)this.myContext.getModel())).first());
    }

    @Nullable
    protected Icon getIcon(@NotNull Das item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseObjectRefEditor", "getIcon"));
        }
        return null;
    }

    public void setObject(@Nullable Das obj) {
        String text;
        String string = text = obj == null ? "" : obj.getName();
        if (!text.equals(this.getName())) {
            this.myEditor.setText(obj == null ? "" : this.myContext.getDialect().quoteIdentifier(obj.getName(), false, false));
        }
        this.updateAdditionalHighlighting(this.myEditor.getEditor());
    }

    protected void updateAdditionalHighlighting(@Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        editor.getMarkupModel().removeAllHighlighters();
        if (this.getObject() == null) {
            TextAttributes attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES);
            editor.getMarkupModel().addRangeHighlighter(0, this.myEditor.getText().length(), 3000, attributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private class MyCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<Das> {
        public MyCompletionProvider() {
            super(Collections.emptyList());
        }

        @Nullable
        protected Icon getIcon(@NotNull Das item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider", "getIcon"));
            }
            return DatabaseObjectRefEditor.this.getIcon(item);
        }

        @NotNull
        protected String getLookupString(@NotNull Das item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider", "getLookupString"));
            }
            String string = DatabaseObjectRefEditor.this.myContext.getDialect().quoteIdentifier(item.getName(), false, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Nullable
        protected String getTailText(@NotNull Das item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider", "getTailText"));
            }
            return null;
        }

        @Nullable
        protected String getTypeText(@NotNull Das item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider", "getTypeText"));
            }
            return null;
        }

        public int compare(Das item1, Das item2) {
            return StringUtil.naturalCompare((String)item1.getName(), (String)item2.getName());
        }

        @NotNull
        public Collection<Das> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            final PrefixMatcher matcher = this.createPrefixMatcher(prefix);
            JBIterable items = DatabaseObjectRefEditor.this.myItems;
            if (matcher != null) {
                items = items.filter(new Condition<Das>(){

                    public boolean value(Das de) {
                        return matcher.prefixMatches(de.getName());
                    }
                });
            }
            ArrayList res = ContainerUtil.newArrayList((Iterable)items.take(100));
            Collections.sort(res, new Comparator<Das>(){

                @Override
                public int compare(Das o1, Das o2) {
                    return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
                }
            });
            ArrayList arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseObjectRefEditor$MyCompletionProvider", "getItems"));
            }
            return arrayList;
        }
    }
}

