/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseKeyEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ArrayUtil;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableKeyEditor
extends DatabaseEditorBaseEx
implements DatabaseEditorUtil.EmbeddableEditor {
    private final DatabaseKeyEditor myKeyEditor;
    private final TableEditorModel myTableModel;
    @NotNull
    private final DatabaseEditorCapabilities.TableKeyEditorCaps myCaps;
    private final JCheckBox myPrimaryKeyCheckBox;
    private final EditorModelBase.Listener myObjectListener;

    public DatabaseTableKeyEditor(@NotNull DatabaseEditorState state, @NotNull TableEditorModel tableModel, @NotNull TableKeyEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableKeyEditorCaps keyCaps) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "<init>"));
        }
        if (columnModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "<init>"));
        }
        if (keyCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyCaps", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "<init>"));
        }
        super(state);
        this.myObjectListener = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableKeyEditor.this.updateUi();
            }
        };
        this.myTableModel = tableModel;
        this.myCaps = keyCaps;
        this.myKeyEditor = new DatabaseKeyEditor(state, columnModel, keyCaps);
        Disposer.register((Disposable)this, (Disposable)this.myKeyEditor);
        this.myPrimaryKeyCheckBox = new JBCheckBox("Primary key");
        this.myKeyEditor.addComponent(this.myPrimaryKeyCheckBox);
        this.myPrimaryKeyCheckBox.setMnemonic(80);
        this.myPrimaryKeyCheckBox.setVisible(this.myCaps.getPrimaryKey().isSupported());
        this.myPrimaryKeyCheckBox.setEnabled(this.myCaps.getPrimaryKey().isAvailable());
        this.initSubscriptions();
        this.updateFromModel();
    }

    private void initSubscriptions() {
        this.myTableModel.addListener(this.myObjectListener, this);
        this.getTableKeyModel().addListener(this.myObjectListener, this);
        this.myPrimaryKeyCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DatabaseTableKeyEditor.this.myUpdating) {
                    return;
                }
                DatabaseTableKeyEditor.this.myTableModel.setPrimaryKey(DatabaseTableKeyEditor.this.myPrimaryKeyCheckBox.isSelected() ? DatabaseTableKeyEditor.this.myKeyEditor.getTableKey() : null);
                DatabaseTableKeyEditor.this.myTableModel.commit();
            }
        });
    }

    @NotNull
    public TableKeyEditorModel getTableKeyModel() {
        TableKeyEditorModel tableKeyEditorModel = this.myKeyEditor.getTableKeyModel();
        if (tableKeyEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getTableKeyModel"));
        }
        return tableKeyEditorModel;
    }

    @NotNull
    public DeTableKey getTableKey() {
        DeTableKey deTableKey = (DeTableKey)this.getTableKeyModel().getObject();
        if (deTableKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getTableKey"));
        }
        return deTableKey;
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getTable"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeTable> getModel() {
        TableEditorModel tableEditorModel = this.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getModel"));
        }
        return tableEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseTableKeyEditor.setValue(this.myPrimaryKeyCheckBox, this.getTableKey().isPrimary());
    }

    public DatabaseKeyEditor getKeyEditor() {
        return this.myKeyEditor;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableModel;
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myKeyEditor.getPreferredFocusedComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    @Override
    public boolean canDoAnything() {
        return this.myCaps.canDoAnything();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myKeyEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent[] getFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])this.myKeyEditor.getFocusableComponents(), (Object[])new JComponent[]{this.myPrimaryKeyCheckBox});
        if (jComponentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getFocusableComponents"));
        }
        return jComponentArray;
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        Iterable<Pair<String, TextAttributesKey>> iterable = this.myKeyEditor.getRowText();
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getRowText"));
        }
        return iterable;
    }

    @Override
    public boolean isObjectValid() {
        return this.myKeyEditor.isObjectValid();
    }

    @NotNull
    public JCheckBox getPrimaryKeyCheckBox() {
        JCheckBox jCheckBox = this.myPrimaryKeyCheckBox;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getPrimaryKeyCheckBox"));
        }
        return jCheckBox;
    }

    @Override
    @Nullable
    public DeObject getKeyObject() {
        return this.getTableKey();
    }

    @NotNull
    public static DatabaseEditorCapabilities.TableKeyEditorCaps getTableKeyCaps(@NotNull DatabaseEditorCapabilities.TableEditorCaps tableCaps, @Nullable DasTable table, @Nullable DasTableKey key) {
        if (tableCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableCaps", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getTableKeyCaps"));
        }
        assert (table != null || key == null);
        DasTableKey pk = table == null ? null : DasUtil.getPrimaryKey((DasTable)table);
        boolean isPk = pk != null && key != null && key.isPrimary();
        DatabaseEditorCapabilities.TableKeyEditorCaps tableKeyEditorCaps = new DatabaseEditorCapabilities.TableKeyEditorCaps(tableCaps, tableCaps.getKeyCaps(key != null), pk != null, isPk);
        if (tableKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getTableKeyCaps"));
        }
        return tableKeyEditorCaps;
    }

    @NotNull
    public DatabaseEditorCapabilities.TableKeyEditorCaps getCaps() {
        DatabaseEditorCapabilities.TableKeyEditorCaps tableKeyEditorCaps = this.myCaps;
        if (tableKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeyEditor", "getCaps"));
        }
        return tableKeyEditorCaps;
    }
}

