/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.editors.DatabaseTableKeyEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableKeysEditor
extends DatabaseTableEditor.TabProvider {
    private JPanel myPanel;
    private DatabaseEditorUtil.DbListTableWithEditor myTable;
    private ListTableModel<DatabaseTableKeyEditor> myTableKeysModel;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;

    public DatabaseTableKeysEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "<init>"));
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myTableKeysModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseTableKeyEditor>(){

            @Override
            @Nullable
            public DatabaseTableKeyEditor createRow() {
                if (!DatabaseTableKeysEditor.this.myCaps.getAltKeys().canAdd()) {
                    return null;
                }
                DeTableKey key = DatabaseTableKeysEditor.this.getTableModel().createTableKey("", new DeColumn[0]);
                DatabaseTableKeysEditor.this.getTableModel().addTableKey(key);
                return DatabaseTableKeysEditor.this.createTableKeyEditor(key);
            }

            @Override
            public boolean removeRow(DatabaseTableKeyEditor item, int idx) {
                if (!DatabaseTableKeysEditor.this.myCaps.getAltKeys().canRemove()) {
                    return false;
                }
                DatabaseTableKeysEditor.this.getTableModel().removeTableKey((DeTableKey)item.getTableKeyModel().getObject());
                Disposer.dispose((Disposable)item);
                return true;
            }
        }, true);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myTableKeysModel, this.myTableEditor, 4, JBUI.scale((int)500), null);
        this.myTable.getTable().getEmptyText().setText("No keys");
        DatabaseEditorUtil.FlagUpdater keysAddable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getAltKeys().canAdd());
        DatabaseEditorUtil.FlagUpdater keysRemovable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getAltKeys().canRemove());
        DatabaseEditorUtil.FlagUpdater keysReorderable = new DatabaseEditorUtil.FlagUpdater(this.myCaps.getAltKeys().canReorder());
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myTable.getTable()).setAddActionUpdater((AnActionButtonUpdater)keysAddable).setRemoveActionUpdater((AnActionButtonUpdater)keysRemovable).setMoveUpActionUpdater((AnActionButtonUpdater)keysReorderable).setMoveDownActionUpdater((AnActionButtonUpdater)keysReorderable);
        this.myPanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myPanel, (JTable)this.myTable.getTable());
        this.myPanel.setBorder(BORDER);
    }

    @Nullable
    public DatabaseTableKeyEditor startItemEditing(@NotNull DeTableKey column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "startItemEditing"));
        }
        return DatabaseEditorUtil.startItemEditing(column, this.myTable, this.myTableKeysModel);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getTableModel"));
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseTableKeyEditor createTableKeyEditor(@NotNull DeTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "createTableKeyEditor"));
        }
        DatabaseTableKeyEditor editor = new DatabaseTableKeyEditor(this.myTableEditor.getState(), this.getTableModel(), this.getTableModel().modelsCache.get(key, TableKeyEditorModel.class), this.getTableKeyCaps(key));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getTableKeyModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableKeysEditor.this.myTableEditor.updateUi();
            }
        }, this.myTableEditor);
        DatabaseTableKeyEditor databaseTableKeyEditor = editor;
        if (databaseTableKeyEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "createTableKeyEditor"));
        }
        return databaseTableKeyEditor;
    }

    @NotNull
    private DatabaseEditorCapabilities.TableKeyEditorCaps getTableKeyCaps(@NotNull DeTableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getTableKeyCaps"));
        }
        DasTable table = (DasTable)this.getTable().editedObject;
        DasTableKey edKey = (DasTableKey)key.editedObject;
        DatabaseEditorCapabilities.TableKeyEditorCaps tableKeyEditorCaps = DatabaseTableKeyEditor.getTableKeyCaps(this.myCaps, table, edKey);
        if (tableKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getTableKeyCaps"));
        }
        return tableKeyEditorCaps;
    }

    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myTableKeysModel, this.getTableModel().getTableKeys(), new Function<DeTableKey, DatabaseTableKeyEditor>(){

            public DatabaseTableKeyEditor fun(DeTableKey column) {
                return DatabaseTableKeysEditor.this.createTableKeyEditor(column);
            }
        });
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getTable"));
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count = this.getTableModel().getTableKeysCount();
        String string = "Keys" + (count == 0 ? "" : " (" + count + ")");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getTabTitle"));
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseTableKeyEditor> getKeysListModel() {
        ListTableModel<DatabaseTableKeyEditor> listTableModel = this.myTableKeysModel;
        if (listTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getKeysListModel"));
        }
        return listTableModel;
    }

    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myTableKeysModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getAltKeys();
        if (listCapability == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseTableKeysEditor", "getCaps"));
        }
        return listCapability;
    }
}

