/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbRefactoringHelper {
    public static final AbstractDbRefactoringDialog.ResultProcessor PROCESSOR_STUB = new AbstractDbRefactoringDialog.ResultProcessor(){

        @Override
        @Nullable
        public JComponent getPreviewWidget() {
            return null;
        }

        @Override
        public boolean process() {
            return false;
        }

        @Override
        @NotNull
        public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/DbRefactoringHelper$1", "createTraverser"));
            }
            DdlPreview.ModelTraverser modelTraverser = new DdlPreview.ModelTraverser(model.getModel());
            if (modelTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringHelper$1", "createTraverser"));
            }
            return modelTraverser;
        }

        @Override
        @Nullable
        public JComponent getSettingsPanel() {
            return null;
        }

        @Override
        public String getCurrentAction() {
            return "OK";
        }

        @Override
        public void update() {
        }

        @Override
        public ValidationInfo validate() {
            return null;
        }
    };
    public static final TableDialogSettings.Settings DB_SETTINGS = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.EXEC_IN_DB, TableDialogSettings.Settings.CodeType.ALTER_CODE);
    public static final TableDialogSettings.Settings SQL_SETTINGS = new TableDialogSettings.Settings(TableDialogSettings.Settings.FinalAction.REPLACE_DDL, TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE);

    public static boolean isForceCreate(@NotNull DasObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/DbRefactoringHelper", "isForceCreate"));
        }
        return object instanceof SqlElement;
    }

    @Nullable
    public static DatabaseEditorContext createContext(@NotNull DasObject obj, @Nullable PsiElement place) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DbRefactoringHelper", "createContext"));
        }
        if (place != null && place.getContainingFile() instanceof SqlFile) {
            return DatabaseEditorContext.forFile((SqlFile)place.getContainingFile());
        }
        if (obj instanceof DbElement) {
            return new DatabaseEditorContext(((DbElement)obj).getDataSource(), null);
        }
        if (obj instanceof SqlElement) {
            return DatabaseEditorContext.forFile((SqlFile)((SqlElement)obj).getContainingFile());
        }
        return null;
    }

    @NotNull
    public static AbstractDbRefactoringDialog.ResultProcessor getResultProcessor(@NotNull DasObject obj, @NotNull AbstractDbRefactoringDialog<?> dialog, @Nullable PsiElement place) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/view/ui/DbRefactoringHelper", "getResultProcessor"));
        }
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/database/view/ui/DbRefactoringHelper", "getResultProcessor"));
        }
        if (obj instanceof DbElement) {
            GenericEditingResultProcessor genericEditingResultProcessor = new GenericEditingResultProcessor(dialog, DB_SETTINGS, DbRefactoringHelper.getPlace(place));
            if (genericEditingResultProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringHelper", "getResultProcessor"));
            }
            return genericEditingResultProcessor;
        }
        if (obj instanceof SqlElement) {
            GenericEditingResultProcessor genericEditingResultProcessor = new GenericEditingResultProcessor(dialog, SQL_SETTINGS, DbRefactoringHelper.getPlace(place));
            if (genericEditingResultProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringHelper", "getResultProcessor"));
            }
            return genericEditingResultProcessor;
        }
        AbstractDbRefactoringDialog.ResultProcessor resultProcessor = PROCESSOR_STUB;
        if (resultProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringHelper", "getResultProcessor"));
        }
        return resultProcessor;
    }

    @Nullable
    public static RangeMarker getPlace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        int offset = element.getTextRange().getStartOffset();
        return document.createRangeMarker(offset, offset);
    }

    public static boolean isTableOrEditableTableChild(@NotNull DasObject o, @NotNull DatabaseEditorContext context) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/ui/DbRefactoringHelper", "isTableOrEditableTableChild"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringHelper", "isTableOrEditableTableChild"));
        }
        return DbRefactoringHelper.isEditable(o, context) && (o instanceof DasTable || o instanceof DasTableChild);
    }

    public static boolean isEditable(@NotNull DasObject o, @NotNull DatabaseEditorContext context) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/view/ui/DbRefactoringHelper", "isEditable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/DbRefactoringHelper", "isEditable"));
        }
        return context.getDialect().getSchemaEditor().canExport(o);
    }

    public static enum ObjectLocation {
        DATABASE("Database"),
        CODE("Code");

        private final String myTitle;

        private ObjectLocation(String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/ui/DbRefactoringHelper$ObjectLocation", "<init>"));
            }
            this.myTitle = title;
        }

        @Nullable
        public static ObjectLocation of(@Nullable DasObject obj) {
            if (obj instanceof DbElement) {
                return DATABASE;
            }
            if (obj instanceof SqlElement) {
                return CODE;
            }
            return null;
        }

        @NotNull
        public String toString() {
            String string = this.myTitle;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DbRefactoringHelper$ObjectLocation", "toString"));
            }
            return string;
        }
    }
}

