/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.run.ui.ErrorNotificationPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ErrorNotificationWrapperPanel
extends JPanel {
    private Runnable myCloseAction = new Runnable(){

        @Override
        public void run() {
            ErrorNotificationWrapperPanel.this.removeError();
        }
    };

    public ErrorNotificationWrapperPanel() {
        super(new BorderLayout());
    }

    public void reportError(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/ErrorNotificationWrapperPanel", "reportError"));
        }
        this.removeError();
        this.add((Component)this.buildErrorPanel(e), "South");
        this.revalidate();
    }

    public void removeError() {
        BorderLayout layout = (BorderLayout)this.getLayout();
        Component comp = layout.getLayoutComponent(this, "South");
        if (comp == null) {
            return;
        }
        this.remove(comp);
        this.revalidate();
    }

    @NotNull
    private ErrorNotificationPanel buildErrorPanel(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/ErrorNotificationWrapperPanel", "buildErrorPanel"));
        }
        ErrorNotificationPanel errorNotificationPanel = ErrorNotificationPanel.create(e, this).addDetailsButton().addCloseButton(this.myCloseAction).build();
        if (errorNotificationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/ErrorNotificationWrapperPanel", "buildErrorPanel"));
        }
        return errorNotificationPanel;
    }
}

