/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.openapi.util.Key;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.SeparatorWithText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiSeparatorListCellRenderer
extends CellRendererPanel
implements ListCellRenderer {
    private final List<SeparatorWithText> mySeparators = ContainerUtil.newArrayList();
    private final Container myValidationParent = new CellRendererPane();

    public MultiSeparatorListCellRenderer(JList list) {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        list.add(this.myValidationParent);
    }

    protected abstract JComponent getItemCellRendererComponent(JList var1, Object var2, int var3, boolean var4, boolean var5);

    protected abstract Collection<Object> querySeparators(@Nullable Object var1, @NotNull Object var2);

    protected abstract void configureSeparator(@NotNull SeparatorWithText var1, @NotNull Object var2);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Collection<Object> separators = this.querySeparators(index == 0 ? null : list.getModel().getElementAt(index - 1), value);
        JComponent itemComponent = this.getItemCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.rebuildChildren(separators, itemComponent);
        this.setPreferredSize(null);
        this.validate();
        boolean forExpansion = UIUtil.getClientProperty((JComponent)list, (Key)ExpandableItemsHandler.EXPANDED_RENDERER) == Boolean.TRUE;
        UIUtil.putClientProperty((JComponent)itemComponent, (Key)ExpandableItemsHandler.USE_RENDERER_BOUNDS, (Object)(forExpansion ? Boolean.valueOf(true) : null));
        if (forExpansion) {
            Rectangle bounds = list.getCellBounds(index, index);
            bounds.setSize(this.getPreferredSize().width, bounds.height);
            AbstractExpandableItemsHandler.setRelativeBounds((Component)((Object)this), (Rectangle)bounds, (Component)itemComponent, (Container)this.myValidationParent);
            return itemComponent;
        }
        return this;
    }

    @NotNull
    protected SeparatorWithText createSeparator() {
        SeparatorWithText separator = new SeparatorWithText();
        separator.setCaptionCentered(false);
        SeparatorWithText separatorWithText = separator;
        if (separatorWithText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/MultiSeparatorListCellRenderer", "createSeparator"));
        }
        return separatorWithText;
    }

    private void rebuildChildren(@NotNull Collection<Object> separators, @NotNull JComponent itemComponent) {
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "com/intellij/database/view/ui/MultiSeparatorListCellRenderer", "rebuildChildren"));
        }
        if (itemComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemComponent", "com/intellij/database/view/ui/MultiSeparatorListCellRenderer", "rebuildChildren"));
        }
        int separatorCount = separators.size();
        while (this.mySeparators.size() < separatorCount) {
            this.mySeparators.add(this.createSeparator());
        }
        int i = 0;
        for (Object object : separators) {
            this.configureSeparator(this.mySeparators.get(i), object);
            ++i;
        }
        if (separators.isEmpty() && this.getComponentCount() == 1 && this.getComponent(0) == itemComponent) {
            return;
        }
        this.removeAll();
        for (SeparatorWithText separatorWithText : this.mySeparators.subList(0, separatorCount)) {
            this.add((Component)separatorWithText);
        }
        this.add(itemComponent);
    }
}

