/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.BaseFamily;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.WrappedException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.ConstructorAccessor;

final class BasicFamily<C extends DbmObject>
extends BaseFamily<C> {
    @NotNull
    private final DbmObject myParent;
    @NotNull
    private final ConstructorAccessor myChildConstructor;
    private final boolean myOverloads;

    public BasicFamily(@NotNull DbmObject parent, @NotNull ObjectKind childKind, @NotNull Class<C> childClass) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/BasicFamily", "<init>"));
        }
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/BasicFamily", "<init>"));
        }
        if (childClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClass", "com/intellij/dbm/common/BasicFamily", "<init>"));
        }
        super(childKind, childClass);
        this.myParent = parent;
        this.myChildConstructor = ReflectionUtil.getConstructorAccessor(this.obtainChildConstructor(childClass));
        this.myOverloads = DbmOverloadable.class.isAssignableFrom(this.myChildClass);
    }

    @NotNull
    private <CC> Constructor<CC> obtainChildConstructor(@NotNull Class<CC> childClass) {
        if (childClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClass", "com/intellij/dbm/common/BasicFamily", "obtainChildConstructor"));
        }
        List constructors = ContainerUtil.filter((Object[])childClass.getDeclaredConstructors(), (Condition)new Condition<Constructor<?>>(){

            public boolean value(Constructor<?> constructor) {
                Class<?>[] types = constructor.getParameterTypes();
                return types.length == 2 && types[0].isAssignableFrom(BasicFamily.this.myParent.getClass()) && types[1].isAssignableFrom(String.class);
            }
        });
        assert (constructors.size() == 1) : "The class " + childClass.getSimpleName() + " should have a declared constructor (" + this.myParent.getClass().getSimpleName() + ", String)";
        Constructor constructor = (Constructor)constructors.get(0);
        constructor.setAccessible(true);
        Constructor constructor2 = constructor;
        if (constructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BasicFamily", "obtainChildConstructor"));
        }
        return constructor2;
    }

    @Override
    @NotNull
    public C create(@Nullable String name) {
        DbmObject child;
        Class childClass = this.getChildClass();
        assert (this.myChildKind != ObjectKind.NONE) : "The " + this.myParent.getClass().getSimpleName() + " cannot have children typed " + childClass.getSimpleName();
        this.modifying();
        try {
            child = (DbmObject)this.myChildConstructor.newInstance(new Object[]{this.myParent, name});
            this.doAddChild(child);
            child.setParentFamily(this);
            this.myParent.childBorn(child);
        }
        catch (InvocationTargetException ite) {
            Throwable realCause = ite.getTargetException();
            if (realCause == null) {
                realCause = ite.getCause();
            }
            if (realCause == null) {
                realCause = ite;
            }
            throw new WrappedException(realCause);
        }
        catch (InstantiationException ie) {
            String exceptionClassName;
            String message;
            Throwable e = ie.getCause();
            if (e != null) {
                message = e.getMessage();
                exceptionClassName = e.getClass().getSimpleName();
            } else {
                message = "<empty-message>";
                exceptionClassName = "<unknown-exception>";
            }
            String msg = String.format("Failed to instantiate a model object %s class %s (for parent %s): exception %s: %s", this.myChildKind.toString(), childClass.getSimpleName(), this.myParent.toString(), exceptionClassName, message);
            throw new WrappedException(msg, ie);
        }
        catch (Exception e) {
            String msg = String.format("Failed to instantiate a model object %s class %s (for parent %s): exception %s: %s", this.myChildKind.toString(), childClass.getSimpleName(), this.myParent.toString(), e.getClass().getSimpleName(), e.getMessage());
            throw new WrappedException(msg, e);
        }
        this.myParent.model.doingObjectCreate(child);
        DbmObject dbmObject = child;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BasicFamily", "create"));
        }
        return (C)dbmObject;
    }

    @Override
    public String getFamilyDescription() {
        return this.myParent.identity() + "." + StringUtil.pluralize((String)this.myChildKind.toString());
    }

    @Override
    @NotNull
    public C getOrCreate(@NotNull String name, String[] specItems) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BasicFamily", "getOrCreate"));
        }
        C child = this.getOverload(name, specItems, true);
        if (child == null) {
            child = this.create(name);
            if (specItems != null && specItems.length > 0) {
                DbmOverloadable ovChild = (DbmOverloadable)child;
                ovChild.setSpecItems(specItems);
            }
        }
        C c = child;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BasicFamily", "getOrCreate"));
        }
        return c;
    }

    @Override
    @Nullable
    public C getOverload(@NotNull String name, String[] specItems, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BasicFamily", "getOverload"));
        }
        if (this.myOverloads) {
            return this.getRealOverload(name, specItems, caseSensitively);
        }
        if (specItems == null || specItems.length == 0) {
            return this.get(name, caseSensitively);
        }
        throw new IllegalStateException(String.format("Family of kind %s (class %s) doesn't support overloads", this.myChildKind.code(), this.myChildClass.getSimpleName()));
    }

    @Nullable
    private C getRealOverload(@NotNull String name, String[] specItems, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BasicFamily", "getRealOverload"));
        }
        int m = specItems == null ? 0 : specItems.length;
        ImmutableList children = this.asList();
        for (DbmObject child : children) {
            DbmOverloadable ovChild;
            String childName = child.getNameOrEmpty();
            boolean matched = caseSensitively ? childName.equals(name) : childName.equalsIgnoreCase(name);
            if (!matched || !(ovChild = (DbmOverloadable)((Object)child)).isApplicableTo(specItems)) continue;
            return (C)child;
        }
        return null;
    }

    @Override
    protected void modifying() {
        this.myParent.modifyingFamily(this);
    }
}

