/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasConstraint;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmTableElement;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.util.Numbers;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmConstraint
extends DbmTableElement
implements DasConstraint {
    @StateProperty
    public final DomObjectsRef<DbmLikeColumn> myColumns;
    @StateProperty
    public boolean myDeferrable;
    @StateProperty
    public boolean myInitiallyDeferred;

    public DbmConstraint(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmConstraint", "<init>"));
        }
        super(table, name);
        this.myColumns = this.createColumnsRef(table);
    }

    protected abstract DomObjectsRef<DbmLikeColumn> createColumnsRef(@NotNull DbmLikeTable var1);

    public void addColumn(@NotNull String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/dbm/common/DbmConstraint", "addColumn"));
        }
        if (this.myColumns.contains(columnName)) {
            throw new IllegalArgumentException(String.format("%s %s already contains column %s.", this.kind(), this.getName(), columnName));
        }
        this.modifying();
        this.myColumns.add(columnName);
    }

    @NotNull
    public DomObjectsRef<DbmLikeColumn> getColumnsRef() {
        DomObjectsRef<DbmLikeColumn> domObjectsRef = this.myColumns;
        if (domObjectsRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmConstraint", "getColumnsRef"));
        }
        return domObjectsRef;
    }

    @Override
    @NotNull
    public DbmObject parent() {
        DbmLikeTable dbmLikeTable = this.table;
        if (dbmLikeTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmConstraint", "parent"));
        }
        return dbmLikeTable;
    }

    public void setColumnNames(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DbmConstraint", "setColumnNames"));
        }
        this.modifying();
        this.myColumns.setAll(names);
    }

    @Override
    @NotNull
    public String identity() {
        String string = this.kind().toString() + '(' + this.myColumns.toString() + ')';
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmConstraint", "identity"));
        }
        return string;
    }

    public boolean isOneColumn() {
        return this.myColumns.size() == 1;
    }

    public boolean isOneColumn(@NotNull DbmColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/dbm/common/DbmConstraint", "isOneColumn"));
        }
        return this.myColumns.size() == 1 && column.isName(this.myColumns.firstName());
    }

    public boolean isDeferrable() {
        return this.myDeferrable;
    }

    public void setDeferrable(boolean deferrable) {
        if (this.myDeferrable == deferrable) {
            return;
        }
        this.modifying();
        this.myDeferrable = deferrable;
        this.myInitiallyDeferred = false;
    }

    public boolean isInitiallyDeferred() {
        return this.myInitiallyDeferred;
    }

    public void setInitiallyDeferred(boolean initiallyDeferred) {
        if (this.myInitiallyDeferred == initiallyDeferred) {
            return;
        }
        this.modifying();
        this.myInitiallyDeferred = initiallyDeferred;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmConstraint", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "columns", (Collection<String>)this.myColumns.names());
        this.putState(stateBuilder, "deferrable", this.myDeferrable);
        this.putState(stateBuilder, "initially deferred", this.myInitiallyDeferred);
    }

    protected abstract char getConstraintKindOrderPrefix();

    @Override
    @NotNull
    protected String calculateDisplayOrder() {
        StringBuilder b = new StringBuilder();
        b.append(this.getConstraintKindOrderPrefix());
        if (this.myColumns.isNotEmpty()) {
            for (DbmLikeColumn column : this.myColumns.resolveObjects()) {
                b.append(Numbers.toFixLengthNumber(column.getPosition(), 3));
            }
        } else {
            b.append('X');
        }
        b.append('|');
        b.append(this.myCreatedTimestamp != null ? Numbers.toFixLengthNumber(this.myCreatedTimestamp.getTime(), 12) : "Y");
        b.append(this.myObjectId != 0L ? Numbers.toFixLengthNumber(this.myObjectId, 12) : "Z");
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmConstraint", "calculateDisplayOrder"));
        }
        return string;
    }
}

