/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmTableElement;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.DomEnsembleObjectsRef;
import com.intellij.dbm.common.DomOrderedObjectsRef;
import com.intellij.dbm.common.StateProperty;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public class DbmIndex
extends DbmTableElement
implements DasIndex {
    public final DbmLikeTable table;
    @StateProperty
    @NotNull
    public final DomOrderedObjectsRef<DbmLikeColumn> myColumns;
    @StateProperty
    @NotNull
    public final DomEnsembleObjectsRef<DbmLikeColumn> myDescColumns;
    @StateProperty
    public boolean myUnique;
    @StateProperty
    public boolean myClustering;
    @StateProperty
    public String myTablespaceName;

    public DbmIndex(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmIndex", "<init>"));
        }
        super(table, name);
        this.table = table;
        this.myColumns = new DomOrderedObjectsRef<DbmLikeColumn>(this, table.columnResolver);
        this.myDescColumns = new DomEnsembleObjectsRef<DbmLikeColumn>(this, table.columnResolver);
    }

    public void addColumn(@NotNull String columnName, DasIndex.Sorting sorting) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/dbm/common/DbmIndex", "addColumn"));
        }
        if (this.myColumns.contains(columnName)) {
            DbmUtil.LOG.warn(String.format("Index %s already contains column %s.", this.getName(), columnName));
            return;
        }
        this.myColumns.add(columnName);
        switch (sorting) {
            case DESCENDING: {
                this.myDescColumns.add(columnName);
                break;
            }
            default: {
                this.myDescColumns.remove(columnName);
            }
        }
    }

    public void setSorting(@NotNull String columnName, @NotNull DasIndex.Sorting sorting) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/dbm/common/DbmIndex", "setSorting"));
        }
        if (sorting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sorting", "com/intellij/dbm/common/DbmIndex", "setSorting"));
        }
        if (!this.myColumns.contains(columnName) && sorting != DasIndex.Sorting.NONE) {
            throw new IllegalArgumentException("No such column in index: " + columnName);
        }
        switch (sorting) {
            case DESCENDING: {
                this.myDescColumns.add(columnName);
                break;
            }
            default: {
                this.myDescColumns.remove(columnName);
            }
        }
    }

    @Override
    @NotNull
    public DbmObject parent() {
        DbmLikeTable dbmLikeTable = this.table;
        if (dbmLikeTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "parent"));
        }
        return dbmLikeTable;
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.INDEX;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "kind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    protected String calculateDisplayOrder() {
        StringBuilder b = new StringBuilder();
        b.append(this.myUnique ? (char)'1' : '2');
        for (DbmLikeColumn column : this.myColumns.resolveObjects()) {
            b.append('.').append(column.getDisplayOrder());
        }
        String naturalName = this.getNaturalNameOrNull();
        if (naturalName != null) {
            b.append('.').append(naturalName);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public String identity() {
        String string = "index(" + this.myColumns.toString() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "identity"));
        }
        return string;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(80);
        b.append(this.myUnique ? "unique " : "index ");
        ImmutableList<String> columnNames = this.myColumns.getNamesOrdered();
        boolean showSorting = this.myDescColumns.isNotEmpty();
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            String columnName = (String)columnNames.get(i);
            b.append(i == 0 ? "(" : ", ");
            b.append(columnName);
            if (!showSorting) continue;
            DasIndex.Sorting sorting = this.getColumnSorting(columnName);
            if (sorting == DasIndex.Sorting.ASCENDING) {
                b.append(" asc");
            }
            if (sorting != DasIndex.Sorting.DESCENDING) continue;
            b.append(" desc");
        }
        b.append(')');
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "description"));
        }
        return string;
    }

    public boolean isUnique() {
        return this.myUnique;
    }

    public void setUnique(boolean unique) {
        if (this.myUnique == unique) {
            return;
        }
        this.modifying();
        this.myUnique = unique;
    }

    public boolean isClustering() {
        return this.myClustering;
    }

    public void setClustering(boolean clustering) {
        if (this.myClustering == clustering) {
            return;
        }
        this.modifying();
        this.myClustering = clustering;
    }

    public String getTablespaceName() {
        return this.myTablespaceName;
    }

    public void setTablespaceName(String tablespaceName) {
        if (Strings.eq((String)this.myTablespaceName, (String)tablespaceName)) {
            return;
        }
        this.modifying();
        this.myTablespaceName = tablespaceName;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmIndex", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "columns", (Collection<String>)this.myColumns.names());
        this.putState(stateBuilder, "unique", this.myUnique);
        this.putState(stateBuilder, "clustering", this.myClustering);
        this.putState(stateBuilder, "tablespace", this.myTablespaceName);
    }

    @Override
    public String getTableName() {
        return this.table.getName();
    }

    @NotNull
    public DomOrderedObjectsRef<DbmLikeColumn> getColumnsRef() {
        DomOrderedObjectsRef<DbmLikeColumn> domOrderedObjectsRef = this.myColumns;
        if (domOrderedObjectsRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "getColumnsRef"));
        }
        return domOrderedObjectsRef;
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/dbm/common/DbmIndex", "getColumnSorting"));
        }
        DasIndex.Sorting sorting = this.getColumnSorting(column.getName());
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "getColumnSorting"));
        }
        return sorting;
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull String columnName) {
        if (columnName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnName", "com/intellij/dbm/common/DbmIndex", "getColumnSorting"));
        }
        DasIndex.Sorting sorting = this.myColumns.contains(columnName) ? (this.myDescColumns.contains(columnName) ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.ASCENDING) : DasIndex.Sorting.NONE;
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmIndex", "getColumnSorting"));
        }
        return sorting;
    }

    public void clearColumnsList() {
        if (this.myColumns.isNotEmpty()) {
            this.modifying();
        }
        this.myDescColumns.clearState();
        this.myColumns.clearState();
    }

    @Override
    public String toString() {
        return super.toString() + (this.isUnique() ? ": [UI] " : "? [IE] ") + this.myColumns.toString();
    }
}

