/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmTableElement;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.dbm.common.Resolver;
import com.intellij.dbm.common.StateProperty;
import com.intellij.util.Consumer;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmLikeTable
extends DbmMajor
implements DasTable {
    protected final Family<? extends DbmColumn> myColumns;
    protected final Family<? extends DbmIndex> myIndices;
    protected final Family<? extends DbmKey> myKeys;
    protected final Family<? extends DbmForeignKey> myForeignKeys;
    protected final Family<? extends DbmCheck> myChecks;
    protected final Family<? extends DbmTrigger> myTriggers;
    @StateProperty
    public boolean myIsSystem;
    final Resolver<DbmLikeColumn> columnResolver;
    private static final Consumer<DbmTableElement> ourDisplayOrderInvalidator = new Consumer<DbmTableElement>(){

        public void consume(@NotNull DbmTableElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmLikeTable$2", "consume"));
            }
            element.invalidateDisplayOrder();
        }
    };

    @NotNull
    public Family<? extends DbmColumn> columns() {
        Family<? extends DbmColumn> family = this.myColumns;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "columns"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmIndex> indices() {
        Family<? extends DbmIndex> family = this.myIndices;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "indices"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmKey> keys() {
        Family<? extends DbmKey> family = this.myKeys;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "keys"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmForeignKey> foreignKeys() {
        Family<? extends DbmForeignKey> family = this.myForeignKeys;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "foreignKeys"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmCheck> checks() {
        Family<? extends DbmCheck> family = this.myChecks;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "checks"));
        }
        return family;
    }

    @NotNull
    public Family<? extends DbmTrigger> triggers() {
        Family<? extends DbmTrigger> family = this.myTriggers;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "triggers"));
        }
        return family;
    }

    protected DbmLikeTable(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmLikeTable", "<init>"));
        }
        super(schema, name);
        this.columnResolver = new Resolver.Base<DbmLikeColumn>(){

            @Override
            @Nullable
            public DbmLikeColumn resolve(@NotNull RelativeReference p) {
                if (p == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/DbmLikeTable$1", "resolve"));
                }
                if (p.args != null) {
                    return null;
                }
                return p.path.length == 1 ? DbmLikeTable.this.resolveColumn(p.path[0]) : null;
            }

            @Override
            @Nullable
            public DbmLikeColumn resolve2(@NotNull String[] path, @Nullable String[] args) {
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/DbmLikeTable$1", "resolve2"));
                }
                return path.length == 1 ? DbmLikeTable.this.resolveColumn(path[0]) : null;
            }
        };
        this.myColumns = Family.of(this, ObjectKind.COLUMN);
        this.myIndices = Family.of(this, ObjectKind.INDEX);
        this.myKeys = Family.of(this, ObjectKind.KEY);
        this.myForeignKeys = Family.of(this, ObjectKind.FOREIGN_KEY);
        this.myChecks = Family.of(this, ObjectKind.CHECK);
        this.myTriggers = Family.of(this, ObjectKind.TRIGGER);
        this.assignFamilies(this.myColumns, this.myIndices, this.myKeys, this.myForeignKeys, this.myChecks, this.myTriggers);
    }

    @Nullable
    public DbmLikeColumn resolveColumn(@Nullable String name) {
        return name != null ? this.columns().get(name) : null;
    }

    @Override
    protected void modifyingChild(@NotNull DbmElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmLikeTable", "modifyingChild"));
        }
        super.modifyingChild(element);
        if (element instanceof DbmColumn) {
            for (DbmTableElement dbmTableElement : this.myIndices) {
                ourDisplayOrderInvalidator.consume((Object)dbmTableElement);
            }
            for (DbmTableElement dbmTableElement : this.myKeys) {
                ourDisplayOrderInvalidator.consume((Object)dbmTableElement);
            }
            for (DbmTableElement dbmTableElement : this.myForeignKeys) {
                ourDisplayOrderInvalidator.consume((Object)dbmTableElement);
            }
            for (DbmTableElement dbmTableElement : this.myChecks) {
                ourDisplayOrderInvalidator.consume((Object)dbmTableElement);
            }
        }
    }

    @Nullable
    public DbmConstraint getConstraint(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmLikeTable", "getConstraint"));
        }
        DbmConstraint c = this.keys().get(name);
        if (c != null) {
            return c;
        }
        c = this.foreignKeys().get(name);
        if (c != null) {
            return c;
        }
        c = this.checks().get(name);
        if (c != null) {
            return c;
        }
        return null;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmLikeTable", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        this.putState(stateBuilder, "comment", this.myComment);
    }

    @Nullable
    public DbmKey getPrimaryKey() {
        for (DbmKey dbmKey : this.keys()) {
            if (!dbmKey.isPrimary()) continue;
            return dbmKey;
        }
        return null;
    }

    @Nullable
    public DbmKey getKeyByColumns(@NotNull List<String> columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/dbm/common/DbmLikeTable", "getKeyByColumns"));
        }
        int n = columnNames.size();
        if (n < 1) {
            return null;
        }
        ImmutableList<? extends DbmKey> keys = this.myKeys.asList();
        for (DbmKey key : keys) {
            ImmutableList<String> names = key.myColumns.getNamesOrdered();
            if (!DbmLikeTable.listsAreEqueal(names, columnNames)) continue;
            return key;
        }
        return null;
    }

    private static <T> boolean listsAreEqueal(List<T> listA, List<T> listB) {
        int n = listA.size();
        if (listB.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Objects.equal(listA.get(i), listB.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isSystem() {
        return this.myIsSystem;
    }

    public void setIsSystem(boolean isSystem) {
        if (this.myIsSystem == isSystem) {
            return;
        }
        this.modifying();
        this.myIsSystem = isSystem;
    }

    public boolean isTemporary() {
        return false;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn column) {
        if (column == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getColumnAttrs"));
            }
            return set;
        }
        String name = column.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (column instanceof DbmColumn && ((DbmColumn)column).getSequenceIdentity() != null) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        if (this.getPrimaryKey() != null && DasUtil.containsName((String)name, (MultiRef)this.getPrimaryKey().getColumnsRef())) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (DbmForeignKey dbmForeignKey : this.foreignKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dbmForeignKey.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DbmIndex dbmIndex : this.indices()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dbmIndex.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmLikeTable", "getColumnAttrs"));
        }
        return enumSet;
    }
}

