/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.StateProperty;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Numbers;

public class DbmSequence
extends DbmMajor {
    @StateProperty
    public boolean myCycled;
    @StateProperty
    @Nullable
    public BigInteger myMinValue;
    @StateProperty
    @Nullable
    public BigInteger myMaxValue;
    @StateProperty
    @Nullable
    public BigInteger myIncrementBy;
    @StateProperty
    @Nullable
    public BigInteger myNextValue;

    public DbmSequence(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmSequence", "<init>"));
        }
        super(schema, name);
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.SEQUENCE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSequence", "kind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder();
        if (this.myMinValue != null) {
            b.append("min ").append(this.myMinValue).append(' ');
        }
        if (this.myMaxValue != null) {
            b.append("max ").append(this.myMaxValue).append(' ');
        }
        if (this.myIncrementBy != null) {
            b.append("by ").append(this.myIncrementBy).append(' ');
        }
        if (this.myNextValue != null) {
            b.append("next ").append(this.myNextValue).append(' ');
        }
        if (this.myCycled) {
            b.append("cycled ");
        }
        this.descriptionRest(b);
        String string = b.toString().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSequence", "description"));
        }
        return string;
    }

    protected void descriptionRest(StringBuilder b) {
    }

    @Nullable
    public BigInteger getMinValue() {
        return this.myMinValue;
    }

    public void setMinValue(@Nullable BigInteger minValue) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myMinValue, minValue)) {
            return;
        }
        this.modifying();
        this.myMinValue = minValue;
    }

    public void setMinValue(@Nullable Number minValue) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myMinValue, minValue)) {
            return;
        }
        this.modifying();
        this.myMinValue = (BigInteger)Numbers.convertNumber(BigInteger.class, (Number)minValue);
    }

    @Nullable
    public BigInteger getMaxValue() {
        return this.myMaxValue;
    }

    public void setMaxValue(@Nullable BigInteger maxValue) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myMaxValue, maxValue)) {
            return;
        }
        this.modifying();
        this.myMaxValue = maxValue;
    }

    public void setMaxValue(@Nullable Number maxValue) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myMaxValue, maxValue)) {
            return;
        }
        this.modifying();
        this.myMaxValue = (BigInteger)Numbers.convertNumber(BigInteger.class, (Number)maxValue);
    }

    public BigInteger getIncrementBy() {
        return this.myIncrementBy;
    }

    public void setIncrementBy(BigInteger incrementBy) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myIncrementBy, incrementBy)) {
            return;
        }
        this.modifying();
        this.myIncrementBy = incrementBy;
    }

    public void setIncrementBy(Number incrementBy) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myIncrementBy, incrementBy)) {
            return;
        }
        this.modifying();
        this.myIncrementBy = (BigInteger)Numbers.convertNumber(BigInteger.class, (Number)incrementBy);
    }

    @Nullable
    public BigInteger getNextValue() {
        return this.myNextValue;
    }

    public void setNextValue(@Nullable BigInteger nextValue) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myNextValue, nextValue)) {
            return;
        }
        this.modifying();
        this.myNextValue = nextValue;
    }

    public void setNextValue(@Nullable Number nextValue) {
        if (com.intellij.util.Numbers.valuesAreEqual(this.myNextValue, nextValue)) {
            return;
        }
        this.modifying();
        this.myNextValue = (BigInteger)Numbers.convertNumber(BigInteger.class, (Number)nextValue);
    }

    public boolean isCycled() {
        return this.myCycled;
    }

    public void setCycled(boolean cycled) {
        if (this.myCycled == cycled) {
            return;
        }
        this.modifying();
        this.myCycled = cycled;
    }

    public void resetParameters() {
        this.setMinValue(null);
        this.setMaxValue(null);
        this.setNextValue(null);
        this.setIncrementBy(null);
        this.setCycled(false);
    }
}

