/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmElement;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmTableElement;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.common.TrigEvent;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Numbers;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmTrigger
extends DbmTableElement
implements DasTrigger {
    @StateProperty
    public final TrigEvents trigEvents;
    @StateProperty
    public final DbmElement.NameSet trigColumns;
    @StateProperty
    @Nullable
    public TrigTurn myTrigTurn;
    @StateProperty
    @Nullable
    public String mySourceText;
    private static final ImmutableSortedSet<TrigEvent> NOTHING = ImmutableSortedSet.of();

    public DbmTrigger(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmTrigger", "<init>"));
        }
        super(table, name);
        this.trigEvents = new TrigEvents();
        this.trigColumns = new DbmElement.NameSet();
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.TRIGGER;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger", "kind"));
        }
        return objectKind;
    }

    @Nullable
    public TrigTurn getTrigTurn() {
        return this.myTrigTurn;
    }

    public void setTrigTurn(@Nullable TrigTurn trigTurn) {
        if (this.myTrigTurn == trigTurn) {
            return;
        }
        this.modifying();
        this.myTrigTurn = trigTurn;
    }

    @Nullable
    public String getSourceText() {
        return this.mySourceText;
    }

    public void setSourceText(@Nullable String sourceText) {
        this.modifying();
        this.mySourceText = sourceText;
    }

    @Override
    @NotNull
    protected String calculateDisplayOrder() {
        String string = this.trigEvents.getDisplayOrder() + (this.myTrigTurn != null ? Integer.toString(this.myTrigTurn.ordinal()) : "Z") + '|' + (this.myCreatedTimestamp != null ? Numbers.toFixLengthNumber(this.myCreatedTimestamp.getTime(), 12) : "Y") + (this.myObjectId != 0L ? Numbers.toFixLengthNumber(this.myObjectId, 12) : "Z");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(64);
        b.append("trigger ");
        String events = this.trigEvents.describe(this.trigColumns.get());
        TrigTurn turn = this.myTrigTurn;
        if (turn == null) {
            turn = TrigTurn.ALSO;
        }
        switch (turn) {
            case ALSO: {
                b.append("on ").append(events);
                break;
            }
            case INSTEAD_OF: {
                b.append("instead of ").append(events);
                break;
            }
            case BEFORE_STMT: {
                b.append("before ").append(events).append(" statement");
                break;
            }
            case BEFORE_ROW: {
                b.append("before ").append(events).append(" row");
                break;
            }
            case AFTER_ROW: {
                b.append("after ").append(events).append(" row");
                break;
            }
            case AFTER_STMT: {
                b.append("after ").append(events).append(" statement");
            }
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger", "description"));
        }
        return string;
    }

    public class TrigEvents
    implements PropertyHolder {
        private final AtomicReference<ImmutableSortedSet<TrigEvent>> myEvents = new AtomicReference<ImmutableSortedSet>(DbmTrigger.access$000());

        public void set(@Nullable Set<TrigEvent> events) {
            if (events == null || events.isEmpty()) {
                this.clearState();
                return;
            }
            ImmutableSortedSet evs = ImmutableSortedSet.copyOf(events);
            DbmTrigger.this.modifying();
            this.myEvents.set((ImmutableSortedSet<TrigEvent>)evs);
        }

        public void set(@Nullable TrigEvent event) {
            if (event == null) {
                this.clearState();
                return;
            }
            ImmutableSortedSet evs = ImmutableSortedSet.of((Comparable)((Object)event));
            DbmTrigger.this.modifying();
            this.myEvents.set((ImmutableSortedSet<TrigEvent>)evs);
        }

        public void set(@Nullable String eventsAbb) {
            if (eventsAbb == null || eventsAbb.isEmpty()) {
                this.clearState();
                return;
            }
            String letters = eventsAbb.toUpperCase(Locale.ENGLISH);
            ImmutableSortedSet.Builder b = ImmutableSortedSet.naturalOrder();
            for (TrigEvent ev : TrigEvent.values()) {
                if (letters.indexOf(ev.code) < 0) continue;
                b.add((Object)ev);
            }
            this.set((Set<TrigEvent>)b.build());
        }

        public void add(@NotNull TrigEvent event) {
            ImmutableSortedSet neo;
            ImmutableSortedSet<TrigEvent> old;
            boolean ok;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dbm/common/DbmTrigger$TrigEvents", "add"));
            }
            do {
                if (!(old = this.myEvents.get()).contains((Object)event)) continue;
                return;
            } while (!(ok = this.myEvents.compareAndSet(old, (ImmutableSortedSet<TrigEvent>)(neo = old.isEmpty() ? ImmutableSortedSet.of((Comparable)((Object)event)) : ImmutableSortedSet.naturalOrder().addAll(old).add((Object)event).build()))));
        }

        @NotNull
        public SortedSet<TrigEvent> get() {
            SortedSet sortedSet = (SortedSet)this.myEvents.get();
            if (sortedSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger$TrigEvents", "get"));
            }
            return sortedSet;
        }

        @NotNull
        public String getDisplayOrder() {
            SortedSet<TrigEvent> events = this.get();
            int n = events.size();
            switch (n) {
                case 0: {
                    if ("Z" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger$TrigEvents", "getDisplayOrder"));
                    }
                    return "Z";
                }
                case 1: {
                    String string = Integer.toString(events.first().ordinal()) + '.';
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger$TrigEvents", "getDisplayOrder"));
                    }
                    return string;
                }
            }
            StringBuilder b = new StringBuilder(n);
            for (TrigEvent event : events) {
                b.append(event.ordinal());
            }
            b.append('.');
            String string = b.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmTrigger$TrigEvents", "getDisplayOrder"));
            }
            return string;
        }

        public boolean isNotEmpty() {
            return !this.myEvents.get().isEmpty();
        }

        @Override
        @Nullable
        public String exportState() {
            SortedSet<TrigEvent> events = this.get();
            int n = events.size();
            switch (n) {
                case 0: {
                    return null;
                }
                case 1: {
                    return Character.toString(events.first().code);
                }
            }
            StringBuilder b = new StringBuilder(n);
            for (TrigEvent event : events) {
                b.append(event.code);
            }
            return b.toString();
        }

        @Override
        public void importState(@Nullable String text) {
            if (text == null || text.length() == 0) {
                this.clearState();
                return;
            }
            ImmutableSortedSet.Builder b = ImmutableSortedSet.naturalOrder();
            for (TrigEvent event : TrigEvent.values()) {
                if (text.indexOf(event.code) < 0) continue;
                b.add((Object)event);
            }
            this.set((Set<TrigEvent>)b.build());
        }

        @Override
        public void clearState() {
            if (this.myEvents.get().isEmpty()) {
                return;
            }
            DbmTrigger.this.modifying();
            this.myEvents.set((ImmutableSortedSet<TrigEvent>)NOTHING);
        }

        @Nullable
        protected String describe(@Nullable Set<String> updateColumns) {
            SortedSet events = (SortedSet)this.myEvents.get();
            StringBuilder b = new StringBuilder();
            boolean was = false;
            for (TrigEvent event : events) {
                if (was) {
                    b.append(" or ");
                } else {
                    was = true;
                }
                b.append(DbmUtil.humanizeEnumName(event.name()));
                if (event != TrigEvent.UPDATE || updateColumns == null || updateColumns.isEmpty()) continue;
                b.append(" of ");
                StringUtil.join(updateColumns, (String)",", (StringBuilder)b);
            }
            return b.toString();
        }

        public String toString() {
            return this.describe(null);
        }
    }
}

