/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.FamilyUtil;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public class DomEnsembleObjectsRef<T extends DbmNamedObject>
extends DomObjectsRef<T> {
    private final AtomicReference<ImmutableSortedSet<String>> myNames;

    public DomEnsembleObjectsRef(@NotNull DbmObject owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/DomEnsembleObjectsRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/DomEnsembleObjectsRef", "<init>"));
        }
        super(owner, resolver);
        this.myNames = new AtomicReference<ImmutableSortedSet>(ImmutableSortedSet.of());
    }

    @Override
    public void setAll(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DomEnsembleObjectsRef", "setAll"));
        }
        this.myOwner.modifying();
        ImmutableSortedSet.Builder b = ImmutableSortedSet.naturalOrder();
        for (String name : names) {
            b.add((Object)DbUtil.intern((String)name));
        }
        this.myNames.set((ImmutableSortedSet<String>)b.build());
    }

    @Override
    public void setAll(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DomEnsembleObjectsRef", "setAll"));
        }
        this.myNames.set((ImmutableSortedSet<String>)ImmutableSortedSet.copyOf(names));
    }

    @Override
    public void add(@NotNull String name) {
        ImmutableSortedSet<String> newNames;
        ImmutableSortedSet<String> oldNames;
        boolean ok;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DomEnsembleObjectsRef", "add"));
        }
        this.myOwner.modifying();
        while (!(ok = this.myNames.compareAndSet(oldNames = this.myNames.get(), newNames = CollectionUtils.union(oldNames, ImmutableSortedSet.of((Comparable)((Object)DbUtil.intern((String)name))))))) {
        }
    }

    public void remove(final @NotNull String name) {
        ImmutableSortedSet newNames;
        ImmutableSortedSet<String> oldNames;
        boolean ok;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DomEnsembleObjectsRef", "remove"));
        }
        if (!this.myNames.get().contains((Object)name)) {
            return;
        }
        this.myOwner.modifying();
        while (!(ok = this.myNames.compareAndSet(oldNames = this.myNames.get(), (ImmutableSortedSet<String>)(newNames = ImmutableSortedSet.copyOf((Collection)Sets.filter(oldNames, (Predicate)new Predicate<String>(){

            public boolean apply(String item) {
                return !Strings.eq((String)item, (String)name);
            }
        })))))) {
        }
    }

    @Override
    public ImmutableCollection<String> names() {
        return (ImmutableCollection)this.myNames.get();
    }

    @Override
    public ImmutableList<String> getNamesOrdered() {
        return ImmutableList.copyOf(this.names());
    }

    @Override
    public ImmutableList<T> resolveObjects() {
        ImmutableSortedSet<String> names = this.myNames.get();
        if (names == null || names.isEmpty()) {
            return ImmutableList.of();
        }
        int n = names.size();
        ImmutableList.Builder b = ImmutableList.builder();
        if (this.myResolver instanceof Family) {
            Family family = (Family)this.myResolver;
            int k = 0;
            for (DbmObject object : family) {
                if (names.contains((Object)object.getName())) {
                    b.add((Object)object);
                    ++k;
                }
                if (k != n) continue;
                break;
            }
        } else {
            ArrayList list = new ArrayList(n);
            for (String name : names) {
                Object resolvedObject = this.myResolver.resolve(name);
                if (resolvedObject == null) continue;
                list.add(resolvedObject);
            }
            if (list.size() > 1) {
                Collections.sort(list, FamilyUtil.GENERAL_COMPARATOR);
            }
            b.addAll(list);
        }
        return b.build();
    }

    @Override
    public MultiRef.It<T> iterate() {
        ImmutableCollection names = (ImmutableCollection)this.myNames.get();
        if (names == null || names.isEmpty()) {
            return DasUtil.emptyMultiRefIterator();
        }
        return null;
    }

    @Override
    @Nullable
    public String firstName() {
        ImmutableSortedSet<String> theNames = this.myNames.get();
        switch (theNames.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)theNames.first();
            }
        }
        throw new IllegalStateException("The domestic ensemble includes several names and we don't know which of them is first.");
    }

    @Override
    public boolean isNotEmpty() {
        return !this.myNames.get().isEmpty();
    }

    @Override
    public String exportState() {
        return StringUtil.join((Collection)((Collection)this.myNames.get()), (String)"\n");
    }

    @Override
    public void importState(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dbm/common/DomEnsembleObjectsRef", "importState"));
        }
        this.setAll(StringUtil.splitByLines((String)text));
    }

    @Override
    public void clearState() {
        if (this.myNames.get().isEmpty()) {
            return;
        }
        this.myOwner.modifying();
        this.myNames.set((ImmutableSortedSet<String>)NO_NAMES_SET);
    }
}

