/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.database.model.MultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.Resolver;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomObjectsRef<T extends DbmNamedObject>
implements PropertyHolder,
MultiRef<T> {
    @NotNull
    protected final DbmObject myOwner;
    @NotNull
    protected final Resolver<? extends T> myResolver;
    protected static final ImmutableSortedSet<String> NO_NAMES_SET = ImmutableSortedSet.of();
    protected static final ImmutableList<String> NO_NAMES_LIST = ImmutableList.of();

    public DomObjectsRef(@NotNull DbmObject owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/DomObjectsRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/DomObjectsRef", "<init>"));
        }
        this.myOwner = owner;
        this.myResolver = resolver;
    }

    public abstract void setAll(String ... var1);

    public abstract void setAll(@NotNull Collection<String> var1);

    public abstract void add(@NotNull String var1);

    public abstract ImmutableCollection<String> names();

    public abstract ImmutableList<String> getNamesOrdered();

    public abstract ImmutableList<T> resolveObjects();

    public boolean contains(String name) {
        return this.names().contains((Object)name);
    }

    @Nullable
    public String getName(int index) {
        ImmutableList<String> namesOrdered = this.getNamesOrdered();
        return index < namesOrdered.size() ? (String)namesOrdered.get(index) : null;
    }

    @Nullable
    public abstract String firstName();

    public abstract boolean isNotEmpty();

    public int size() {
        return this.names().size();
    }

    public MultiRef.It<T> iterate() {
        ImmutableCollection<String> names = this.names();
        if (names == null || names.isEmpty()) {
            return DasUtil.emptyMultiRefIterator();
        }
        UnmodifiableIterator it = names.iterator();
        return new MultiRef.It<T>((Iterator)it){
            String cur;
            final /* synthetic */ Iterator val$it;
            {
                this.val$it = iterator;
            }

            @Nullable
            public T resolve() {
                return DomObjectsRef.this.myResolver.resolve(this.cur);
            }

            public boolean hasNext() {
                return this.val$it.hasNext();
            }

            public String next() {
                this.cur = (String)this.val$it.next();
                return this.cur;
            }

            public void remove() {
                this.val$it.remove();
            }
        };
    }

    public String toString() {
        ImmutableList<String> names = this.getNamesOrdered();
        int n = names.size();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return (String)names.get(0);
            }
        }
        StringBuilder b = new StringBuilder();
        b.append((String)names.get(0));
        for (int i = 1; i < n; ++i) {
            b.append(',').append((String)names.get(i));
        }
        return b.toString();
    }

    @Override
    public abstract String exportState();

    @Override
    public abstract void importState(@NotNull String var1);

    @Override
    public abstract void clearState();
}

