/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.database.util.DbUtil;
import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CollectionUtils;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class DomOrderedObjectsRef<T extends DbmNamedObject>
extends DomObjectsRef<T> {
    private final AtomicReference<ImmutableList<String>> myNames;

    public DomOrderedObjectsRef(@NotNull DbmObject owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/DomOrderedObjectsRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/DomOrderedObjectsRef", "<init>"));
        }
        super(owner, resolver);
        this.myNames = new AtomicReference<ImmutableList>(ImmutableList.of());
    }

    @Override
    public void setAll(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DomOrderedObjectsRef", "setAll"));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (String name : names) {
            b.add((Object)name);
        }
        this.myNames.set((ImmutableList<String>)b.build());
    }

    @Override
    public void setAll(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/DomOrderedObjectsRef", "setAll"));
        }
        this.myNames.set((ImmutableList<String>)ImmutableList.copyOf(names));
    }

    @Override
    public void add(@NotNull String name) {
        ImmutableList<String> newNames;
        ImmutableList<String> oldNames;
        boolean ok;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DomOrderedObjectsRef", "add"));
        }
        while (!(ok = this.myNames.compareAndSet(oldNames = this.myNames.get(), newNames = CollectionUtils.concat(oldNames, ImmutableList.of((Object)DbUtil.intern((String)name)))))) {
        }
    }

    @Override
    public ImmutableCollection<String> names() {
        return (ImmutableCollection)this.myNames.get();
    }

    @Override
    public ImmutableList<String> getNamesOrdered() {
        return this.myNames.get();
    }

    @Override
    public ImmutableList<T> resolveObjects() {
        ImmutableList<String> names = this.myNames.get();
        if (names == null || names.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (String name : names) {
            Object resolvedObject;
            if (name == null || (resolvedObject = this.myResolver.resolve(name)) == null) continue;
            b.add(resolvedObject);
        }
        return b.build();
    }

    @Override
    public String firstName() {
        ImmutableList<String> theNames = this.myNames.get();
        return theNames.isEmpty() ? null : (String)theNames.get(0);
    }

    @Override
    public boolean isNotEmpty() {
        return !this.myNames.get().isEmpty();
    }

    @Override
    public String exportState() {
        return StringUtil.join((Collection)((Collection)this.myNames.get()), (String)"\n");
    }

    @Override
    public void importState(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dbm/common/DomOrderedObjectsRef", "importState"));
        }
        this.setAll(StringUtil.splitByLines((String)text));
    }

    @Override
    public void clearState() {
        this.myNames.set((ImmutableList<String>)NO_NAMES_LIST);
    }
}

