/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.RelativeReference;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EmptyFamily<C extends DbmObject>
extends Family<C> {
    private static final DbmObject[] NO_OBJECTS = new DbmObject[0];

    EmptyFamily(@NotNull ObjectKind childKind) {
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/EmptyFamily", "<init>"));
        }
        super(childKind);
    }

    @Override
    public String getFamilyDescription() {
        return "EmptyOf" + StringUtil.pluralize((String)this.myChildKind.toString());
    }

    @Override
    @NotNull
    public C create(@Nullable String name) {
        throw this.cannotModify();
    }

    @Override
    @NotNull
    public C getOrCreate(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/EmptyFamily", "getOrCreate"));
        }
        throw this.cannotModify();
    }

    @Override
    @NotNull
    public C getOrCreate(@NotNull String name, String[] specItems) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/EmptyFamily", "getOrCreate"));
        }
        throw this.cannotModify();
    }

    @Override
    @NotNull
    public C renew(long objectId, @Nullable String name) {
        throw this.cannotModify();
    }

    @Override
    @NotNull
    public C get(int index) {
        throw this.alwaysEmpty();
    }

    @Override
    @Nullable
    public C get(String name) {
        return null;
    }

    @Override
    @Nullable
    public C get(String name, boolean caseSensitively) {
        return null;
    }

    @Override
    @Nullable
    public C getByObjectId(long objectId) {
        return null;
    }

    @Override
    @Nullable
    public C getOverload(@NotNull String name, String[] specItems, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/EmptyFamily", "getOverload"));
        }
        return null;
    }

    @Override
    @Nullable
    public C get(@NotNull Predicate<? super C> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/dbm/common/EmptyFamily", "get"));
        }
        return null;
    }

    @Override
    @Nullable
    public C resolve(@NotNull RelativeReference p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/EmptyFamily", "resolve"));
        }
        return null;
    }

    @Override
    @Nullable
    public C resolve2(@NotNull String[] path, @Nullable String[] args) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/EmptyFamily", "resolve2"));
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/EmptyFamily", "getNames"));
        }
        return list;
    }

    @Override
    @NotNull
    public C first() {
        throw this.alwaysEmpty();
    }

    @Override
    @Nullable
    public C firstIfExists() {
        return null;
    }

    @Override
    public <CC> void traverse(@NotNull Class<CC> objectClass, @NotNull Consumer<? super CC> consumer) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/common/EmptyFamily", "traverse"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/dbm/common/EmptyFamily", "traverse"));
        }
    }

    @Override
    public void move(@NotNull DbmObject item, int position) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/dbm/common/EmptyFamily", "move"));
        }
        throw this.cannotModify();
    }

    @Override
    @NotNull
    public ImmutableList<C> asList() {
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/EmptyFamily", "asList"));
        }
        return immutableList;
    }

    @Override
    void removeObject(DbmObject object) {
        throw this.cannotModify();
    }

    @Override
    public void reorder() {
    }

    @Override
    public void markChildrenAsSyncPending() {
    }

    @Override
    public void removeSyncPendingChildren() {
    }

    @Override
    public void clear() {
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isNotEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    @NotNull
    public Iterator<C> iterator() {
        Iterator iterator = Collections.emptyList().iterator();
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/EmptyFamily", "iterator"));
        }
        return iterator;
    }

    @Override
    @NotNull
    public C[] toArray() {
        DbmObject[] dbmObjectArray = NO_OBJECTS;
        if (dbmObjectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/EmptyFamily", "toArray"));
        }
        return dbmObjectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/EmptyFamily", "toArray"));
        }
        return a;
    }

    @Override
    public int indexOf(Object o) {
        return Integer.MIN_VALUE;
    }

    @Override
    public int lastIndexOf(Object o) {
        return Integer.MIN_VALUE;
    }

    @Override
    @NotNull
    public Class<C> getChildClass() {
        throw this.alwaysEmpty();
    }

    private IllegalStateException cannotModify() {
        return new IllegalStateException("Cannot modify always-empty family of " + this.myChildKind);
    }

    private IllegalStateException alwaysEmpty() {
        return new IllegalStateException("Family of " + this.myChildKind + " is always empty");
    }
}

