/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.BasicFamily;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.EmptyFamily;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Family<C extends DbmObject>
implements Collection<C>,
Resolver<C> {
    @NotNull
    protected final ObjectKind myChildKind;

    public static <CC extends DbmObject> Family<CC> of(@NotNull DbmObject parent, @NotNull ObjectKind childKind) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/Family", "of"));
        }
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/Family", "of"));
        }
        ObjectKind parentKind = parent.kind();
        Class childClass2 = parent.model.metaModel.getObjectClass(parentKind, childKind);
        if (childClass2 != null) {
            Class cc = childClass2;
            return new BasicFamily(parent, childKind, cc);
        }
        return new EmptyFamily(childKind);
    }

    protected Family(@NotNull ObjectKind childKind) {
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/Family", "<init>"));
        }
        this.myChildKind = childKind;
    }

    @NotNull
    public ObjectKind getChildKind() {
        ObjectKind objectKind = this.myChildKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/Family", "getChildKind"));
        }
        return objectKind;
    }

    @NotNull
    public abstract C create(@Nullable String var1);

    @NotNull
    public abstract C getOrCreate(@NotNull String var1);

    @NotNull
    public abstract C getOrCreate(@NotNull String var1, String[] var2);

    @NotNull
    public abstract C renew(long var1, @Nullable String var3);

    @NotNull
    public abstract C get(int var1);

    @Nullable
    public abstract C get(String var1);

    @Nullable
    public abstract C get(String var1, boolean var2);

    @Nullable
    public abstract C getByObjectId(long var1);

    @Nullable
    public abstract C getOverload(@NotNull String var1, String[] var2, boolean var3);

    @Nullable
    public abstract C get(@NotNull Predicate<? super C> var1);

    @Override
    @Nullable
    public C resolve(String ... path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/Family", "resolve"));
        }
        return (C)((DbmObject)this.resolve2(path, null));
    }

    @NotNull
    public abstract List<String> getNames();

    @NotNull
    public abstract C first();

    @Nullable
    public abstract C firstIfExists();

    public abstract <CC> void traverse(@NotNull Class<CC> var1, @NotNull Consumer<? super CC> var2);

    public abstract void move(@NotNull DbmObject var1, int var2);

    @NotNull
    public abstract ImmutableList<C> asList();

    public String getFamilyName() {
        return StringUtil.pluralize((String)this.myChildKind.toString());
    }

    abstract void removeObject(DbmObject var1);

    public abstract void markChildrenAsSyncPending();

    public abstract void removeSyncPendingChildren();

    public abstract void reorder();

    @Override
    public abstract void clear();

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    public abstract boolean isNotEmpty();

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract boolean containsAll(Collection<?> var1);

    @Override
    @NotNull
    public abstract Iterator<C> iterator();

    @Override
    @NotNull
    public abstract C[] toArray();

    @Override
    @NotNull
    public abstract <T> T[] toArray(T[] var1);

    public abstract int indexOf(Object var1);

    public abstract int lastIndexOf(Object var1);

    @NotNull
    public abstract Class<C> getChildClass();

    public abstract String getFamilyDescription();

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getFamilyDescription()).append('(');
        int n = this.size();
        switch (n) {
            case 0: {
                b.append("empty");
                break;
            }
            case 1: {
                b.append("1 child");
                break;
            }
            default: {
                b.append(n).append(" children");
            }
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean add(C c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    @Override
    public boolean addAll(Collection<? extends C> c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    @Override
    public boolean remove(Object o) throws IllegalStateException {
        throw new IllegalStateException("Don't use method Family.remove(), use Family.removeObject() instead.");
    }

    @Override
    public boolean removeAll(Collection<?> c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    @Override
    public boolean retainAll(Collection<?> c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    private static IllegalStateException cannotModifyInnerListDirectly() throws IllegalStateException {
        return new IllegalStateException("Cannot modify the inner list of Family directly");
    }
}

