/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class IntrospectionOptions {
    @NotNull
    private final MultiMap<String, String> scope;
    public final boolean incremental;
    public final boolean withSources;
    public final boolean withDependencies;
    public static final IntrospectionOptions CURRENT_INC_OPTIONS = new IntrospectionOptions("@", true, true, true);
    public static final IntrospectionOptions CURRENT_FULL_OPTIONS = new IntrospectionOptions("@", false, true, true);

    @NotNull
    public MultiMap<String, String> getScope() {
        MultiMap multiMap = this.scope.copy();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "getScope"));
        }
        return multiMap;
    }

    @NotNull
    public static IntrospectionOptions of(@NotNull Collection<String> schemas, boolean incremental, boolean withSources, boolean withDependencies) {
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(schemas, incremental, withSources, withDependencies);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        return introspectionOptions;
    }

    @NotNull
    public static IntrospectionOptions of(@NotNull String name, boolean incremental, boolean withSources, boolean withDependencies) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(name, incremental, withSources, withDependencies);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        return introspectionOptions;
    }

    private IntrospectionOptions(@NotNull Collection<String> scope, boolean incremental, boolean withSources, boolean withDependencies) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        this.scope = MultiMap.createSet();
        this.incremental = incremental;
        this.withSources = withSources;
        this.withDependencies = withDependencies;
        this.scope.put((Object)"*", scope);
    }

    private IntrospectionOptions(@NotNull String schemaName, boolean incremental, boolean withSources, boolean withDependencies) {
        if (schemaName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaName", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        this.scope = MultiMap.createSet();
        this.incremental = incremental;
        this.withSources = withSources;
        this.withDependencies = withDependencies;
        this.scope.putValue((Object)"@", (Object)schemaName);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.incremental ? "INC" : "FULL").append('\n');
        for (Map.Entry k : this.scope.entrySet()) {
            b.append((String)k.getKey()).append("->").append(StringUtil.join((Collection)((Collection)k.getValue()), (String)",")).append("\n");
        }
        return b.toString();
    }

    private IntrospectionOptions(@NotNull MultiMap<String, String> names, boolean incremental, boolean withSources, boolean withDependencies) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/IntrospectionOptions", "<init>"));
        }
        this.scope = MultiMap.createSet();
        this.scope.putAllValues(names);
        this.incremental = incremental;
        this.withSources = withSources;
        this.withDependencies = withDependencies;
    }

    @NotNull
    public static IntrospectionOptions of(@NotNull MultiMap<String, String> names, boolean incremental, boolean withSources, boolean withDependencies) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        IntrospectionOptions introspectionOptions = new IntrospectionOptions(names, incremental, withSources, withDependencies);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionOptions", "of"));
        }
        return introspectionOptions;
    }
}

