/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.Family;
import com.intellij.openapi.util.Getter;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntrospectionUtil {
    private static final List<String> EMPTY_STRING_LIST = Collections.emptyList();

    public static void removeDroppedChildren(TLongHashSet existentIds, Family<? extends DbmObject> ... families) {
        ArrayList<DbmObject> objectsToRemove = new ArrayList<DbmObject>();
        for (Family<? extends DbmObject> family : families) {
            for (DbmObject dbmObject : family) {
                long id = dbmObject.getObjectId();
                if (existentIds.contains(id)) continue;
                objectsToRemove.add(dbmObject);
            }
        }
        for (int i = objectsToRemove.size() - 1; i >= 0; --i) {
            DbmObject objectToRemove = (DbmObject)objectsToRemove.get(i);
            objectToRemove.drop();
        }
    }

    @NotNull
    public static List<String> processNamesToIntrospect(@NotNull Collection<String> configuredNames, @Nullable String currentName, @Nullable Getter<Collection<String>> namesRetriever) {
        if (configuredNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuredNames", "com/intellij/dbm/common/IntrospectionUtil", "processNamesToIntrospect"));
        }
        if (configuredNames.isEmpty()) {
            List<String> list = currentName != null ? Collections.singletonList(currentName) : EMPTY_STRING_LIST;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "processNamesToIntrospect"));
            }
            return list;
        }
        if (configuredNames.contains("*")) {
            if (namesRetriever != null) {
                Collection retrievedNames = (Collection)namesRetriever.get();
                List<String> list = IntrospectionUtil.copyWithCurrentFirst(retrievedNames, currentName);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "processNamesToIntrospect"));
                }
                return list;
            }
            List<String> list = EMPTY_STRING_LIST;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "processNamesToIntrospect"));
            }
            return list;
        }
        List<String> list = IntrospectionUtil.copyWithCurrentFirst(configuredNames, currentName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "processNamesToIntrospect"));
        }
        return list;
    }

    private static List<String> copyWithCurrentFirst(@NotNull Collection<String> names, @Nullable String currentName) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/dbm/common/IntrospectionUtil", "copyWithCurrentFirst"));
        }
        if (names.contains("@")) {
            ArrayList<String> result = new ArrayList<String>(names.size());
            for (String name : names) {
                if (name.equals("@")) {
                    if (currentName == null) continue;
                    result.add(0, currentName);
                    continue;
                }
                result.add(name);
            }
            return result;
        }
        return ImmutableList.copyOf(names);
    }

    @NotNull
    public static <T> Set<T> restriction(@Nullable Set<T> set1, @Nullable Set<T> set2) {
        boolean b2;
        boolean b1 = set1 != null && !set1.isEmpty();
        boolean bl = b2 = set2 != null && !set2.isEmpty();
        Object object = b1 ? (b2 ? Sets.intersection(set1, set2) : set1) : (b2 ? set2 : Collections.emptySet());
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "restriction"));
        }
        return object;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> intersection(@NotNull MultiMap<K, V> map1, @NotNull MultiMap<K, V> map2) {
        if (map1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map1", "com/intellij/dbm/common/IntrospectionUtil", "intersection"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map2", "com/intellij/dbm/common/IntrospectionUtil", "intersection"));
        }
        if (map1 == map2) {
            MultiMap<K, V> multiMap = map1;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "intersection"));
            }
            return multiMap;
        }
        MultiMap result = new MultiMap();
        Sets.SetView keys = Sets.intersection((Set)map1.keySet(), (Set)map2.keySet());
        for (Object k : keys) {
            Collection v1 = map1.get(k);
            Collection v2 = map1.get(k);
            HashSet v = new HashSet();
            v.addAll(v1);
            v.retainAll(v2);
            if (v.isEmpty()) continue;
            result.put(k, v);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "intersection"));
        }
        return multiMap;
    }

    @NotNull
    public static <K, V> MultiMap<K, V> restriction(@Nullable MultiMap<K, V> map1, @Nullable MultiMap<K, V> map2) {
        boolean b2;
        boolean b1 = map1 != null && !map1.isEmpty();
        boolean bl = b2 = map2 != null && !map2.isEmpty();
        Object object = b1 ? (b2 ? IntrospectionUtil.intersection(map1, map2) : map1) : (b2 ? map2 : new MultiMap());
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/IntrospectionUtil", "restriction"));
        }
        return object;
    }

    @Contract(value="null,_ -> false", pure=true)
    public static <K> boolean containsKey(@Nullable MultiMap<K, ?> map, @NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/common/IntrospectionUtil", "containsKey"));
        }
        return map != null && map.containsKey(key);
    }
}

