/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import org.jetbrains.annotations.NotNull;

public final class MinorIdentity
implements Comparable<MinorIdentity> {
    public final long majorId;
    public final short position;

    @NotNull
    public static MinorIdentity of(long majorId, short position) {
        MinorIdentity minorIdentity = new MinorIdentity(majorId, position);
        if (minorIdentity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/MinorIdentity", "of"));
        }
        return minorIdentity;
    }

    private MinorIdentity(long majorId, short position) {
        this.majorId = majorId;
        this.position = position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinorIdentity that = (MinorIdentity)o;
        return this.majorId == that.majorId && this.position == that.position;
    }

    public int hashCode() {
        return (((int)this.majorId ^ (int)this.majorId >> 16) << 16) + this.position;
    }

    @Override
    public int compareTo(MinorIdentity that) {
        if (this == that) {
            return 0;
        }
        int z = MinorIdentity.signum(this.majorId, that.majorId);
        if (z == 0) {
            z = this.position - that.position;
        }
        return z;
    }

    private static int signum(long a, long b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.majorId + "/" + this.position;
    }
}

