/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.common.IntrospectionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;

public abstract class MultiDatabaseIntrospector<DB extends DbmDatabase, S extends DbmSchema, M extends DbmMultiDatabaseModel<DB, S>>
extends BaseIntrospector<S, M> {
    private static final Logger LOG = Logger.getInstance(MultiDatabaseIntrospector.class);
    @Nullable
    private Collection<String> myAccessibleDatabases;
    @Nullable
    private MultiMap<String, String> myConfigurationScope;
    @Nullable
    private MultiMap<String, String> mySeanceScope;
    @NotNull
    protected MultiMap<String, String> myWorkScope;
    @NotNull
    protected final List<BaseIntrospector.SchemaRetriever> myRetrievers;

    public MultiDatabaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/common/MultiDatabaseIntrospector", "<init>"));
        }
        super(facade);
        this.myWorkScope = new MultiMap();
        this.myRetrievers = new ArrayList<BaseIntrospector.SchemaRetriever>();
    }

    @Override
    public void setOptions(@NotNull IntrospectionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/dbm/common/MultiDatabaseIntrospector", "setOptions"));
        }
        super.setOptions(options);
        MultiMap<String, String> optionsScope = options.getScope();
        this.myConfigurationScope = optionsScope.isEmpty() ? null : new MultiMap(optionsScope);
    }

    public void setSeanceScope(@Nullable MultiMap<String, String> seanceScope) {
        this.mySeanceScope = seanceScope == null ? null : new MultiMap(seanceScope);
    }

    @Override
    public void introspect() {
        this.processBriefPhase();
        this.produceRetrievers();
        this.processPreliminaryPhase();
        this.processMainPhase();
    }

    public void processBriefPhase() {
        this.retrieveSessionBriefInfo();
        this.matchScope();
        if (!this.myFragmental) {
            for (String databaseName : this.myWorkScope.keySet()) {
                try {
                    this.introspectDatabaseBrief(databaseName);
                }
                catch (Exception e) {
                    LOG.warn(String.format("Failed to get brief info of the database %s: exception %s with message: %s", databaseName, e.getClass().getSimpleName(), e.getMessage()));
                }
            }
        }
        this.dropUnselectedNamespaces();
    }

    private void matchScope() {
        if (MultiDatabaseIntrospector.scopeHasAll(this.myConfigurationScope)) {
            this.myConfigurationScope = new MultiMap(this.myConfigurationScope);
            this.expandScopeWithAccessibleDatabases(this.myConfigurationScope);
        }
        DbmObject currentDatabase = this.myModel != null ? (DbmObject)((DbmMultiDatabaseModel)this.myModel).getCurrentDatabase() : null;
        String currentName = currentDatabase != null ? currentDatabase.getNameOrNull() : null;
        MultiMap<String, String> confScope = MultiDatabaseIntrospector.mergeScopeWithCurrentDatabaseName(this.myConfigurationScope, currentName);
        MultiMap<String, String> seanceScope = MultiDatabaseIntrospector.mergeScopeWithCurrentDatabaseName(this.mySeanceScope, currentName);
        this.myWorkScope = IntrospectionUtil.restriction(confScope, seanceScope);
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    private static MultiMap<String, String> mergeScopeWithCurrentDatabaseName(@Nullable MultiMap<String, String> scope, @Nullable String currentName) {
        if (IntrospectionUtil.containsKey(scope, "@")) {
            MultiMap result = new MultiMap(scope);
            result.remove((Object)"@");
            if (currentName != null) {
                result.putValues((Object)currentName, scope.get((Object)"@"));
            }
            return result;
        }
        return scope;
    }

    private void expandScopeWithAccessibleDatabases(@NotNull MultiMap<String, String> scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/dbm/common/MultiDatabaseIntrospector", "expandScopeWithAccessibleDatabases"));
        }
        Collection schemasForEveryDB = scope.get((Object)"*");
        scope.remove((Object)"*");
        if (schemasForEveryDB.isEmpty()) {
            return;
        }
        Collection<String> accessibleDatabases = this.myUseAccessibleNamespacesFromModel ? ((DbmMultiDatabaseModel)this.myModel).databases().getNames() : this.getAccessibleDatabases();
        for (String dbName : accessibleDatabases) {
            scope.putValues((Object)dbName, schemasForEveryDB);
        }
    }

    @NotNull
    public Collection<String> getAccessibleDatabases() {
        if (this.myAccessibleDatabases == null) {
            this.myAccessibleDatabases = (Collection)this.myFacade.inTransaction((InTransaction)new InTransaction<Collection<String>>(){

                public Collection<String> run(@NotNull DBTransaction tran) {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector$1", "run"));
                    }
                    return MultiDatabaseIntrospector.this.listAccessibleDatabases(tran);
                }
            });
        }
        Collection<String> collection = this.myAccessibleDatabases;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/MultiDatabaseIntrospector", "getAccessibleDatabases"));
        }
        return collection;
    }

    protected void produceRetrievers() {
        this.myRetrievers.clear();
        MultiMap<String, String> scope = this.myWorkScope;
        if (scope.isEmpty()) {
            return;
        }
        for (DbmDatabase database : ((DbmMultiDatabaseModel)this.myModel).databases()) {
            if (!MultiDatabaseIntrospector.inScope(database, scope)) continue;
            for (DbmSchema dbmSchema : database.schemas()) {
                if (!MultiDatabaseIntrospector.inScope(dbmSchema, scope)) continue;
                BaseIntrospector.SchemaRetriever retriever = this.createRetriever(dbmSchema);
                this.myRetrievers.add(retriever);
            }
        }
    }

    private static boolean inScope(DbmDatabase database, MultiMap<String, String> scope) {
        return scope.containsKey((Object)"*") || scope.containsKey((Object)"@") && database.isCurrent() || scope.containsKey((Object)database.getName());
    }

    private static boolean inScope(DbmSchema schema, MultiMap<String, String> scope) {
        Collection schemaNames;
        String databaseName = schema.database.getName();
        String schemaName = schema.getName();
        if (scope.containsKey((Object)"*") && ((schemaNames = scope.get((Object)"*")).contains("*") || schemaNames.contains("@") && schema.isCurrent() || schemaNames.contains(schemaName))) {
            return true;
        }
        if (scope.containsKey((Object)"@") && schema.database.isCurrent() && ((schemaNames = scope.get((Object)"@")).contains("*") || schemaNames.contains("@") && schema.isCurrent() || schemaNames.contains(schemaName))) {
            return true;
        }
        return scope.containsKey((Object)databaseName) && ((schemaNames = scope.get((Object)databaseName)).contains("*") || schemaNames.contains("@") && schema.isCurrent() || schemaNames.contains(schemaName));
    }

    @NotNull
    protected abstract BaseIntrospector.SchemaRetriever createRetriever(S var1);

    private void processPreliminaryPhase() {
        for (BaseIntrospector.SchemaRetriever retriever : this.myRetrievers) {
            retriever.processPreliminaryPhase();
        }
    }

    private void processMainPhase() {
        for (BaseIntrospector.SchemaRetriever retriever : this.myRetrievers) {
            retriever.processMainPhase();
        }
    }

    protected void introspectDatabaseBrief(final @NotNull String databaseName) {
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        this.workWithModel(new BaseIntrospector.ModelWorker<M>(){

            @Override
            public void working(DBTransaction tran, M model) {
                MultiDatabaseIntrospector.this.introspectDatabaseBrief(tran, model, databaseName);
            }
        });
    }

    protected void introspectDatabaseBrief(@NotNull DBTransaction tran, @NotNull M model, @NotNull String databaseName) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/dbm/common/MultiDatabaseIntrospector", "introspectDatabaseBrief"));
        }
        if (this.myUseAccessibleNamespacesFromModel) {
            return;
        }
        Collection schemaNames = this.myWorkScope.get((Object)databaseName);
        if (schemaNames.isEmpty()) {
            LOG.debug(String.format("Looks like an introspection internal error: database %s has no configured schemas to introspect, or the introspector is not properly initialized", databaseName));
            return;
        }
        DbmDatabase database = (DbmDatabase)((DbmMultiDatabaseModel)model).databases().getOrCreate(databaseName);
        DbmSchema currentSchema = database.getCurrentSchema();
        String currentSchemaName = currentSchema != null ? currentSchema.getNameOrNull() : null;
        database.schemas().markChildrenAsSyncPending();
        Map<Integer, String> ss = this.listAccessibleSchemasOfDatabase(tran, database);
        boolean withCurrent = schemaNames.contains("@");
        boolean withAll = schemaNames.contains("*");
        for (Map.Entry<Integer, String> entry : ss.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            int id = entry.getKey();
            String name = entry.getValue();
            if (!schemaNames.contains(name) && (!name.equals(currentSchemaName) || !withCurrent) && !withAll) continue;
            database.schemas().renew(id, name);
        }
    }

    protected abstract Collection<String> listAccessibleDatabases(@NotNull DBTransaction var1);

    protected abstract Map<Integer, String> listAccessibleSchemasOfDatabase(@NotNull DBTransaction var1, DbmDatabase var2);

    private void retrieveSessionBriefInfo() {
        this.updateStatus("Obtaining current info", "");
        this.myFacade.inTransaction(new InTransactionNoResult(){

            public void run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/MultiDatabaseIntrospector$3", "run"));
                }
                MultiDatabaseIntrospector.this.retrieveSessionBriefInfo(tran);
            }
        });
    }

    protected void retrieveSessionBriefInfo(DBTransaction tran) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropUnselectedNamespaces() {
        MultiMap<String, String> configurationScope = this.myConfigurationScope;
        if (configurationScope == null) {
            return;
        }
        LinkedList<DbmNamespace> namespacesToDrop = new LinkedList<DbmNamespace>();
        for (DbmDatabase db : ((DbmMultiDatabaseModel)this.myModel).databases()) {
            if (!MultiDatabaseIntrospector.inScope(db, configurationScope)) {
                namespacesToDrop.add(db);
                continue;
            }
            for (DbmSchema dbmSchema : db.schemas()) {
                if (MultiDatabaseIntrospector.inScope(dbmSchema, configurationScope)) continue;
                namespacesToDrop.add(dbmSchema);
            }
        }
        if (!namespacesToDrop.isEmpty()) {
            ((DbmMultiDatabaseModel)this.myModel).startModifications();
            try {
                Iterator iterator = namespacesToDrop.descendingIterator();
                while (iterator.hasNext()) {
                    DbmNamespace namespace = (DbmNamespace)iterator.next();
                    namespace.drop();
                }
            }
            finally {
                ((DbmMultiDatabaseModel)this.myModel).finishModifications();
            }
        }
    }

    @Contract(value="null->false", pure=true)
    private static boolean scopeHasAll(@Nullable MultiMap<String, String> scope) {
        return scope != null && (scope.containsKey((Object)"*") || scope.containsScalarValue((Object)"*"));
    }
}

