/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.BaseFamily;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.util.WrappedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RootNamespaceFamily<C extends DbmNamespace>
extends BaseFamily<C> {
    @NotNull
    private final DbmModel<C> myModel;
    @NotNull
    private final Constructor<C> myChildConstructor;

    public RootNamespaceFamily(@NotNull DbmModel<C> model, @NotNull Class<C> childClass, ObjectKind kind) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/RootNamespaceFamily", "<init>"));
        }
        if (childClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClass", "com/intellij/dbm/common/RootNamespaceFamily", "<init>"));
        }
        super(kind, childClass);
        this.myModel = model;
        this.myChildConstructor = RootNamespaceFamily.obtainChildConstructor(childClass);
    }

    @NotNull
    private static <CC> Constructor<CC> obtainChildConstructor(@NotNull Class<CC> databaseClass) {
        Constructor<CC> constructor;
        if (databaseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseClass", "com/intellij/dbm/common/RootNamespaceFamily", "obtainChildConstructor"));
        }
        try {
            constructor = databaseClass.getDeclaredConstructor(DbmModel.class, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class " + databaseClass.getName() + " has no required constructor");
        }
        constructor.setAccessible(true);
        Constructor<CC> constructor2 = constructor;
        if (constructor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/RootNamespaceFamily", "obtainChildConstructor"));
        }
        return constructor2;
    }

    @Override
    @NotNull
    public C create(@Nullable String name) {
        DbmNamespace child;
        Class childClass = this.getChildClass();
        this.modifying();
        try {
            child = (DbmNamespace)this.myChildConstructor.newInstance(this.myModel, name);
            this.doAddChild(child);
            child.setParentFamily(this);
        }
        catch (InvocationTargetException ite) {
            Throwable realCause = ite.getTargetException();
            if (realCause == null) {
                realCause = ite.getCause();
            }
            if (realCause == null) {
                realCause = ite;
            }
            throw new WrappedException(realCause);
        }
        catch (InstantiationException ie) {
            String exceptionClassName;
            String message;
            Throwable e = ie.getCause();
            if (e != null) {
                message = e.getMessage();
                exceptionClassName = e.getClass().getSimpleName();
            } else {
                message = "<empty-message>";
                exceptionClassName = "<unknown-exception>";
            }
            String msg = String.format("Failed to instantiate a database object %s class %s: exception %s: %s", this.myChildKind.toString(), childClass.getSimpleName(), exceptionClassName, message);
            throw new WrappedException(msg, ie);
        }
        catch (Exception e) {
            String msg = String.format("Failed to instantiate a model object %s class %s: exception %s: %s", this.myChildKind.toString(), childClass.getSimpleName(), e.getClass().getSimpleName(), e.getMessage());
            throw new WrappedException(msg, e);
        }
        this.myModel.doingObjectCreate(child);
        DbmNamespace dbmNamespace = child;
        if (dbmNamespace == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/RootNamespaceFamily", "create"));
        }
        return (C)dbmNamespace;
    }

    @Override
    public String getFamilyDescription() {
        return this.myModel.getRdbms() + " databases";
    }

    @Override
    @NotNull
    public C getOrCreate(@NotNull String name, String[] specItems) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/RootNamespaceFamily", "getOrCreate"));
        }
        if (specItems == null || specItems.length == 0) {
            DbmNamespace dbmNamespace = (DbmNamespace)this.getOrCreate(name);
            if (dbmNamespace == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/RootNamespaceFamily", "getOrCreate"));
            }
            return (C)dbmNamespace;
        }
        throw new IllegalStateException("Namespaces cannot be overloaded");
    }

    @Override
    @Nullable
    public C getOverload(@NotNull String name, String[] specItems, boolean caseSensitively) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/RootNamespaceFamily", "getOverload"));
        }
        if (specItems == null || specItems.length == 0) {
            return (C)((DbmNamespace)this.get(name, caseSensitively));
        }
        throw new IllegalStateException("Namespaces cannot be overloaded");
    }

    @Override
    protected void modifying() {
        this.myModel.doingRootsModify();
    }
}

