/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.PropertyHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaObjectRef<O extends DbmMajor>
implements PropertyHolder {
    @NotNull
    private final DbmModel myModel;
    @NotNull
    private final ObjectKind myKind;
    @Nullable
    private String mySchemaName;
    @Nullable
    private String myObjectName;
    @Nullable
    private O myObject;

    public SchemaObjectRef(@NotNull DbmModel model, @NotNull ObjectKind kind) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/SchemaObjectRef", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/SchemaObjectRef", "<init>"));
        }
        this.myModel = model;
        this.myKind = kind;
    }

    @Nullable
    public O getObject() {
        return this.myObject;
    }

    public void setObject(@Nullable O object) {
        if (this.myObject == object) {
            return;
        }
        this.myObject = object;
        if (object != null) {
            this.mySchemaName = ((DbmMajor)object).schema().getName();
            this.myObjectName = ((DbmObject)object).getName();
        } else {
            this.mySchemaName = null;
            this.myObjectName = null;
        }
    }

    public void setObject(String schemaName, String objectName) {
        this.mySchemaName = schemaName;
        this.myObjectName = objectName;
        this.myObject = null;
        this.resolve(schemaName, objectName);
    }

    public void resolve(String schemaName, String objectName) {
        DbmSchema theSchema = this.myModel.findSchema(schemaName);
        if (theSchema != null) {
            Family<? extends DbmMajor> theFamily = theSchema.family(this.myKind);
            DbmMajor theObject = theFamily.get(objectName);
            this.myObject = theObject;
        } else {
            this.myObject = null;
        }
    }

    @Nullable
    public String getSchemaName() {
        return this.mySchemaName;
    }

    @Nullable
    public String getObjectName() {
        return this.myObjectName;
    }

    @Override
    public String exportState() {
        if (this.myObject != null && ((DbmObject)this.myObject).hasName()) {
            String schemaName = ((DbmMajor)this.myObject).schema().getName();
            return (schemaName != null ? schemaName + '.' : "") + ((DbmObject)this.myObject).getName();
        }
        if (this.myObjectName != null) {
            return (this.mySchemaName != null ? this.mySchemaName + '.' : "") + this.myObjectName;
        }
        return null;
    }

    @Override
    public void importState(String text) {
        if (text != null) {
            int dot = text.lastIndexOf(46);
            if (dot >= 0) {
                this.setObject(text.substring(0, dot), text.substring(dot + 1));
            } else {
                this.setObject(null, text);
            }
        } else {
            this.clearState();
        }
    }

    @Override
    public void clearState() {
        this.myObject = null;
        this.myObjectName = null;
        this.mySchemaName = null;
    }
}

