/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringItems
implements PropertyHolder,
Iterable<String> {
    @NotNull
    private final DbmObject myOwner;
    private final AtomicReference<ImmutableList<String>> myItems;
    private static final List<String> NO_ITEMS = Collections.emptyList();

    public StringItems(@NotNull DbmObject owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/StringItems", "<init>"));
        }
        this.myItems = new AtomicReference();
        this.myOwner = owner;
    }

    public synchronized void assign(@Nullable String[] items) {
        if (items == null || items.length == 0) {
            this.clearState();
            return;
        }
        this.myOwner.modifying();
        ImmutableList newList = ImmutableList.copyOf((Object[])items);
        this.myItems.set((ImmutableList<String>)newList);
    }

    @Override
    public final ListIterator<String> iterator() {
        ImmutableList<String> list = this.myItems.get();
        return list != null ? list.listIterator() : NO_ITEMS.listIterator();
    }

    public final List<String> asList() {
        ImmutableList<String> list = this.myItems.get();
        return list != null ? list : NO_ITEMS;
    }

    public final String[] asArray() {
        ImmutableList<String> list = this.myItems.get();
        return list != null ? (String[])list.toArray((Object[])new String[list.size()]) : ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String exportState() {
        ImmutableList<String> list = this.myItems.get();
        if (list == null) {
            return null;
        }
        return StringUtil.join(list, (String)",");
    }

    @Override
    public void importState(String text) {
        if (text == null) {
            this.clearState();
            return;
        }
        String text2 = text.trim();
        if (text2.length() == 0) {
            this.clearState();
            return;
        }
        String[] items = text2.split(",");
        int n = items.length;
        for (int i = 0; i < n; ++i) {
            items[i] = items[i].trim();
        }
        this.assign(items);
    }

    @Override
    public synchronized void clearState() {
        if (this.myItems.get() == null) {
            return;
        }
        this.myOwner.modifying();
        this.myItems.set(null);
    }
}

