/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mysql;

import java.util.List;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

final class MysqlIntroQueries {
    static final MysqlIntroQueries QUERIES = new MysqlIntroQueries();
    private final Scriptum myScriptum = Scriptum.of(MysqlIntroQueries.class);
    final SqlQuery<List<Table>> queryTablesAndViews = this.myScriptum.query("RetrieveTablesAndViewsInfo", Layouts.listOf((RowLayout)Layouts.structOf(Table.class)));
    final SqlQuery<List<Index>> queryIndices = this.myScriptum.query("RetrieveIndicesInfo", Layouts.listOf((RowLayout)Layouts.structOf(Index.class)));
    final SqlQuery<List<Constraint>> queryConstraints = this.myScriptum.query("RetrieveConstraintsInfo", Layouts.listOf((RowLayout)Layouts.structOf(Constraint.class)));
    final SqlQuery<List<Routine>> queryRoutines = this.myScriptum.query("RetrieveRoutinesInfo", Layouts.listOf((RowLayout)Layouts.structOf(Routine.class)));
    final SqlQuery<String> parametersTableExists = this.myScriptum.query("ParametersTableExists", Layouts.rowOf((RowLayout)Layouts.oneOf(String.class)));
    final SqlQuery<List<Parameter>> queryRoutineParams = this.myScriptum.query("RetrieveRoutineParamsInfo", Layouts.listOf((RowLayout)Layouts.structOf(Parameter.class)));
    final SqlQuery<List<Column>> queryColumns = this.myScriptum.query("RetrieveTableColumnsInfo", Layouts.listOf((RowLayout)Layouts.structOf(Column.class)));
    final SqlQuery<List<View>> queryViews = this.myScriptum.query("RetrieveViewsInfo", Layouts.listOf((RowLayout)Layouts.structOf(View.class)));
    final SqlQuery<List<Trigger>> queryTriggers = this.myScriptum.query("RetrieveTriggersInfo", Layouts.listOf((RowLayout)Layouts.structOf(Trigger.class)));

    MysqlIntroQueries() {
    }

    static final class Trigger {
        String trigger_name;
        String event_object_table;
        String action_statement;

        Trigger() {
        }
    }

    static final class View {
        String table_name;
        String view_definition;

        View() {
        }
    }

    static final class Column {
        String column_name;
        String column_type;
        String column_default;
        String table_name;
        String column_comment;
        String is_nullable;
        String extra;

        Column() {
        }
    }

    static final class Parameter {
        String specific_name;
        String parameter_name;
        String parameter_mode;
        String dtd_identifier;

        Parameter() {
        }
    }

    static final class Routine {
        String specific_name;
        String routine_type;
        String routine_definition;
        String routine_comment;
        String dtd_identifier;

        Routine() {
        }
    }

    static final class Constraint {
        String constraint_name;
        String table_name;
        String constraint_type;
        String column_names;
        String referenced_table_schema;
        String referenced_table_name;
        String ref_column_names;

        Constraint() {
        }
    }

    static final class Index {
        String table_name;
        String index_name;
        String column_names;
        boolean non_unique;

        Index() {
        }
    }

    static final class Table {
        String table_name;
        String table_type;
        String table_comment;

        Table() {
        }
    }
}

