/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mysql;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DBIntrospectionError;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.mysql.MysqlIntroQueries;
import com.intellij.dbm.mysql.MysqlModel;
import com.intellij.dbm.mysql.MysqlSchema;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;

public class MysqlIntrospector
extends BaseIntrospector<MysqlSchema, MysqlModel> {
    public MysqlIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/mysql/MysqlIntrospector", "<init>"));
        }
        super(facade);
    }

    @Override
    @NotNull
    protected MysqlModel createNewModel() {
        MysqlModel mysqlModel = new MysqlModel();
        if (mysqlModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "createNewModel"));
        }
        return mysqlModel;
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull MysqlSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mysql/MysqlIntrospector", "isPossibleToIntrospectSchemaIncrementally"));
        }
        return false;
    }

    private void workWithModel(final @NotNull PairConsumer<DBTransaction, MysqlModel> worker) {
        if (worker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "worker", "com/intellij/dbm/mysql/MysqlIntrospector", "workWithModel"));
        }
        this.myFacade.inTransaction(new InTransactionNoResult(){

            public void run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$1", "run"));
                }
                ((MysqlModel)MysqlIntrospector.this.myModel).startModifications();
                try {
                    worker.consume((Object)tran, (Object)MysqlIntrospector.this.myModel);
                }
                finally {
                    ((MysqlModel)MysqlIntrospector.this.myModel).finishModifications();
                }
            }
        });
    }

    @Override
    public void introspect() {
        this.workWithModel(new PairConsumer<DBTransaction, MysqlModel>(){

            public void consume(@NotNull DBTransaction transaction, MysqlModel model) {
                if (transaction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/mysql/MysqlIntrospector$2", "consume"));
                }
                MysqlIntrospector.this.introspectSchemas(transaction, (MysqlModel)MysqlIntrospector.this.myModel);
            }
        });
        this.postIntrospectionProcess();
    }

    @Override
    protected void postIntrospectionProcess() {
        this.workWithModel(new PairConsumer<DBTransaction, MysqlModel>(){

            public void consume(DBTransaction transaction, @NotNull MysqlModel model) {
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/mysql/MysqlIntrospector$3", "consume"));
                }
                for (DbmSchema schema : model.getAllSchemas()) {
                    schema.derefAll();
                }
            }
        });
    }

    private void introspectSchemas(@NotNull DBTransaction tran, @NotNull MysqlModel model) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector", "introspectSchemas"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/mysql/MysqlIntrospector", "introspectSchemas"));
        }
        MultiMap<String, String> scope = this.myOptions.getScope();
        Family schemas = model.schemas();
        Set<String> newNames = MysqlIntrospector.newSet();
        String currentSchemaName = (String)tran.query("select schema()", Layouts.rowOf((RowLayout)Layouts.oneOf(String.class))).run();
        for (String s : (List)tran.query("select schema_name from information_schema.schemata", Layouts.listOf((RowLayout)Layouts.oneOf(String.class))).run()) {
            if (!scope.containsKey((Object)s) && (!s.equalsIgnoreCase(currentSchemaName) || !scope.containsKey((Object)"@")) && !scope.containsKey((Object)"*")) continue;
            newNames.add(s);
            MysqlSchema sch = (MysqlSchema)schemas.getOrCreate(s);
            if (s.equals(currentSchemaName)) {
                ((MysqlModel)this.myModel).setCurrentRoot(sch);
            }
            new SchemaRetriever(sch).retrieve(tran);
        }
        MysqlIntrospector.drop(newNames, model.schemas());
        model.schemas().reorder();
    }

    private static <T> Set<T> newSet() {
        return new SmartHashSet();
    }

    private static void drop(@NotNull Set<String> newNames, @NotNull Family<? extends DbmObject> f) {
        if (newNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNames", "com/intellij/dbm/mysql/MysqlIntrospector", "drop"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/dbm/mysql/MysqlIntrospector", "drop"));
        }
        for (DbmObject dbmObject : f) {
            if (newNames.contains(dbmObject.getName())) continue;
            dbmObject.drop();
        }
    }

    @NotNull
    private static DasRoutine.Kind getType(@Nullable String type) {
        if ("FUNCTION".equalsIgnoreCase(type)) {
            DasRoutine.Kind kind = DasRoutine.Kind.FUNCTION;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getType"));
            }
            return kind;
        }
        if ("PROCEDURE".equalsIgnoreCase(type)) {
            DasRoutine.Kind kind = DasRoutine.Kind.PROCEDURE;
            if (kind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getType"));
            }
            return kind;
        }
        DasRoutine.Kind kind = DasRoutine.Kind.NONE;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getType"));
        }
        return kind;
    }

    @NotNull
    private static DasArgument.Direction getDirection(@Nullable String mode) {
        if ("INOUT".equalsIgnoreCase(mode)) {
            DasArgument.Direction direction = DasArgument.Direction.INOUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
            }
            return direction;
        }
        if ("OUT".equalsIgnoreCase(mode)) {
            DasArgument.Direction direction = DasArgument.Direction.OUT;
            if (direction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
            }
            return direction;
        }
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
        }
        return direction;
    }

    @NotNull
    public static DasArgument.Direction getDirection(int id) {
        switch (id) {
            case 4: {
                DasArgument.Direction direction = DasArgument.Direction.OUT;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
                }
                return direction;
            }
            case 2: {
                DasArgument.Direction direction = DasArgument.Direction.INOUT;
                if (direction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
                }
                return direction;
            }
        }
        DasArgument.Direction direction = DasArgument.Direction.IN;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mysql/MysqlIntrospector", "getDirection"));
        }
        return direction;
    }

    private final class SchemaRetriever {
        final MysqlSchema mySchema;

        SchemaRetriever(MysqlSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "<init>"));
            }
            this.mySchema = schema;
        }

        private void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "work"));
            }
            this.mySchema.model.startModifications();
            try {
                runnable.run();
            }
            finally {
                this.mySchema.model.finishModifications();
            }
        }

        private void progress(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "progress"));
            }
            String mode = "completely";
            MysqlIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", this.mySchema.getName(), mode), what);
        }

        void retrieve(final @NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieve"));
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveTables(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveColumns(tran);
                }
            });
            if (this.mySchema.getName().equalsIgnoreCase("information_schema")) {
                return;
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveIndices(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveRoutines(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveRoutineParameters(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveTableConstraints(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveTriggers(tran);
                }
            });
            if (((MysqlIntrospector)MysqlIntrospector.this).myOptions.withSources) {
                this.work(new Runnable(){

                    @Override
                    public void run() {
                        SchemaRetriever.this.retrieveViewSources(tran);
                    }
                });
            }
        }

        private void retrieveTables(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveTables"));
            }
            this.progress("tables and views");
            Set newTables = MysqlIntrospector.newSet();
            Set newViews = MysqlIntrospector.newSet();
            for (MysqlIntroQueries.Table t : (List)tran.query(MysqlIntroQueries.QUERIES.queryTablesAndViews).withParams(new Object[]{this.mySchema.getName()}).run()) {
                String type = t.table_type;
                boolean isView = StringUtil.contains((CharSequence)type, (CharSequence)"VIEW");
                (isView ? newViews : newTables).add(t.table_name);
                DbmLikeTable o = (isView ? this.mySchema.views() : this.mySchema.tables()).getOrCreate(t.table_name);
                o.dropChildren();
                o.setIsSystem(StringUtil.containsIgnoreCase((String)type, (String)"SYSTEM"));
                o.setComment(t.table_comment);
            }
            MysqlIntrospector.drop(newTables, this.mySchema.tables());
            MysqlIntrospector.drop(newViews, this.mySchema.views());
        }

        private void retrieveIndices(DBTransaction t) {
            this.progress("indices");
            String schemaName = this.mySchema.getName();
            for (MysqlIntroQueries.Index i : (List)t.query(MysqlIntroQueries.QUERIES.queryIndices).withParams(new Object[]{schemaName, schemaName}).run()) {
                DbmTable table = this.mySchema.tables().get(i.table_name);
                if (table == null) continue;
                DbmIndex index = table.indices().getOrCreate(i.index_name);
                index.setUnique(!i.non_unique);
                for (String s : StringUtil.splitByLines((String)StringUtil.notNullize((String)i.column_names))) {
                    index.addColumn(s, DasIndex.Sorting.ASCENDING);
                }
            }
        }

        private void retrieveTableConstraints(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveTableConstraints"));
            }
            this.progress("table constraints");
            String schemaName = this.mySchema.getName();
            for (MysqlIntroQueries.Constraint c : (List)t.query(MysqlIntroQueries.QUERIES.queryConstraints).withParams(new Object[]{schemaName, schemaName, schemaName}).run()) {
                DbmTable table = this.mySchema.tables().get(c.table_name);
                if (table == null) continue;
                String[] columnNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)c.column_names));
                String name = c.constraint_name;
                if ("PRIMARY KEY".equals(c.constraint_type)) {
                    DbmKey pk = table.keys().getOrCreate(name);
                    pk.setPrimary(true);
                    pk.setColumnNames(columnNames);
                    continue;
                }
                if ("FOREIGN KEY".equals(c.constraint_type)) {
                    String[] refColumnNames = StringUtil.splitByLines((String)StringUtil.notNullize((String)c.ref_column_names));
                    DbmForeignKey fk = table.foreignKeys().getOrCreate(name);
                    fk.setColumnNames(columnNames);
                    String s = c.referenced_table_schema;
                    String tn = c.referenced_table_name;
                    if (s == null || tn == null) continue;
                    fk.refKey.set(new String[]{s, tn}, refColumnNames);
                    continue;
                }
                if (!"UNIQUE".equals(c.constraint_type)) continue;
                DbmKey key = table.keys().getOrCreate(name);
                key.myColumns.clearState();
                key.setColumnNames(columnNames);
                DbmIndex index = table.indices().get(name);
                if (index == null) {
                    index = table.indices().create(name);
                    index.setUnique(true);
                    for (String s : columnNames) {
                        index.addColumn(s, DasIndex.Sorting.ASCENDING);
                    }
                }
                key.setUnderlyingIndex(index);
            }
        }

        private void retrieveRoutines(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutines"));
            }
            this.progress("routines");
            Set newNames = MysqlIntrospector.newSet();
            for (MysqlIntroQueries.Routine r : (List)t.query(MysqlIntroQueries.QUERIES.queryRoutines).withParams(new Object[]{this.mySchema.getName()}).run()) {
                newNames.add(r.specific_name);
                DbmSingleRoutine routine = this.mySchema.routines().getOrCreate(r.specific_name);
                routine.dropChildren();
                if (((MysqlIntrospector)MysqlIntrospector.this).myOptions.withSources) {
                    routine.setSourceText(r.routine_definition);
                }
                DasRoutine.Kind type = MysqlIntrospector.getType(r.routine_type);
                routine.setRoutineKind(type);
                if (type == DasRoutine.Kind.FUNCTION) {
                    DbmArgument returnArgument = routine.getOrCreateReturnArgument();
                    returnArgument.setDataType(DataTypeFactory.of(r.dtd_identifier));
                }
                routine.setComment(r.routine_comment);
            }
            MysqlIntrospector.drop(newNames, this.mySchema.routines());
        }

        private void retrieveRoutineParameters(@NotNull DBTransaction t) {
            boolean withoutParameters;
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutineParameters"));
            }
            this.progress("routine parameters");
            boolean bl = withoutParameters = t.query(MysqlIntroQueries.QUERIES.parametersTableExists).run() == null;
            if (withoutParameters) {
                this.retrieveRoutineParametersFromMetaData(t);
            } else {
                this.retrieveRoutineParametersFromInformationSchema(t);
            }
        }

        private void retrieveRoutineParametersFromInformationSchema(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutineParametersFromInformationSchema"));
            }
            for (MysqlIntroQueries.Parameter p : (List)t.query(MysqlIntroQueries.QUERIES.queryRoutineParams).withParams(new Object[]{this.mySchema.getName()}).run()) {
                DbmSingleRoutine routine = this.mySchema.routines().getOrCreate(p.specific_name);
                DbmArgument arg = routine.arguments().getOrCreate(p.parameter_name);
                arg.setDataType(DataTypeFactory.of(p.dtd_identifier));
                arg.setDirection(MysqlIntrospector.getDirection(p.parameter_mode));
            }
        }

        private void retrieveRoutineParametersFromMetaData(@NotNull DBTransaction t) {
            if (t == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveRoutineParametersFromMetaData"));
            }
            if (!(t instanceof DBSession)) {
                return;
            }
            Connection connection = (Connection)((DBSession)t).getSpecificService(Connection.class, "jdbc-connection");
            if (connection == null) {
                return;
            }
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                ResultSet c = metaData.getProcedureColumns(this.mySchema.getName(), null, null, null);
                while (c.next()) {
                    String name = c.getString("COLUMN_NAME");
                    if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                    DbmSingleRoutine routine = this.mySchema.routines().getOrCreate(c.getString("PROCEDURE_NAME"));
                    DbmArgument arg = routine.arguments().getOrCreate(name);
                    arg.setDataType(DataTypeFactory.of(c.getString("TYPE_NAME")));
                    arg.setDirection(MysqlIntrospector.getDirection(c.getShort("COLUMN_TYPE")));
                }
            }
            catch (SQLException e) {
                throw new DBIntrospectionError((Throwable)e){};
            }
        }

        private void retrieveColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveColumns"));
            }
            this.progress("table columns");
            for (MysqlIntroQueries.Column c : (List)tran.query(MysqlIntroQueries.QUERIES.queryColumns).withParams(new Object[]{this.mySchema.getName()}).run()) {
                String tableName = c.table_name;
                DbmLikeTable table = this.mySchema.tables().get(tableName);
                if (table == null) {
                    table = this.mySchema.views().get(tableName);
                }
                if (table == null) continue;
                DbmColumn column = table.columns().getOrCreate(c.column_name);
                column.setMandatory(!"YES".equals(c.is_nullable));
                DataType type = DataTypeFactory.of(c.column_type);
                column.setDataType(type);
                column.setComment(c.column_comment);
                String def = c.column_default;
                if (def == null) continue;
                boolean bit = "bit".equalsIgnoreCase(type.typeName);
                column.setDefaultExpression(bit ? def : "'" + def + "'");
            }
        }

        private void retrieveViewSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveViewSources"));
            }
            this.progress("view sources");
            for (MysqlIntroQueries.View t : (List)tran.query(MysqlIntroQueries.QUERIES.queryViews).withParams(new Object[]{this.mySchema.getName()}).run()) {
                DbmView o = this.mySchema.views().getOrCreate(t.table_name);
                o.setSourceText(t.view_definition);
            }
        }

        private void retrieveTriggers(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/mysql/MysqlIntrospector$SchemaRetriever", "retrieveTriggers"));
            }
            this.progress("triggers");
            for (MysqlIntroQueries.Trigger t : (List)tran.query(MysqlIntroQueries.QUERIES.queryTriggers).withParams(new Object[]{this.mySchema.getName()}).run()) {
                DbmTable table = this.mySchema.tables().getOrCreate(t.event_object_table);
                DbmTrigger trigger = table.triggers().getOrCreate(t.trigger_name);
                if (!((MysqlIntrospector)MysqlIntrospector.this).myOptions.withSources) continue;
                trigger.setSourceText(t.action_statement);
            }
        }
    }
}

