/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.database.model.LengthUnit;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.CascadeRule;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmError;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmInnerRoutine;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.common.TableOrganization;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraCollectionType;
import com.intellij.dbm.oracle.OraIntroQueries;
import com.intellij.dbm.oracle.OraModel;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.dbm.oracle.OraModuleAttribute;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraPackage;
import com.intellij.dbm.oracle.OraRevEngUtils;
import com.intellij.dbm.oracle.OraSchema;
import com.intellij.dbm.oracle.OraSequence;
import com.intellij.dbm.oracle.OraTable;
import com.intellij.dbm.oracle.OraView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.Version;

public class OraIntrospector
extends BaseIntrospector<OraSchema, OraModel> {
    private static final Set<String> SYSTEM_SCHEMAS = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object)"SYS").add((Object)"SYSTEM").add((Object)"CTXSYS").build();
    @NotNull
    private final OraIntroQueries myQueries;
    @NotNull
    private static final Logger LOG = Logger.getInstance(OraIntrospector.class);
    private boolean myUseFastWay;
    @NotNull
    private Version myOracleVersion;
    private final LinkedHashSet<String> myIntrospectingSchemaNames;
    private static final Pattern SIMPLE_QUOTED_NAME_PATTERN = Pattern.compile("^\\s*\"([^\"]*)\"\\s*$");
    private static final Pattern AUTO_NOT_NULL_CHECK_PATTERN = Pattern.compile("\".+\" IS NOT NULL");

    public OraIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/oracle/OraIntrospector", "<init>"));
        }
        super(facade);
        this.myUseFastWay = false;
        this.myOracleVersion = Version.of((int[])new int[]{0});
        this.myIntrospectingSchemaNames = new LinkedHashSet();
        this.myQueries = OraIntroQueries.QUERIES;
    }

    @Override
    @NotNull
    protected IntrospectionOptions prepareDefaultOptions(@NotNull OraModel model) {
        boolean incremental;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/oracle/OraIntrospector", "prepareDefaultOptions"));
        }
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("@");
        if (model.schemas().isNotEmpty()) {
            schemaNames.addAll(model.schemas().getNames());
            incremental = true;
        } else {
            incremental = false;
        }
        IntrospectionOptions introspectionOptions = IntrospectionOptions.of(schemaNames, incremental, true, true);
        if (introspectionOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "prepareDefaultOptions"));
        }
        return introspectionOptions;
    }

    @Override
    @NotNull
    protected OraModel createNewModel() {
        OraModel oraModel = new OraModel();
        if (oraModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "createNewModel"));
        }
        return oraModel;
    }

    @Override
    public void introspect() {
        if (!this.myInitialized) {
            throw new IllegalStateException("OraIntrospector is not initialized yet.");
        }
        this.introspectDatabaseAndSchemas();
        this.introspectAllSchemasObjects();
        this.postIntrospectionProcess();
    }

    private void introspectDatabaseAndSchemas() {
        this.workWithModel(new BaseIntrospector.ModelWorker<OraModel>(){

            @Override
            public void working(DBTransaction tran, OraModel model) {
                OraIntrospector.this.checkFastWayPossibility(tran);
                OraIntrospector.this.introspectDatabaseAndSchemas(tran, model);
            }
        });
    }

    /*
     * Loose catch block
     */
    private void checkFastWayPossibility(DBTransaction tran) {
        try {
            this.myUseFastWay = (Boolean)tran.query(this.myQueries.checkBaseDictionariesAccess).run();
            LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
        }
        catch (NoTableOrViewException ntv) {
            this.myUseFastWay = false;
            LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
        }
        catch (Exception e) {
            LOG.warn("An unexpected exception when checking access to the base dictionary: " + e.getMessage(), (Throwable)e);
            this.myUseFastWay = false;
            LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
            {
                catch (Throwable throwable) {
                    LOG.info("Using the " + (this.myUseFastWay ? "FAST" : "SLOW") + " way to access the Oracle Database Catalog");
                    throw throwable;
                }
            }
        }
    }

    private void introspectDatabaseAndSchemas(DBTransaction tran, OraModel model) {
        OraIntroQueries.OneSessionInfo si = (OraIntroQueries.OneSessionInfo)tran.query(this.myQueries.retrieveSessionInfo).run();
        Family schemas = model.schemas();
        schemas.markChildrenAsSyncPending();
        if (si.current_schema != null) {
            OraSchema currentSchema = (OraSchema)schemas.getOrCreate(si.current_schema);
            model.setCurrentSchema(currentSchema);
        }
        if (si.oracle_version != null) {
            try {
                this.myOracleVersion = Version.of((String)si.oracle_version);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myIntrospectingSchemaNames.clear();
        for (String s : this.myOptions.getScope().values()) {
            if (s.equals("@")) {
                if (si.current_schema != null) {
                    this.myIntrospectingSchemaNames.add(si.current_schema);
                }
                if (si.current_user == null) continue;
                this.myIntrospectingSchemaNames.add(si.current_user);
                continue;
            }
            if (s.equals("*")) {
                Collection schemaNames = (Collection)tran.query(this.myQueries.retrieveAccessibleSchemas).run();
                this.myIntrospectingSchemaNames.addAll(schemaNames);
                continue;
            }
            this.myIntrospectingSchemaNames.add(s);
        }
        for (String schemaName : this.myIntrospectingSchemaNames) {
            schemas.getOrCreate(schemaName);
        }
        schemas.removeSyncPendingChildren();
        schemas.reorder();
    }

    private void introspectAllSchemasObjects() {
        for (String schemaName : this.myIntrospectingSchemaNames) {
            this.introspectOneSchemaObjects(schemaName);
        }
    }

    private void introspectOneSchemaObjects(String schemaName) {
        final OraSchema schema = (OraSchema)((OraModel)this.myModel).schemas().getOrCreate(schemaName);
        final SchemaRetriever retriever = new SchemaRetriever(schema);
        this.myFacade.inTransaction(new InTransactionNoResult(){

            public void run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$2", "run"));
                }
                if (!schema.isPublic()) {
                    retriever.retrieveMain(tran);
                } else {
                    retriever.retrievePublic(tran);
                }
            }
        });
    }

    @Override
    protected void postIntrospectionProcess(OraModel model) {
        for (DbmSchema schema : model.schemas()) {
            schema.derefAll();
        }
    }

    @NotNull
    @Contract(pure=true)
    static String unquoteNameIfPossible(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
        }
        Matcher m = SIMPLE_QUOTED_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            String string = m.group(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
        }
        return string;
    }

    private static DataType makeDataType(@Nullable String schemaName, @Nullable String typeName, int precision, int scale, @Nullable String units) {
        DataType type;
        if (typeName == null) {
            type = DataType.UNKNOWN;
        } else if (typeName.contains("(")) {
            type = DataTypeFactory.of(typeName);
        } else {
            boolean explicitUnits = (typeName.equalsIgnoreCase("varchar") || typeName.equalsIgnoreCase("char")) && units != null && units.equalsIgnoreCase("C");
            type = schemaName == null ? DataTypeFactory.of(null, typeName, precision, scale, LengthUnit.of((String)units), null, explicitUnits, false) : DataTypeFactory.of(schemaName, typeName, -1, 0, null, null, false, true);
        }
        return type;
    }

    private static void makeArgument(@NotNull DbmRoutine routine, String argName, char argDirection, String dataTypeSchemaName, String dataTypeSpec) {
        DbmArgument argument;
        if (routine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/oracle/OraIntrospector", "makeArgument"));
        }
        DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
        if (dir == null && argName != null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == null) {
            dir = DasArgument.Direction.IN;
        }
        if (dir == DasArgument.Direction.RETURN) {
            argument = routine.getOrCreateReturnArgument();
            argument.setName(argName);
        } else if (argName != null) {
            argument = routine.arguments().getOrCreate(argName);
            argument.setDirection(dir);
        } else {
            return;
        }
        DataType type = DataTypeFactory.of(dataTypeSchemaName, dataTypeSpec, -1, 0, null, null, false, dataTypeSchemaName != null);
        argument.setDataType(type);
    }

    private static void applySources(@NotNull OraSchema schema, @NotNull String type, @NotNull String name, @NotNull String sourceText) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (sourceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceText", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (sourceText.length() == 0) {
            return;
        }
        DbmSourceAware sa = (DbmSourceAware)((Object)(type.equals("TYPE") ? schema.objectTypes().getOrCreate(name) : (type.equals("TYPE BODY") ? schema.objectTypes().getOrCreate(name).getOrCreateBody() : (type.equals("PACKAGE") ? schema.packages().getOrCreate(name) : (type.equals("PACKAGE BODY") ? schema.packages().getOrCreate(name).getOrCreateBody() : (type.equals("FUNCTION") || type.equals("PROCEDURE") ? schema.routines().getOrCreate(name) : null))))));
        if (sa == null) {
            return;
        }
        sa.setSourceText(sourceText);
    }

    private final class SchemaRetriever {
        @NotNull
        private final OraSchema schema;
        @NotNull
        private final Timestamp fromTimestamp;
        private Timestamp myBeginTimestamp;
        boolean incremental;
        boolean affectsTables;
        boolean affectsViews;
        boolean affectsTriggers;
        boolean affectsSingleRoutines;
        boolean affectsModulesOrBodies;
        boolean toStop;
        private final Set<DbmLikeTable> myTablesToReorderDetails;
        private final Set<OraModule> myAffectedModules;
        private final Set<DbmObject> myAffectedDepObjects;

        SchemaRetriever(OraSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "<init>"));
            }
            this.toStop = false;
            this.myTablesToReorderDetails = new HashSet<DbmLikeTable>();
            this.myAffectedModules = new HashSet<OraModule>();
            this.myAffectedDepObjects = new HashSet<DbmObject>();
            this.schema = schema;
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : EPOCH;
            this.incremental = ((OraIntrospector)OraIntrospector.this).myOptions.incremental && lastIntrospectionTimestamp != null;
        }

        void retrieveMain(final @NotNull DBTransaction tran) {
            boolean skipSystemSchema;
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveMain"));
            }
            boolean bl = skipSystemSchema = this.incremental && SYSTEM_SCHEMAS.contains(this.schema.getName()) && !OraIntrospector.this.myConsiderSystemSchemasReinstrospection && !this.schema.isCurrent();
            if (skipSystemSchema) {
                return;
            }
            this.myBeginTimestamp = (Timestamp)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.askForTimeNow).run();
            assert (this.myBeginTimestamp != null) : "Failed to obtain the current timestamp from the database";
            this.reportRetrieving("schema information");
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveSchemaInfo(tran);
                }
            });
            if (this.toStop) {
                return;
            }
            if (this.incremental) {
                this.reportRetrieving("detect dropped objects");
                this.detectAndRemoveDroppedObjects(tran);
            } else {
                this.clearSchema();
            }
            Date modifiedTimestamp = this.schema.getModifiedTimestamp();
            boolean bl2 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.fromTimestamp);
            if (this.toStop) {
                return;
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveSequences(tran);
                    SchemaRetriever.this.retrieveObjectTypes(tran);
                    SchemaRetriever.this.retrieveCollectionTypes(tran);
                    SchemaRetriever.this.retrieveObjectTypeAttributes(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveTables(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveViews(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveColumns(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveColumnDefaults(tran);
                    SchemaRetriever.this.retrieveColumnComments(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveIndices(tran);
                    SchemaRetriever.this.retrieveIndicesColumns(tran);
                    SchemaRetriever.this.retrieveKeys(tran);
                    SchemaRetriever.this.retrieveForeignKeys(tran);
                    SchemaRetriever.this.retrieveChecks(tran);
                    SchemaRetriever.this.retrieveConstraintColumns(tran);
                    SchemaRetriever.this.reorderTableDetails();
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveTriggers(tran);
                    SchemaRetriever.this.retrievePackages(tran);
                    SchemaRetriever.this.retrieveInnerRoutines(tran);
                    SchemaRetriever.this.retrieveInnerRoutinesArguments(tran);
                    SchemaRetriever.this.retrieveSingleRoutines(tran);
                    SchemaRetriever.this.retrieveSingleRoutinesArguments(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveSynonyms(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveDependencies(tran);
                }
            });
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveViewSources(tran);
                    SchemaRetriever.this.retrieveSources(tran);
                    SchemaRetriever.this.retrieveErrors(tran);
                }
            });
            this.reportRetrieving("finishing the schema...");
            long stateNumber = 0L;
            this.schema.setIntrospectionActualPoint(stateNumber, this.myBeginTimestamp);
        }

        void retrievePublic(final @NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrievePublic"));
            }
            this.myBeginTimestamp = (Timestamp)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.askForTimeNow).run();
            assert (this.myBeginTimestamp != null) : "Failed to obtain the current timestamp from the database";
            this.reportRetrieving("schema information");
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveSchemaInfo(tran);
                }
            });
            if (this.toStop) {
                return;
            }
            if (this.incremental) {
                this.reportRetrieving("detect dropped objects");
                this.detectAndRemoveDroppedObjects(tran);
            } else {
                this.clearSchema();
            }
            Date modifiedTimestamp = this.schema.getModifiedTimestamp();
            boolean bl = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.fromTimestamp);
            if (this.toStop) {
                return;
            }
            this.work(new Runnable(){

                @Override
                public void run() {
                    SchemaRetriever.this.retrieveSynonyms(tran);
                }
            });
            this.reportRetrieving("finishing the schema...");
            long stateNumber = 0L;
            this.schema.setIntrospectionActualPoint(stateNumber, this.myBeginTimestamp);
        }

        private void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "work"));
            }
            OraIntrospector.this.myProgressIndicator.checkCanceled();
            this.schema.model.startModifications();
            try {
                runnable.run();
            }
            finally {
                this.schema.model.finishModifications();
            }
        }

        private void detectAndRemoveDroppedObjects(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "detectAndRemoveDroppedObjects"));
            }
            long schemaId = this.schema.getObjectId();
            boolean schemaIdKnown = schemaId > 0L || schemaId == 0L && this.schema.isName("SYS");
            long[] identifierArray = null;
            if (OraIntrospector.this.myUseFastWay && schemaIdKnown) {
                try {
                    identifierArray = (long[])tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectIdentifiersFast).withParams(new Object[]{this.schema.getObjectId()}).run();
                }
                catch (NoTableOrViewException nte) {
                    OraIntrospector.this.myUseFastWay = false;
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception when trying fast object listing: " + e.getMessage() + "\nSwitching to the SLOW Database Catalog accessing");
                    OraIntrospector.this.myUseFastWay = false;
                }
            }
            if (identifierArray == null) {
                identifierArray = (long[])tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectIdentifiersSlow).withParams(new Object[]{this.schema.getName()}).run();
            }
            final TLongHashSet identifiers = new TLongHashSet(identifierArray);
            this.schema.traversBreadthFirst(DbmObject.class, new Processor<DbmObject>(){

                public boolean process(DbmObject object) {
                    long id = object.getObjectId();
                    if (id == 0L || identifiers.contains(id) || object instanceof DbmNamespace) {
                        return true;
                    }
                    object.drop();
                    return false;
                }
            });
        }

        private void clearSchema() {
            final ArrayList children = new ArrayList();
            this.schema.traverseChildren(DbmObject.class, new Consumer<DbmObject>(){

                public void consume(DbmObject object) {
                    children.add(object);
                }
            });
            for (int i = children.size() - 1; i >= 0; --i) {
                ((DbmObject)children.get(i)).drop();
            }
            this.schema.setCreatedAndModifiedTimestamps(null, null);
            this.schema.setIntrospectionActualPoint(0L, null);
        }

        @Nullable
        private DbmLikeTable getTableOrViewById(long id) {
            DbmLikeTable table = this.schema.tables().getByObjectId(id);
            if (table == null) {
                table = this.schema.views().getByObjectId(id);
            }
            if (table == null) {
                table = this.schema.matViews().getByObjectId(id);
            }
            return table;
        }

        private void retrieveSchemaInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveSchemaInfo"));
            }
            OraIntroQueries.OneSchemaInfo info = this.schema.isPublic() ? (OraIntroQueries.OneSchemaInfo)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrievePublicSchemaInfo).run() : (OraIntroQueries.OneSchemaInfo)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveSchemaInfo).withParams(new Object[]{this.schema.getName(), this.schema.getName()}).run();
            if (info == null) {
                LOG.warn("Failed to obtain schema info for schema: " + this.schema.getName() + "; switching to non-incremental introspection");
                this.incremental = false;
                return;
            }
            this.schema.setObjectId(info.user_id);
            this.schema.setCreatedAndModifiedTimestamps(info.created_timestamp, info.modified_timestamp);
        }

        private void retrieveSequences(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveSequences"));
            }
            this.reportRetrieving("Sequences");
            List seqs = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveSequences).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (seqs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneSequence seq : seqs) {
                OraSequence sequence = this.schema.sequences().getOrCreate(seq.sequence_name);
                sequence.setMinValue(this.adjustBigIntegerForSequence(seq.min_value));
                sequence.setMaxValue(this.adjustBigIntegerForSequence(seq.max_value));
                sequence.setIncrementBy(seq.increment_by);
                sequence.setOrdered(seq.order_flag);
                sequence.setCycled(seq.cycle_flag);
                sequence.setCacheSize(seq.cache_size);
                sequence.setNextValue(this.adjustBigIntegerForSequence(seq.last_number));
                sequence.setObjectId(seq.object_id);
                sequence.setCreatedAndModifiedTimestamps(seq.created_timestamp, seq.modified_timestamp);
            }
            this.schema.sequences().reorder();
        }

        @Nullable
        private BigInteger adjustBigIntegerForSequence(@Nullable BigDecimal bigDecimalValue) {
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            return bi.toString().equals("9999999999999999999999999999") ? null : bi;
        }

        private void retrieveObjectTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveObjectTypes"));
            }
            this.reportRetrieving("Object Types");
            List ots = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectTypes).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (ots.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneObjectType ot : ots) {
                OraObjectType superObjectType = null;
                if (ot.supertype_schema_name != null && ot.supertype_name != null) {
                    OraSchema superSchema = (OraSchema)((OraModel)OraIntrospector.this.myModel).schemas().getOrCreate(ot.supertype_schema_name);
                    superObjectType = superSchema.myObjectTypes.getOrCreate(ot.supertype_name);
                }
                OraObjectType oType = this.schema.myObjectTypes.renew(ot.object_id, ot.type_name);
                oType.superObject.setObject(superObjectType);
                oType.setCreatedAndModifiedTimestamps(ot.created_timestamp, ot.modified_timestamp);
                this.myAffectedDepObjects.add(oType);
                this.myAffectedModules.add(oType);
            }
            this.schema.myObjectTypes.reorder();
            this.affectsModulesOrBodies = true;
        }

        private void retrieveCollectionTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveCollectionTypes"));
            }
            if (!OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11})) {
                return;
            }
            this.reportRetrieving("Collection Types");
            List cts = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveCollectionTypes).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (cts.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneCollectionType ct : cts) {
                OraCollectionType cType = this.schema.myCollectionTypes.getOrCreate(ct.type_name);
                cType.setArray(ct.collection_kind == 'A');
                cType.setUpperBound(ct.upper_bound);
                DataType type = OraIntrospector.makeDataType(ct.data_type_schema_name, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                cType.setElementType(type);
                cType.setCreatedAndModifiedTimestamps(ct.created_timestamp, ct.modified_timestamp);
            }
            this.schema.myCollectionTypes.reorder();
        }

        private void retrieveObjectTypeAttributes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveObjectTypeAttributes"));
            }
            this.reportRetrieving("Object Type Attributes");
            List attrs = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectTypeAttributes).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneObjectTypeAttribute ota : attrs) {
                OraObjectType ot = this.schema.myObjectTypes.getOrCreate(ota.type_name);
                OraModuleAttribute attr = ot.attributes().getOrCreate(ota.attr_name);
                DataType type = OraIntrospector.makeDataType(ota.data_type_schema, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                attr.setType(type);
            }
        }

        private void retrieveTables(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveTables"));
            }
            this.reportRetrieving("Tables");
            SqlQuery<List<OraIntroQueries.OneTable>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{10}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTables10 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTables09;
            List tabs = (List)tran.query(query).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (tabs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneTable tab : tabs) {
                OraTable table = this.schema.tables().renew(tab.object_id, tab.table_name);
                table.setComment(tab.comments);
                table.setOrganization(TableOrganization.byCode(tab.organization_kind));
                table.setCreatedAndModifiedTimestamps(tab.created_timestamp, tab.modified_timestamp);
                if (tab.row_type_name != null) {
                    table.setRowObjectType(tab.row_type_schema_name, tab.row_type_name);
                } else if (this.incremental) {
                    table.setRowObjectType(null);
                }
                table.checks().clear();
                table.foreignKeys().clear();
                table.keys().clear();
                this.myAffectedDepObjects.add(table);
            }
            this.schema.tables().reorder();
            this.affectsTables = true;
        }

        private void retrieveViews(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveViews"));
            }
            this.reportRetrieving("Views");
            SqlQuery<List<OraIntroQueries.OneView>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViews11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViews10;
            List vs = (List)tran.query(query).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (vs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneView v : vs) {
                OraView view = this.schema.views().getOrCreate(v.view_name);
                view.setComment(v.comments);
                view.setModifiable(v.modifiable);
                view.setObjectId(v.object_id);
                view.setInvalid(v.is_invalid);
                view.setCreatedAndModifiedTimestamps(v.created_timestamp, v.modified_timestamp);
                view.checks().clear();
                view.foreignKeys().clear();
                view.keys().clear();
                this.myAffectedDepObjects.add(view);
            }
            this.affectsViews = true;
        }

        private void retrieveColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveColumns"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(this.schema.tables().size() + this.schema.views().size());
            DbmLikeTable table = null;
            long table_id = Long.MIN_VALUE;
            int columnIndex = 0;
            List cols = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumns).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneColumn col : cols) {
                if (col.table_id != table_id) {
                    table = this.getTableOrViewById(col.table_id);
                    if (table == null) continue;
                    table_id = col.table_id;
                    columnIndex = 0;
                    table.columns().markChildrenAsSyncPending();
                    affectedTables.add(table);
                }
                assert (table != null);
                Family<? extends DbmColumn> tableColumns = table.columns();
                DbmColumn column = tableColumns.getOrCreate(col.column_name);
                column.resetSyncPending();
                tableColumns.move(column, columnIndex);
                columnIndex = (short)(columnIndex + 1);
                DataType type = OraIntrospector.makeDataType(col.data_type_schema_name, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                column.setDataType(type);
                column.setMandatory(col.mandatory);
                if (col.default_expression != null) {
                    col.default_expression = col.default_expression.trim();
                    if (col.default_expression.isEmpty()) {
                        col.default_expression = null;
                    }
                }
                column.setDefaultExpression(col.default_expression);
            }
            if (((OraIntrospector)OraIntrospector.this).myOptions.incremental) {
                for (DbmLikeTable affectedTable : affectedTables) {
                    ImmutableList<? extends DbmColumn> columns = affectedTable.columns().asList();
                    for (int i = columns.size() - 1; i >= 0; --i) {
                        DbmColumn column = (DbmColumn)columns.get(i);
                        if (!column.isSyncPending()) continue;
                        column.drop();
                    }
                }
            }
            this.myTablesToReorderDetails.addAll(affectedTables);
        }

        private void retrieveColumnDefaults(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveColumnDefaults"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            List rows = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumnDefaults).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneColumnDefault col : rows) {
                DbmColumn column;
                DbmLikeTable table = this.schema.getTableOrView(col.table_name);
                if (table == null || (column = table.columns().get(col.column_name)) == null) continue;
                column.setDefaultExpression(col.default_expression);
            }
        }

        private void retrieveColumnComments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveColumnComments"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Column Comments");
            List rows = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumnComments).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneColumnComment col : rows) {
                DbmColumn column;
                DbmLikeTable table = this.schema.getTableOrView(col.table_name);
                if (table == null || (column = table.columns().get(col.column_name)) == null) continue;
                column.setComment(col.comments);
            }
        }

        private void retrieveIndices(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveIndices"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Indices");
            List indices = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveIndices).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (indices.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneIndex ind : indices) {
                OraTable table = this.schema.tables().getOrCreate(ind.table_name);
                DbmIndex index = table.indices().getOrCreate(ind.index_name);
                index.setNameSurrogate(OraRevEngUtils.matches(ind.index_name, OraRevEngUtils.surrogateNamePattern));
                index.setUnique(ind.uniqueness);
                index.setClustering(ind.clustering);
                index.setTablespaceName(ind.tablespace_name);
                index.setObjectId(ind.object_id);
                index.setCreatedAndModifiedTimestamps(ind.created_timestamp, ind.modified_timestamp);
                if (this.incremental) {
                    index.myColumns.clearState();
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void retrieveIndicesColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveIndicesColumns"));
            }
            if (!this.affectsTables) {
                return;
            }
            List ics = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveIndicesColumns).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneIndexColumn ic : ics) {
                String columnName;
                OraTable table = this.schema.tables().getOrCreate(ic.table_name);
                DbmIndex index = table.indices().getOrCreate(ic.index_name);
                if (ic.column_position == 1) {
                    index.clearColumnsList();
                }
                String string = columnName = ic.column_expression == null ? ic.column_name : OraIntrospector.unquoteNameIfPossible(ic.column_expression);
                if (ic.column_name != null) {
                    DasIndex.Sorting sorting = ic.descendant ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.ASCENDING;
                    index.addColumn(columnName, sorting);
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void retrieveKeys(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveKeys"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Keys");
            List keys = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveKeys).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneKey k : keys) {
                if (k.table_name == null || k.constraint_name == null) continue;
                OraTable table = this.schema.tables().getOrCreate(k.table_name);
                DbmKey key = table.keys().getOrCreate(k.constraint_name);
                key.myColumns.clearState();
                key.setNameSurrogate(k.is_surrogate_name);
                key.setPrimary(k.is_pk);
                key.setDeferrable(k.is_deferrable);
                key.setInitiallyDeferred(k.is_initially_deferred);
                key.setModifiedTimestamp(k.modified_timestamp);
                DbmIndex index = k.index_name != null ? table.indices().getOrCreate(k.index_name) : null;
                key.setUnderlyingIndex(index);
            }
        }

        private void retrieveForeignKeys(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveForeignKeys"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            List fks = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveForeignKeys).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneForeignKey fk : fks) {
                OraTable table = this.schema.tables().getOrCreate(fk.table_name);
                DbmForeignKey fkey = table.foreignKeys().getOrCreate(fk.constraint_name);
                fkey.myColumns.clearState();
                fkey.refKey.set(fk.ref_schema_name, fk.ref_key_name);
                fkey.setNameSurrogate(fk.is_surrogate_name);
                fkey.setDeferrable(fk.is_deferrable);
                fkey.setInitiallyDeferred(fk.is_initially_deferred);
                fkey.setCascadeDeleteRule(fk.cascade_delete ? CascadeRule.delete : CascadeRule.restrict);
                fkey.setModifiedTimestamp(fk.modified_timestamp);
            }
        }

        private void retrieveChecks(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveChecks"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            List cks = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveChecks).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneCheck ck : cks) {
                if (ck.predicate == null || ck.is_surrogate_name && AUTO_NOT_NULL_CHECK_PATTERN.matcher(ck.predicate).matches()) continue;
                OraTable table = this.schema.tables().getOrCreate(ck.table_name);
                DbmCheck check = table.checks().getOrCreate(ck.constraint_name);
                check.myColumns.clearState();
                check.setNameSurrogate(ck.is_surrogate_name);
                check.setPredicate(ck.predicate);
                check.setModifiedTimestamp(ck.modified_timestamp);
                this.myAffectedDepObjects.add((DbmObject)check.getTable());
            }
        }

        private void retrieveConstraintColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveConstraintColumns"));
            }
            if (!this.affectsTables) {
                return;
            }
            List ccs = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveConstraintColumns).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (ccs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                DbmConstraint constraint;
                DbmLikeTable table = this.schema.getTableOrView(cc.table_name);
                if (table == null || (constraint = table.getConstraint(cc.constraint_name)) == null) continue;
                if (cc.column_name != null) {
                    constraint.myColumns.add(cc.column_name);
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void reorderTableDetails() {
            for (DbmLikeTable table : this.myTablesToReorderDetails) {
                table.indices().reorder();
                table.keys().reorder();
                table.foreignKeys().reorder();
                table.checks().reorder();
            }
        }

        private void retrieveTriggers(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveTriggers"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Triggers");
            List trigs = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggers).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (trigs.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> tables = new HashSet<DbmLikeTable>(trigs.size());
            boolean also_retrieve_update_columns = false;
            for (Object trig : trigs) {
                DbmLikeTable table = this.schema.getTableOrView(((OraIntroQueries.OneTrigger)trig).table_name);
                if (table == null) continue;
                DbmTrigger trigger = table.triggers().getOrCreate(((OraIntroQueries.OneTrigger)trig).trigger_name);
                trigger.trigColumns.clearState();
                trigger.trigEvents.set(((OraIntroQueries.OneTrigger)trig).events);
                trigger.setTrigTurn(this.trigTurnOf(((OraIntroQueries.OneTrigger)trig).turn));
                also_retrieve_update_columns |= ((OraIntroQueries.OneTrigger)trig).has_on_update_columns;
                trigger.setCreatedAndModifiedTimestamps(((OraIntroQueries.OneTrigger)trig).created_timestamp, ((OraIntroQueries.OneTrigger)trig).modified_timestamp);
                tables.add(table);
            }
            if (also_retrieve_update_columns) {
                List cols = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggerUpdateColumns).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
                for (String[] col : cols) {
                    DbmTrigger trigger;
                    DbmLikeTable table;
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null || (table = this.schema.getTableOrView(tableName)) == null || (trigger = table.triggers().get(triggerName)) == null) continue;
                    trigger.trigColumns.add(columnName);
                }
            }
            for (DbmLikeTable table : tables) {
                table.triggers().reorder();
            }
            this.myAffectedDepObjects.addAll(tables);
            this.affectsTriggers = true;
        }

        @Nullable
        private TrigTurn trigTurnOf(short turn) {
            switch (turn) {
                case -2: {
                    return TrigTurn.BEFORE_STMT;
                }
                case -1: {
                    return TrigTurn.BEFORE_ROW;
                }
                case 1: {
                    return TrigTurn.AFTER_ROW;
                }
                case 2: {
                    return TrigTurn.AFTER_STMT;
                }
                case 0: {
                    return TrigTurn.INSTEAD_OF;
                }
            }
            return null;
        }

        private void retrievePackages(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrievePackages"));
            }
            this.reportRetrieving("Packages");
            List packs = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrievePackages).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (packs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OnePackage p : packs) {
                OraBody body;
                if (!p.is_body) {
                    OraPackage pack = this.schema.packages().renew(p.object_id, p.package_name);
                    pack.setObjectId(p.object_id);
                    pack.setInvalid(p.is_invalid);
                    pack.setCreatedAndModifiedTimestamps(p.created_timestamp, p.modified_timestamp);
                    this.myAffectedModules.add(pack);
                    this.myAffectedDepObjects.add(pack);
                    continue;
                }
                DbmObject objectWithThisId = ((OraModel)OraIntrospector.this.myModel).getObjectById(p.object_id);
                if (objectWithThisId != null && objectWithThisId instanceof OraBody) {
                    body = (OraBody)objectWithThisId;
                    body.setName(p.package_name);
                } else {
                    OraPackage pack = this.schema.packages().getOrCreate(p.package_name);
                    body = pack.getOrCreateBody();
                    body.setObjectId(p.object_id);
                    body.setName(p.package_name);
                }
                body.setInvalid(p.is_invalid);
                body.setCreatedAndModifiedTimestamps(p.created_timestamp, p.modified_timestamp);
                this.myAffectedDepObjects.add(body);
            }
            this.schema.packages().reorder();
            this.affectsModulesOrBodies = true;
        }

        private void retrieveInnerRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveInnerRoutines"));
            }
            if (this.myAffectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            for (OraModule module : this.myAffectedModules) {
                module.routines().markChildrenAsSyncPending();
            }
            SqlQuery<List<OraIntroQueries.OneInnerRoutine>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutines11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutines10;
            List routines = (List)tran.query(query).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneInnerRoutine r : routines) {
                OraModule module = null;
                if (r.module_kind == 'T' || r.module_kind == 'Z') {
                    module = this.schema.objectTypes().get(r.module_name);
                }
                if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                    module = this.schema.packages().get(r.module_name);
                }
                if (module == null) continue;
                DbmInnerRoutine routine = module.routines().getOrCreate(r.routine_name);
                if (routine.getRoutineKind() == DasRoutine.Kind.NONE) {
                    routine.setRoutineKind(DasRoutine.Kind.PROCEDURE);
                }
                routine.setDeterministic(r.is_deterministic);
            }
            for (OraModule module : this.myAffectedModules) {
                module.routines().removeSyncPendingChildren();
            }
        }

        private void retrieveInnerRoutinesArguments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveInnerRoutinesArguments"));
            }
            if (this.myAffectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneInnerRoutineArgument>> arguments11 = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutineArguments11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutineArguments10;
            List args = (List)tran.query(arguments11).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneInnerRoutineArgument a : args) {
                DbmInnerRoutine routine;
                OraModule m;
                if (a.package_name == null || a.routine_name == null || (m = this.schema.getModule(a.package_name)) == null || (routine = m.routines().get(a.routine_name)) == null) continue;
                OraIntrospector.makeArgument(routine, a.arg_name, a.arg_direction, a.data_type_schema_name, a.data_type);
            }
        }

        private void retrieveSingleRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveSingleRoutines"));
            }
            this.reportRetrieving("Procedures and functions");
            List routines = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutines).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (routines.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneSingleRoutine r : routines) {
                DbmSingleRoutine routine = this.schema.routines().getOrCreate(r.name);
                routine.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                routine.setObjectId(r.object_id);
                routine.setInvalid(r.is_invalid);
                routine.setDeterministic(r.is_deterministic);
                routine.setCreatedAndModifiedTimestamps(r.created_timestamp, r.modified_timestamp);
                this.myAffectedDepObjects.add(routine);
            }
            this.schema.routines().reorder();
            this.affectsSingleRoutines = true;
        }

        private void retrieveSingleRoutinesArguments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveSingleRoutinesArguments"));
            }
            if (!this.affectsSingleRoutines) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            SqlQuery<List<OraIntroQueries.OneSingleRoutineArgument>> query = OraIntrospector.this.myOracleVersion.isOrGreater(new int[]{11}) ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutineArguments11 : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutineArguments10;
            List args = (List)tran.query(query).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneSingleRoutineArgument a : args) {
                DbmSingleRoutine routine;
                if (a.routine_name == null || (routine = this.schema.routines().get(a.routine_name)) == null) continue;
                OraIntrospector.makeArgument(routine, a.arg_name, a.arg_direction, a.data_type_schema_name, a.data_type);
            }
        }

        private void retrieveSynonyms(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveSynonyms"));
            }
            this.reportRetrieving("Synonyms");
            List ss = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveSynonyms).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneSynonym s : ss) {
                DbmSynonym synonym = this.schema.synonyms().getOrCreate(s.synonym_name);
                synonym.setObjectId(s.object_id);
                synonym.setCreatedAndModifiedTimestamps(s.created_timestamp, s.modified_timestamp);
                String[] originPath = s.origin_db_link != null ? new String[]{s.origin_db_link, s.origin_schema_name, s.origin_object_name} : (s.origin_schema_name != null && !s.origin_schema_name.equals(this.schema.getName()) ? new String[]{s.origin_schema_name, s.origin_object_name} : new String[]{s.origin_object_name});
                synonym.origin.set(originPath);
            }
        }

        private void retrieveDependencies(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveDependencies"));
            }
            if (!((OraIntrospector)OraIntrospector.this).myOptions.withDependencies) {
                return;
            }
            if (this.myAffectedDepObjects.isEmpty()) {
                return;
            }
            this.reportRetrieving("Dependencies");
            long[][] ds = OraIntrospector.this.myUseFastWay ? (long[][])tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveDependenciesFast).withParams(new Object[]{this.schema.getObjectId(), this.fromTimestamp}).run() : (long[][])tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveDependenciesSlow).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            if (ds.length == 0) {
                return;
            }
            HashSet<DbmRef<DbmObject>> myNewRefs = new HashSet<DbmRef<DbmObject>>(ds.length);
            for (long[] d : ds) {
                assert (d.length == 2);
                long sourceId = d[0];
                long targetId = d[1];
                DbmObject sourceObject = ((OraModel)OraIntrospector.this.myModel).getObjectById(sourceId);
                DbmObject targetObject = ((OraModel)OraIntrospector.this.myModel).getObjectById(targetId);
                if (sourceObject == null || targetObject == null) continue;
                DbmRef<DbmObject> ref = sourceObject.internalDependencies().add(targetObject);
                if (!this.incremental) continue;
                myNewRefs.add(ref);
            }
            if (this.incremental) {
                Object object = this.myAffectedDepObjects.iterator();
                while (object.hasNext()) {
                    DbmObject object2 = (DbmObject)object.next();
                    for (DbmRef<DbmObject> ref : object2.internalDependencies().getAllRefs()) {
                        if (myNewRefs.contains(ref)) continue;
                        ref.drop();
                    }
                }
            }
        }

        private void retrieveViewSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveViewSources"));
            }
            if (!((OraIntrospector)OraIntrospector.this).myOptions.withSources) {
                return;
            }
            if (!this.affectsViews) {
                return;
            }
            this.reportRetrieving("View Sources");
            List views = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveViewSources).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            for (OraIntroQueries.OneViewSource v : views) {
                DbmView view = this.schema.views().getOrCreate(v.view_name);
                view.setSourceText(v.text);
            }
        }

        private void retrieveSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveSources"));
            }
            if (!((OraIntrospector)OraIntrospector.this).myOptions.withSources) {
                return;
            }
            if (!(this.affectsModulesOrBodies || this.affectsSingleRoutines || this.affectsTriggers)) {
                return;
            }
            this.reportRetrieving("Procedures and Functions Sources");
            List lines = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveSources).withParams(new Object[]{this.schema.getName(), this.fromTimestamp}).run();
            String theType = "";
            String theName = "";
            StringBuilder buf = new StringBuilder();
            for (OraIntroQueries.OneSrcLine line : lines) {
                boolean theSame;
                boolean bl = theSame = theType.equals(line.type) && theName.equals(line.name);
                if (!theSame) {
                    OraIntrospector.applySources(this.schema, theType, theName, buf.toString());
                    theType = line.type;
                    theName = line.name;
                    buf.delete(0, buf.length());
                }
                buf.append(line.text);
            }
            OraIntrospector.applySources(this.schema, theType, theName, buf.toString());
        }

        private void retrieveErrors(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "retrieveErrors"));
            }
            if (!(this.affectsViews || this.affectsModulesOrBodies || this.affectsSingleRoutines || this.affectsTriggers)) {
                return;
            }
            this.reportRetrieving("Statuses and Errors");
            List errs = (List)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.retrieveErrors).withParams(new Object[]{this.schema.getName()}).run();
            if (errs.isEmpty()) {
                return;
            }
            MultiMap map = new MultiMap();
            for (OraIntroQueries.OneError err : errs) {
                DbmSourceAware src = null;
                switch (err.type_code) {
                    case 'R': {
                        src = this.schema.routines().get(err.name);
                        break;
                    }
                    case 'V': {
                        src = this.schema.views().get(err.name);
                        break;
                    }
                    case 'T': {
                        OraModule m = this.schema.objectTypes().get(err.name);
                        if (m == null) break;
                        src = (DbmSourceAware)((Object)(err.is_body ? m.bodies().firstIfExists() : m));
                        break;
                    }
                    case 'P': {
                        OraModule p = this.schema.packages().get(err.name);
                        if (p == null) break;
                        src = (DbmSourceAware)((Object)(err.is_body ? p.bodies().firstIfExists() : p));
                    }
                }
                if (src == null) continue;
                DbmError error = DbmError.of(err.line, err.position, err.message);
                map.putValue((Object)src, (Object)error);
            }
            for (Map.Entry entry : map.entrySet()) {
                ((DbmSourceAware)entry.getKey()).setErrors((List<DbmError>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            }
        }

        private void reportRetrieving(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/oracle/OraIntrospector$SchemaRetriever", "reportRetrieving"));
            }
            String mode = this.incremental ? "incrementally" : "completely";
            OraIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", this.schema.getName(), mode), what);
        }
    }
}

