/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.google.common.base.Objects;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmComplexElement;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.postgres.PostgresDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresDataTypeAttribute
extends DbmComplexElement
implements DasTypedObject {
    @StateProperty
    public DataType myDataType;

    public PostgresDataTypeAttribute(@NotNull PostgresDataType dataType, @Nullable String name) {
        if (dataType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataType", "com/intellij/dbm/postgres/PostgresDataTypeAttribute", "<init>"));
        }
        super(dataType, name);
    }

    @Override
    @NotNull
    public ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.OBJECT_ATTRIBUTE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresDataTypeAttribute", "kind"));
        }
        return objectKind;
    }

    public void setDataType(DataType dataType) {
        if (Objects.equal((Object)this.myDataType, (Object)dataType)) {
            return;
        }
        this.modifying();
        this.myDataType = dataType;
    }

    @NotNull
    public DataType getDataType() {
        DataType dt = this.myDataType;
        DataType dataType = dt != null ? dt : DataType.UNKNOWN;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresDataTypeAttribute", "getDataType"));
        }
        return dataType;
    }

    @Nullable
    public DasUserDefinedType getCustomType() {
        if (this.myDataType == null) {
            return null;
        }
        if (this.myDataType.schemaName == null) {
            return null;
        }
        return this.parent().schema().resolveCustomType(this.myDataType);
    }

    public boolean isNotNull() {
        return false;
    }

    @Nullable
    public String getDefault() {
        return null;
    }
}

