/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DataType;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.SequenceIdentity;
import com.intellij.dbm.serialization.DbmMetaModel;
import com.intellij.dbm.serialization.DbmModelMem;
import com.intellij.dbm.serialization.DbmObjectMem;
import com.intellij.dbm.serialization.DbmSerializationUtil;
import com.intellij.dbm.serialization.DbmVersions;
import com.intellij.dbm.serialization.ExportException;
import com.intellij.dbm.serialization.NameAndValue;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbmExporter {
    public void writeModel(@NotNull DbmModel<?> model, @NotNull HierarchicalStreamWriter writer) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/serialization/DbmExporter", "writeModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/dbm/serialization/DbmExporter", "writeModel"));
        }
        this.writeForest(model, model.roots(), writer);
    }

    public void writeForest(@NotNull DbmModel<?> model, @NotNull Iterable<? extends DbmObject> roots, @NotNull HierarchicalStreamWriter writer) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/serialization/DbmExporter", "writeForest"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/dbm/serialization/DbmExporter", "writeForest"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/dbm/serialization/DbmExporter", "writeForest"));
        }
        DbmModelMem modelMem = DbmExporter.exportForest(model, roots);
        DbmExporter.serializeModel(modelMem, writer);
    }

    public static DbmModelMem exportForest(@NotNull DbmModel model, @NotNull Iterable<? extends DbmObject> roots) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/serialization/DbmExporter", "exportForest"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/dbm/serialization/DbmExporter", "exportForest"));
        }
        for (DbmObject dbmObject : roots) {
            if (dbmObject.model == model) continue;
            throw new IllegalArgumentException("All roots must belong to the same model");
        }
        LinkedHashMap<DbmObject, Integer> nodes = DbmExporter.orderNodes(roots);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (DbmObject node : nodes.keySet()) {
            DbmObjectMem om = DbmExporter.exportNode(node, nodes);
            builder.add((Object)om);
        }
        ImmutableBiMap.Builder mp = ImmutableBiMap.builder();
        return new DbmModelMem(model.getRdbms(), (List<DbmObjectMem>)builder.build(), (Map<String, String>)mp.build());
    }

    private static LinkedHashMap<DbmObject, Integer> orderNodes(Iterable<? extends DbmObject> roots) {
        int counter = 0;
        final LinkedList queue = ContainerUtil.newLinkedList(roots);
        LinkedHashMap nodes = ContainerUtil.newLinkedHashMap();
        while (!queue.isEmpty()) {
            DbmObject node = (DbmObject)queue.poll();
            if (nodes.containsKey(node)) continue;
            Integer id = ++counter;
            nodes.put(node, id);
            node.traverseChildren(DbmObject.class, new Consumer<DbmObject>(){

                public void consume(DbmObject object) {
                    queue.add(object);
                }
            });
        }
        return nodes;
    }

    private static DbmObjectMem exportNode(@NotNull DbmObject node, @NotNull Map<DbmObject, Integer> nodes) throws ExportException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dbm/serialization/DbmExporter", "exportNode"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dbm/serialization/DbmExporter", "exportNode"));
        }
        Integer id = nodes.get(node);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        Integer parentId = node.parent() != null ? nodes.get(node.parent()) : null;
        ImmutableList<NameAndValue<String>> properties = DbmExporter.exportNodeProperties(node);
        return new DbmObjectMem(id, node.kind().code(), (List<NameAndValue<String>>)properties, parentId, node.getNameOrNull());
    }

    @NotNull
    static ImmutableList<NameAndValue<String>> exportNodeProperties(@NotNull DbmObject node) throws ExportException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dbm/serialization/DbmExporter", "exportNodeProperties"));
        }
        DbmMetaModel.ObjectMetaInfo mi = DbmMetaModel.obtainMetaInfo(node.getClass());
        ImmutableList.Builder b = ImmutableList.builder();
        for (DbmMetaModel.PropertyMetaInfo pi : mi.getProperties()) {
            NameAndValue<String> propertyNameAndValue = DbmExporter.peekProperty(node, pi);
            if (propertyNameAndValue == null) continue;
            b.add(propertyNameAndValue);
        }
        ImmutableList immutableList = b.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/serialization/DbmExporter", "exportNodeProperties"));
        }
        return immutableList;
    }

    @Nullable
    private static NameAndValue<String> peekProperty(DbmObject object, DbmMetaModel.PropertyMetaInfo pi) throws ExportException {
        try {
            String value = pi.isHolder ? DbmExporter.peekHoldedValue(object, pi) : DbmExporter.peekPlainValue(object, pi);
            return value != null ? NameAndValue.of(pi.name, value) : null;
        }
        catch (Exception e) {
            String message = String.format("Exception when attempt to get value of property %s from node class %s (node id: %s, description: %s). Exception class: %s, message: %s", pi.name, object.getClass().getSimpleName(), object.identity(true), object.description(true), e.getClass().getSimpleName(), e.getMessage());
            throw new ExportException(message, e);
        }
    }

    @Nullable
    private static String peekHoldedValue(DbmObject object, DbmMetaModel.PropertyMetaInfo pi) throws ExportException {
        try {
            Object holderObject = pi.propertyField.get(object);
            assert (holderObject instanceof PropertyHolder) : "The final property must implement PropertyHolder";
            PropertyHolder holder = (PropertyHolder)holderObject;
            return holder.exportState();
        }
        catch (Exception e) {
            throw new ExportException("A strange exception when accessing holded property " + pi.propertyField.getName() + ": " + e.getMessage(), e);
        }
    }

    @Nullable
    private static String peekPlainValue(DbmObject node, DbmMetaModel.PropertyMetaInfo pi) throws ExportException {
        try {
            boolean primitive = pi.propertyField.getType().isPrimitive();
            Object value = pi.propertyField.get(node);
            return DbmExporter.convertValueToText(value, primitive);
        }
        catch (Exception e) {
            throw new ExportException("A strange exception when accessing plain property " + pi.propertyField.getName() + ": " + e.getMessage(), e);
        }
    }

    @Nullable
    static String convertValueToText(@Nullable Object value, boolean primitive) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : (primitive ? null : "0");
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            String numberStr = number.toString();
            return numberStr.equals("0") ? null : numberStr;
        }
        if (value instanceof Date) {
            return DbmSerializationUtil.formatTimestamp((Date)value);
        }
        if (value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        if (value instanceof DataType) {
            return ((DataType)value).getSpecification();
        }
        if (value instanceof SequenceIdentity) {
            return ((SequenceIdentity)value).getSpecification();
        }
        String string = value.toString();
        string = DbmSerializationUtil.normalize(string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeModel(@NotNull DbmModelMem mem, @NotNull HierarchicalStreamWriter writer) {
        if (mem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mem", "com/intellij/dbm/serialization/DbmExporter", "serializeModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/dbm/serialization/DbmExporter", "serializeModel"));
        }
        writer.startNode("database-model");
        try {
            writer.addAttribute("serializer", "dbm");
            writer.addAttribute("rdbms", mem.rdbms.code);
            writer.addAttribute("format-version", DbmVersions.CURRENT_VERSION.toString());
            for (Map.Entry<String, String> property : mem.properties.entrySet()) {
                writer.addAttribute(property.getKey(), property.getValue());
            }
            for (DbmObjectMem object : mem.nodes) {
                DbmExporter.serializeNode(object, writer);
            }
        }
        finally {
            writer.endNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeNode(DbmObjectMem node, HierarchicalStreamWriter writer) {
        writer.startNode(node.kind);
        try {
            writer.addAttribute("id", node.id.toString());
            if (node.parentId != null) {
                writer.addAttribute("parent", node.parentId.toString());
            }
            if (node.name != null) {
                writer.addAttribute("name", node.name);
            }
            for (NameAndValue<String> property : node.properties) {
                if (property.name.equalsIgnoreCase("name")) continue;
                DbmExporter.serializeProperty(property, writer);
            }
        }
        finally {
            writer.endNode();
        }
    }

    private static void serializeProperty(NameAndValue<String> property, HierarchicalStreamWriter writer) {
        writer.startNode(property.name);
        try {
            writer.setValue((String)property.value);
        }
        finally {
            writer.endNode();
        }
    }
}

