/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.serialization;

import com.intellij.dbm.serialization.NameAndValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DbmObjectMem {
    @NotNull
    final Integer id;
    @NotNull
    final String kind;
    @NotNull
    final List<NameAndValue<String>> properties;
    @Nullable
    final Integer parentId;
    @Nullable
    final String name;

    DbmObjectMem(@NotNull Integer id, @NotNull String kind, @NotNull List<NameAndValue<String>> properties, @Nullable Integer parentId, @Nullable String name) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/dbm/serialization/DbmObjectMem", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/serialization/DbmObjectMem", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/dbm/serialization/DbmObjectMem", "<init>"));
        }
        this.id = id;
        this.kind = kind;
        this.properties = properties;
        this.parentId = parentId;
        this.name = name;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.kind);
        b.append('(').append(this.id);
        if (this.name != null) {
            b.append(':').append(this.name);
        }
        b.append(')');
        if (this.parentId == null) {
            b.append(" is root");
        } else {
            b.append(" in ").append(this.parentId);
        }
        b.append('\n');
        for (NameAndValue<String> property : this.properties) {
            b.append(property).append('\n');
        }
        return b.toString();
    }
}

