/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.sybase;

import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.sybase.SybaseSchema;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SybaseDatabase
extends DbmDatabase {
    private final ConcurrentMap<Long, DbmObject> myObjectsById;
    @StateProperty
    @Nullable
    public String myCollation;
    private transient boolean myNamingCaseSensitive;

    public SybaseDatabase(@NotNull DbmModel model, @Nullable String name) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/sybase/SybaseDatabase", "<init>"));
        }
        super(model, name);
        this.myObjectsById = new ConcurrentHashMap<Long, DbmObject>();
    }

    @NotNull
    public Family<SybaseSchema> schemas() {
        Family family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseDatabase", "schemas"));
        }
        return family;
    }

    void justObjectIdChanged(DbmObject object, long oldId, long newId) {
        if (oldId != 0L) {
            this.myObjectsById.remove(oldId, object);
        }
        if (newId != 0L) {
            this.myObjectsById.put(newId, object);
        }
    }

    @Nullable
    public DbmObject getObjectById(int id) {
        Long theId = id;
        return (DbmObject)this.myObjectsById.get(theId);
    }

    @Nullable
    public DbmObject getObjectById(long id) {
        return (DbmObject)this.myObjectsById.get(id);
    }

    @Nullable
    public <T> T getObjectById(@NotNull Class<T> objectClass, long id) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/sybase/SybaseDatabase", "getObjectById"));
        }
        DbmObject object = this.getObjectById(id);
        if (object == null) {
            return null;
        }
        return (T)(objectClass.isAssignableFrom(object.getClass()) ? object : null);
    }

    @NotNull
    Set<Long> allObjectIds() {
        Set<Long> set = this.myObjectsById.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/sybase/SybaseDatabase", "allObjectIds"));
        }
        return set;
    }

    public boolean isNamingCaseSensitive() {
        return this.myNamingCaseSensitive;
    }

    public void setNamingCaseSensitive(boolean caseSensitive) {
        if (this.myNamingCaseSensitive == caseSensitive) {
            return;
        }
        this.modifying();
        this.myNamingCaseSensitive = caseSensitive;
    }

    @Nullable
    public String getCollation() {
        return this.myCollation;
    }

    public void setCollation(@Nullable String collation) {
        if (StringUtil.equalsIgnoreCase((CharSequence)this.myCollation, (CharSequence)collation)) {
            return;
        }
        this.modifying();
        this.myCollation = collation;
    }
}

