/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFileType;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFrameworkSupportProvider
extends FrameworkSupportProvider {
    @NonNls
    private static final String ID = "sql:dialects";

    public SqlFrameworkSupportProvider() {
        super(ID, SqlMessages.message("sql.framework.support.provider.title", new Object[0]));
    }

    public Icon getIcon() {
        return DatabaseIcons.Sql;
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/SqlFrameworkSupportProvider", "createConfigurable"));
        }
        SqlSupportConfigurable sqlSupportConfigurable = new SqlSupportConfigurable(model.getProject());
        if (sqlSupportConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFrameworkSupportProvider", "createConfigurable"));
        }
        return sqlSupportConfigurable;
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "com/intellij/sql/SqlFrameworkSupportProvider", "isEnabledForModuleType"));
        }
        return true;
    }

    private static class SqlSupportConfigurable
    extends FrameworkSupportConfigurable {
        private JComboBox myComboBox;
        private JPanel myMainPanel;
        private final Project myProject;

        public SqlSupportConfigurable(Project project) {
            String defaultTitle;
            this.myProject = project;
            Object[] objectArray = new Object[]{};
            this.$$$setupUI$$$();
            String defaultPrefix = SqlMessages.message("sql.framework.support.provider.project.default", objectArray);
            if (this.myProject != null) {
                SqlLanguageDialect projectLang = SqlDialectMappings.getInstance(this.myProject).getMapping(null);
                defaultTitle = defaultPrefix + " (" + projectLang.getDisplayName() + ")";
            } else {
                defaultTitle = defaultPrefix;
            }
            this.myComboBox.setEditable(false);
            ArrayList<SqlLanguageDialect> dialects = new ArrayList<SqlLanguageDialect>(SqlDialectMappings.getAvailableDialects());
            Collections.sort(dialects, LanguageUtil.LANGUAGE_COMPARATOR);
            dialects.add(0, null);
            this.myComboBox.setModel(new CollectionComboBoxModel(dialects, null));
            this.myComboBox.setRenderer(new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    if (value instanceof SqlLanguageDialect) {
                        this.setIcon(SqlFileType.INSTANCE.getIcon());
                        this.setText(((SqlLanguageDialect)value).getDisplayName());
                    } else {
                        this.setText(defaultTitle);
                    }
                }
            });
        }

        public JComponent getComponent() {
            return this.myMainPanel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model, @Nullable Library library) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/sql/SqlFrameworkSupportProvider$SqlSupportConfigurable", "addSupport"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/SqlFrameworkSupportProvider$SqlSupportConfigurable", "addSupport"));
            }
            Object o = this.myComboBox.getSelectedItem();
            if (!(o instanceof SqlLanguageDialect)) {
                return;
            }
            SqlLanguageDialect dialect = (SqlLanguageDialect)o;
            SqlDialectMappings mappings = SqlDialectMappings.getInstance(module.getProject());
            for (VirtualFile root : model.getContentRoots()) {
                mappings.setMapping(root, dialect);
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JComboBox jComboBox;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/SqlBundle").getString("label.text.default.dialect"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myComboBox = jComboBox = new JComboBox();
            jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

