/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.database.model.DasColumn;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlVariableDefinition;

public class SqlReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(PsiElement element) {
        return element instanceof SqlDefinition;
    }

    public boolean isDeclarationWriteAccess(PsiElement element) {
        return element instanceof SqlVariableDefinition && ((SqlVariableDefinition)element).getInitializer() != null;
    }

    public ReadWriteAccessDetector.Access getReferenceAccess(PsiElement referencedElement, PsiReference reference) {
        if (!(referencedElement instanceof DasColumn) && !(referencedElement instanceof SqlAsExpression)) {
            return ReadWriteAccessDetector.Access.Read;
        }
        return this.getExpressionAccess(reference.getElement());
    }

    public ReadWriteAccessDetector.Access getExpressionAccess(PsiElement expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof SqlBinaryExpression) {
            SqlBinaryExpression binaryExpression = (SqlBinaryExpression)parent;
            return binaryExpression.getOpSign() == SqlTokens.SQL_OP_ASSIGN && binaryExpression.getLOperand() == expression ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        }
        SqlTableColumnsList tableColumnList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlTableColumnsList.class);
        if (tableColumnList != null) {
            return tableColumnList.getParent() instanceof SqlDmlInstruction && tableColumnList.getParent().getParent() instanceof SqlInsertStatement ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
        }
        SqlSetClause setClause = (SqlSetClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSetClause.class);
        if (setClause != null) {
            PsiElement first = parent instanceof SqlReferenceList ? parent : expression;
            for (PsiElement child = first.getNextSibling(); child != null; child = child.getNextSibling()) {
                IElementType elementType = child.getNode().getElementType();
                if (elementType == SqlTokens.SQL_COMMA) {
                    return ReadWriteAccessDetector.Access.Read;
                }
                if (elementType != SqlTokens.SQL_OP_EQ) continue;
                return ReadWriteAccessDetector.Access.Write;
            }
        }
        return ReadWriteAccessDetector.Access.Read;
    }
}

