/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlValuesParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<SqlExpressionList, List<Pair<String, String>>, SqlExpression> {
    private static final Set<? extends Class> ourStopSearch = ContainerUtil.newHashSet((Object[])new Class[]{SqlStatement.class});
    private static final Set<Class> ourAllowedParents = ContainerUtil.newHashSet((Object[])new Class[]{SqlParenthesizedExpression.class, SqlValuesExpression.class});

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    @Nullable
    public Object[] getParametersForDocumentation(List<Pair<String, String>> p, ParameterInfoContext context) {
        return new Object[]{p};
    }

    public SqlExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlValuesParameterInfoHandler", "findElementForParameterInfo"));
        }
        SqlExpressionList result = SqlValuesParameterInfoHandler.findExpressions((ParameterInfoContext)context);
        if (result != null) {
            SqlDmlInstruction instruction = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)result, SqlDmlInstruction.class, (boolean)true);
            ArrayList lists = ContainerUtil.newArrayList();
            if (instruction != null) {
                SqlTableType targetType = instruction.getTargetType();
                lists.add(new ArrayList());
                for (int i = 0; i < targetType.getColumnCount(); ++i) {
                    String columnType = null;
                    boolean skip = false;
                    if (StringUtil.isNotEmpty((String)targetType.getColumnType(i).getDisplayName())) {
                        PsiElement resolve;
                        PsiElement columnElement = targetType.getColumnElement(i);
                        PsiElement psiElement = resolve = columnElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)columnElement).resolve() : null;
                        if (resolve instanceof DasColumn) {
                            columnType = ((DasColumn)resolve).getDataType().getSpecification();
                        } else if (columnElement instanceof DasColumn) {
                            columnType = ((DasColumn)columnElement).getDataType().getSpecification();
                            skip = DasUtil.isAutoVal((DasColumn)((DasColumn)columnElement));
                        } else {
                            columnType = targetType.getColumnType(i).getDisplayName();
                        }
                    }
                    if (skip) {
                        lists.add(ContainerUtil.newArrayList((Iterable)((Iterable)lists.get(lists.size() - 1))));
                    }
                    Pair pair = Pair.create((Object)targetType.getColumnName(i), columnType);
                    for (int j = 0; j < lists.size(); ++j) {
                        if (j == lists.size() - 1 && skip) continue;
                        ((List)lists.get(j)).add(pair);
                    }
                }
            } else {
                SqlCreateStatement createStatement = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)result, SqlCreateStatement.class, (boolean)true);
                if (createStatement instanceof DasTable) {
                    ArrayList pairs = ContainerUtil.newArrayList();
                    for (DasColumn column : DasUtil.getColumns((DasObject)((DasTable)createStatement))) {
                        String type = column.getDataType().getSpecification();
                        pairs.add(Pair.create((Object)column.getName(), (Object)(StringUtil.isNotEmpty((String)type) ? type : null)));
                    }
                    lists.add(pairs);
                }
            }
            context.setItemsToShow((Object[])lists.toArray(new List[lists.size()]));
        }
        return result;
    }

    public void showParameterInfo(@NotNull SqlExpressionList expression, @NotNull CreateParameterInfoContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/SqlValuesParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlValuesParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)expression, expression.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public SqlExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlValuesParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return SqlValuesParameterInfoHandler.findExpressions((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull SqlExpressionList element, @NotNull UpdateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlValuesParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlValuesParameterInfoHandler", "updateParameterInfo"));
        }
        int index = SqlValuesParameterInfoHandler.getCurrentParameterIndex(element, context.getOffset());
        context.setCurrentParameter(index);
    }

    public static int getCurrentParameterIndex(@NotNull SqlExpressionList element, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlValuesParameterInfoHandler", "getCurrentParameterIndex"));
        }
        ASTNode node = element.getNode();
        SyntaxTraverser s = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)node).expandAndSkip(Conditions.is((Object)node))).forceDisregard(Conditions.compose((Function)SyntaxTraverser.astApi().TO_TYPE(), (Condition)Conditions.is((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        return ParameterInfoUtils.getCurrentParameterIndex((SyntaxTraverser)s, (int)offset, (IElementType)SqlTokens.SQL_COMMA);
    }

    public String getParameterCloseChars() {
        return ",);";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(List<Pair<String, String>> p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/SqlValuesParameterInfoHandler", "updateUI"));
        }
        PsiElement element = context.getParameterOwner();
        if (!element.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        int index = context.getCurrentParameterIndex();
        int highlightStart = -1;
        int highlightEnd = -1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < p.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (i == index) {
                highlightStart = sb.length();
            }
            Pair<String, String> pair = p.get(i);
            sb.append((String)pair.first);
            if (StringUtil.isNotEmpty((String)((String)pair.second))) {
                sb.append(":").append((String)pair.second);
            }
            if (i != index) continue;
            highlightEnd = sb.length();
        }
        if (sb.length() == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        context.setupUIComponentPresentation(sb.toString(), highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @NotNull
    public SqlExpression[] getActualParameters(@NotNull SqlExpressionList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/SqlValuesParameterInfoHandler", "getActualParameters"));
        }
        List list = o.getExpressionList();
        SqlExpression[] sqlExpressionArray = list.toArray(new SqlExpression[list.size()]);
        if (sqlExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlValuesParameterInfoHandler", "getActualParameters"));
        }
        return sqlExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_COMMA;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlValuesParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        SqlTokenType sqlTokenType = SqlTokens.SQL_RIGHT_PAREN;
        if (sqlTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlValuesParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return sqlTokenType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourAllowedParents;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlValuesParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlValuesParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public Class<SqlExpressionList> getArgumentListClass() {
        if (SqlExpressionList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlValuesParameterInfoHandler", "getArgumentListClass"));
        }
        return SqlExpressionList.class;
    }

    @Nullable
    private static SqlExpressionList findExpressions(ParameterInfoContext context) {
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return null;
        }
        int offset = context.getOffset();
        PsiElement at = file.findElementAt(offset);
        return SqlValuesParameterInfoHandler.findExpressions(at);
    }

    @Nullable
    public static SqlExpressionList findExpressions(@Nullable PsiElement at) {
        if (at == null || !at.isValid()) {
            return null;
        }
        if (!(at.getContainingFile() instanceof SqlFile)) {
            return null;
        }
        SqlValuesExpression valuesExpression = (SqlValuesExpression)PsiTreeUtil.getParentOfType((PsiElement)at, SqlValuesExpression.class);
        if (valuesExpression == null) {
            return null;
        }
        for (SqlExpression expression : valuesExpression.getExpressions()) {
            if (!expression.getTextRange().contains(at.getTextRange().getStartOffset())) continue;
            return expression instanceof SqlParenthesizedExpression ? (SqlParenthesizedExpression)expression : null;
        }
        return null;
    }
}

