/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.fragments.SqlCodeFragment;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionContributor
extends CompletionContributor {
    public static final int ALIAS_PRIORITY = 100;
    public static final int FK_TABLE_PRIORITY = 90;
    public static final int FUN_PRIORITY = 0;
    public static final int AS_ALIAS_PRIORITY = 10;
    public static final int KW_PRIORITY = 5;
    public static final int SIMILARITY_FACTOR = 10;
    private static final TokenSet FOR_FUNCTION_COMPLETION = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE, SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE, SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE, SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE, SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE, SqlCompositeElementTypes.SQL_REFERENCE});

    public SqlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor$1", "addCompletions"));
                }
                PsiFile file = parameters.getOriginalFile();
                if (!(file instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                if (position instanceof SqlStringTokenElement || position instanceof PsiComment) {
                    return;
                }
                PsiElement prevSibling = position.getParent().getPrevSibling();
                if (prevSibling instanceof ASTNode && ((ASTNode)prevSibling).getElementType() == SqlTokens.SQL_PERIOD) {
                    return;
                }
                SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
                SqlCompletionContributor.suggestTableColumnListAtOnce(position, dialect, result);
                SqlAsExpression aliasDefinition = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlAsExpression.class);
                if (aliasDefinition != null && PsiTreeUtil.isAncestor((PsiElement)aliasDefinition.getNameElement(), (PsiElement)position, (boolean)false)) {
                    for (String name : SqlCompletionContributor.suggestAliasName(aliasDefinition.getExpression())) {
                        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(name, false, true, (InsertHandler<LookupElement>)AddSpaceInsertHandler.INSTANCE, new String[0]), (double)10.0));
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                boolean noFunctions;
                IElementType fragmentType;
                PsiReference ref;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor$2", "addCompletions"));
                }
                PsiFile file = parameters.getOriginalFile();
                if (!(file instanceof SqlFile)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
                PsiReference psiReference = ref = expression == null ? null : expression.getReference();
                if (!(ref instanceof SqlReferenceImpl)) {
                    return;
                }
                if (((SqlReferenceImpl)ref).getQualifier() != null) {
                    return;
                }
                IElementType iElementType = fragmentType = file instanceof SqlCodeFragment ? ((SqlCodeFragment)file).getElementType() : null;
                if (fragmentType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                    return;
                }
                boolean bl = noFunctions = fragmentType == SqlCompositeElementTypes.SQL_TYPE_ELEMENT;
                if (noFunctions) {
                    return;
                }
                SqlReferenceElementType type = ((SqlReferenceImpl)ref).getReferenceElementType();
                if (FOR_FUNCTION_COMPLETION.contains((IElementType)type)) {
                    SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
                    for (String s : dialect.getSupportedFunctions().keySet()) {
                        SqlFunctionDefinition def = dialect.getSupportedFunctions().get(s);
                        for (SqlFunctionDefinition.Prototype prototype : def.getPrototypes()) {
                            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)0.0));
                        }
                    }
                }
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor$3", "addCompletions"));
                }
                SqlCompletionContributor.suggestJoinStuff(parameters, result);
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(final @NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
                SqlReferenceExpression topReference;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor$4", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor$4", "addCompletions"));
                }
                if (SqlCompletionContributor.suggestJoinStuff(parameters, result)) {
                    return;
                }
                PsiElement position = parameters.getPosition();
                PsiFile file = parameters.getOriginalFile();
                final SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
                SqlReferenceExpression reference = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlReferenceExpression.class);
                SqlReferenceExpression sqlReferenceExpression = topReference = reference == null ? null : (SqlReferenceExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)position, SqlReferenceExpression.class);
                if (topReference == null || topReference.getQualifierExpression() != null || !(topReference.getParent() instanceof SqlBinaryExpression)) {
                    return;
                }
                SqlBinaryExpression binary = (SqlBinaryExpression)topReference.getParent();
                Object leftOperand = binary.getLOperand() == topReference ? binary.getROperand() : (binary.getROperand() == topReference ? binary.getLOperand() : null);
                if (leftOperand == null) {
                    return;
                }
                final boolean isEq = binary.getOpSign() == SqlTokens.SQL_OP_EQ || binary.getOpSign() == SqlTokens.SQL_OP_EQEQ;
                final SqlExpression qualifier = reference.getQualifierExpression();
                final SqlType expectedType = leftOperand.getSqlType();
                PsiElement leftResolved = leftOperand instanceof SqlReferenceExpression ? ((SqlReferenceExpression)leftOperand).resolve() : null;
                final DasColumn leftColumn = leftResolved instanceof DasColumn ? (DasColumn)leftResolved : null;
                final ArrayList asExpressions = ContainerUtil.newArrayList();
                ((SqlReferenceImpl)reference.getReference()).processCompletionVariants(new Consumer<LookupElement>(){

                    public void consume(LookupElement lookupElement) {
                        Object object = lookupElement.getObject();
                        if (object instanceof SqlAsExpression) {
                            asExpressions.add((SqlAsExpression)object);
                            return;
                        }
                        if (!(object instanceof DasColumn)) {
                            return;
                        }
                        DasColumn columnInfo = (DasColumn)object;
                        DataType dataType = columnInfo.getDataType();
                        SqlPrimitiveType byJdbc = SqlType.findByJdbcType((int)dataType.jdbcType);
                        SqlType byName = dialect.getSqlType(dataType.getSpecification());
                        if (!(expectedType.equals(byJdbc) || byJdbc != byName && expectedType.equals(byName))) {
                            return;
                        }
                        DasTable table = columnInfo.getTable();
                        if (table == null) {
                            return;
                        }
                        if (parameters.getInvocationCount() <= 1 && isEq && (leftColumn == null || !SqlCompletionContributor.areColumnsConnected(leftColumn, columnInfo))) {
                            return;
                        }
                        LookupElement element = qualifier == null ? SqlCompletionContributor.prefix(lookupElement, SqlCompletionContributor.calcQualifier(table, asExpressions, dialect) + ".") : lookupElement;
                        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)element, (double)90.0));
                    }
                });
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)StandardPatterns.instanceOf(SqlFile.class)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement parent;
                SqlQueryExpression query;
                PsiReference ref;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor$5", "addCompletions"));
                }
                PsiElement position = parameters.getPosition();
                SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
                PsiReference psiReference = ref = expression == null ? null : expression.getReference();
                if (!(ref instanceof SqlReferenceImpl)) {
                    return;
                }
                SqlReferenceElementType refType = ((SqlReferenceImpl)ref).getReferenceElementType();
                DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression).getDatabaseDialect();
                THashSet columnsNamesFromSelect = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                final Ref fromType = Ref.create();
                if (refType == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                    SqlTableExpression tableExpression;
                    SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlSelectClause.class);
                    query = (SqlQueryExpression)ObjectUtils.tryCast((Object)(selectClause == null ? null : selectClause.getParent()), SqlQueryExpression.class);
                    SqlTableExpression sqlTableExpression = tableExpression = query == null ? null : query.getTableExpression();
                    if (tableExpression != null) {
                        fromType.set((Object)tableExpression.getSqlType());
                    }
                }
                if (refType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE && ((parent = expression.getParent()) instanceof SqlFromClause || parent instanceof SqlJoinExpression)) {
                    SqlSelectClause select;
                    query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlQueryExpression.class);
                    SqlSelectClause sqlSelectClause = select = query != null ? query.getSelectClause() : null;
                    if (select != null) {
                        select.accept(new SqlVisitor((Set)columnsNamesFromSelect, dialect){
                            final /* synthetic */ Set val$columnsNamesFromSelect;
                            final /* synthetic */ DatabaseDialectEx val$dialect;
                            {
                                this.val$columnsNamesFromSelect = set;
                                this.val$dialect = databaseDialectEx;
                            }

                            public void visitSqlReferenceExpression(SqlReferenceExpression e) {
                                if (e.getQualifierExpression() == null && e.getReferenceElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
                                    this.val$columnsNamesFromSelect.add(this.val$dialect.quoteIdentifier(e.getName(), true, false));
                                }
                            }

                            public void visitSqlElement(SqlElement e) {
                                for (PsiElement element : e.getChildren()) {
                                    if (!(element instanceof SqlElement)) continue;
                                    ((SqlElement)element).accept((SqlVisitor)this);
                                }
                            }
                        });
                    }
                }
                final PsiElement originalPosition = parameters.getOriginalPosition();
                CompletionResultSet resultSet = result.caseInsensitive();
                ((SqlReferenceImpl)ref).processCompletionVariants(new Consumer<LookupElement>((Set)columnsNamesFromSelect, dialect, resultSet){
                    final /* synthetic */ Set val$columnsNamesFromSelect;
                    final /* synthetic */ DatabaseDialectEx val$dialect;
                    final /* synthetic */ CompletionResultSet val$resultSet;
                    {
                        this.val$columnsNamesFromSelect = set;
                        this.val$dialect = databaseDialectEx;
                        this.val$resultSet = completionResultSet;
                    }

                    public void consume(LookupElement element) {
                        Object o;
                        SqlNameElement ne;
                        if (originalPosition != null && element.getObject() instanceof SqlDefinition && (ne = ((SqlDefinition)element.getObject()).getNameElement()) != null && PsiTreeUtil.isAncestor((PsiElement)ne, (PsiElement)originalPosition, (boolean)false)) {
                            return;
                        }
                        int similarity = 0;
                        if (fromType.get() != null) {
                            int i;
                            if (element.getObject() instanceof DasColumn) {
                                for (i = 0; i < ((SqlTableType)fromType.get()).getColumnCount(); ++i) {
                                    if (!((SqlTableType)fromType.get()).getColumnElement(i).equals(element.getObject())) continue;
                                    similarity += 2;
                                    break;
                                }
                            } else if (element.getObject() instanceof DasTable) {
                                for (i = 0; i < ((SqlTableType)fromType.get()).getColumnCount(); ++i) {
                                    if (!Comparing.equal((Object)((SqlTableType)fromType.get()).getColumnQualifier(i), (Object)element.getObject())) continue;
                                    ++similarity;
                                    break;
                                }
                            }
                        }
                        if (!this.val$columnsNamesFromSelect.isEmpty() && (o = element.getObject()) instanceof DasTable) {
                            for (DasColumn c : DasUtil.getColumns((DasObject)((DasTable)o))) {
                                if (!this.val$columnsNamesFromSelect.contains(this.val$dialect.quoteIdentifier(c.getName(), true, false))) continue;
                                ++similarity;
                            }
                        }
                        this.val$resultSet.addElement(similarity > 0 ? PrioritizedLookupElement.withPriority((LookupElement)element, (double)(similarity * 10)) : element);
                    }
                });
            }
        });
    }

    private static boolean suggestJoinStuff(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinStuff"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinStuff"));
        }
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof SqlFile)) {
            return true;
        }
        PsiElement position = parameters.getPosition();
        PsiElement parent = position.getParent();
        if (parent.getNextSibling() != null) {
            return true;
        }
        PsiElement grandPa = parent.getParent();
        if (grandPa instanceof SqlReferenceExpression && ((SqlReferenceExpression)grandPa).getQualifierExpression() != null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        SqlCompletionContributor.suggestJoinTables(parent, dialect, result);
        SqlCompletionContributor.suggestJoinConditions(parent, dialect, result);
        return false;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        String prevElementText;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/completion/SqlCompletionContributor", "beforeCompletion"));
        }
        if (context.getCompletionType() == CompletionType.SMART) {
            return;
        }
        PsiFile file = context.getFile();
        if (!(file instanceof SqlFile)) {
            return;
        }
        int offset = context.getStartOffset();
        PsiElement element = file.findElementAt(offset);
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDatabaseDialect();
        PsiElement prevElement = offset > 0 ? file.findElementAt(offset - 1) : null;
        IElementType prevLeafType = prevElement instanceof LeafPsiElement ? ((LeafPsiElement)prevElement).getElementType() : null;
        PsiElement psiElement = prevElement = prevElement instanceof PsiWhiteSpace || prevLeafType == SqlTokens.SQL_IDENT ? PsiTreeUtil.prevLeaf((PsiElement)prevElement) : prevElement;
        if (prevLeafType == SqlTokens.SQL_UNCLOSED_TOKEN || prevElement != null && (prevElementText = prevElement.getText()) != null && String.valueOf(dialect.openQuote()).equals(prevElementText)) {
            char currentQuote = prevElement.getText().charAt(0);
            char closingQuote = currentQuote == dialect.openQuote() ? dialect.closeQuote() : currentQuote;
            context.setDummyIdentifier(String.valueOf(closingQuote));
        } else if (element != null) {
            ASTNode node = element.getNode();
            IElementType type = node != null ? node.getElementType() : null;
            boolean doNotPatch = type instanceof SqlKeywordTokenType && ((SqlFile)file).getSqlLanguage().isReservedKeyword(type);
            doNotPatch = doNotPatch || (element.getTextRange().getStartOffset() != offset || element.getParent() instanceof SqlIdentifier) && file.findReferenceAt(offset) != null;
            SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlPrefixedElement.class, (boolean)false);
            if (doNotPatch || prefixed != null && prefixed.getNamePrefix() != null) {
                context.setDummyIdentifier("");
            }
            SqlCompletionContributor.tuneReplacementOffset(context, element);
        }
    }

    private static void tuneReplacementOffset(@NotNull CompletionInitializationContext context, @NotNull PsiElement element) {
        IElementType type;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/sql/completion/SqlCompletionContributor", "tuneReplacementOffset"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/SqlCompletionContributor", "tuneReplacementOffset"));
        }
        ASTNode node = element.getNode();
        int offset = context.getStartOffset();
        IElementType iElementType = type = node != null ? node.getElementType() : null;
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset == element.getTextRange().getStartOffset()) {
            context.setReplacementOffset(element.getTextRange().getEndOffset());
        }
        if (type == SqlTokens.SQL_IDENT_DELIMITED && offset == element.getTextRange().getEndOffset() - 1) {
            context.getOffsetMap().addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, element.getTextRange().getEndOffset());
            context.setReplacementOffset(element.getTextRange().getEndOffset());
        }
    }

    private static LookupElementDecorator<LookupElement> prefix(LookupElement lookupElement, final String prefix) {
        return LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)prefix);
            }
        });
    }

    @NotNull
    private static String calcQualifier(@NotNull DasTable table, @NotNull List<SqlAsExpression> asExpressions, @NotNull SqlLanguageDialect dialect) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/completion/SqlCompletionContributor", "calcQualifier"));
        }
        if (asExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asExpressions", "com/intellij/sql/completion/SqlCompletionContributor", "calcQualifier"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlCompletionContributor", "calcQualifier"));
        }
        for (SqlAsExpression asExpression : asExpressions) {
            SqlExpression expression = asExpression.getExpression();
            DasTable element = SqlCompletionContributor.retrieveTable((PsiElement)expression);
            if (element == null || !SqlCompletionContributor.areTablesEqual(table, element)) continue;
            String name = asExpression.getName();
            if (name == null) break;
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "calcQualifier"));
            }
            return string;
        }
        DatabaseDialect databaseDialect = dialect.getDatabaseDialect();
        String string = databaseDialect.quoteIdentifier(table.getName(), false, SqlImplUtil.hasPlainIdentifier(table, databaseDialect));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "calcQualifier"));
        }
        return string;
    }

    public static boolean areTablesEqual(@NotNull DasTable t1, @NotNull DasTable t2) {
        if (t1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t1", "com/intellij/sql/completion/SqlCompletionContributor", "areTablesEqual"));
        }
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t2", "com/intellij/sql/completion/SqlCompletionContributor", "areTablesEqual"));
        }
        return Comparing.equal((String)t1.getName(), (String)t2.getName(), (boolean)false) && Comparing.equal((String)DasUtil.getSchema((DasObject)t1), (String)DasUtil.getSchema((DasObject)t2), (boolean)false) && Comparing.equal((String)DasUtil.getCatalog((DasObject)t1), (String)DasUtil.getCatalog((DasObject)t2), (boolean)false);
    }

    public static boolean areColumnsConnected(@NotNull DasColumn c1, @NotNull DasColumn c2) {
        String n2;
        String n1;
        DasTable t2;
        if (c1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "com/intellij/sql/completion/SqlCompletionContributor", "areColumnsConnected"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "com/intellij/sql/completion/SqlCompletionContributor", "areColumnsConnected"));
        }
        DasTable t1 = c1.getTable();
        return SqlCompletionContributor.isInFk(t1, t2 = c2.getTable(), n1 = c1.getName(), n2 = c2.getName()) || SqlCompletionContributor.isInFk(t2, t1, n2, n1);
    }

    private static boolean isInFk(@Nullable DasTable t1, @Nullable DasTable t2, @Nullable String n1, @Nullable String n2) {
        if (t1 == null || t2 == null) {
            return false;
        }
        for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)t1)) {
            if (!Comparing.equal((String)fk.getRefTableName(), (String)t2.getName(), (boolean)false)) continue;
            Iterator it1 = fk.getColumnsRef().names().iterator();
            Iterator it2 = fk.getRefColumns().names().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (!Comparing.equal((String)n2, (String)((String)it2.next()), (boolean)false) || !Comparing.equal((String)n1, (String)((String)it1.next()), (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Collection<String> suggestAliasName(@NotNull SqlExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/sql/completion/SqlCompletionContributor", "suggestAliasName"));
        }
        THashSet result = new THashSet();
        LinkedList<Object> stack = new LinkedList<Object>();
        UniqueNameGenerator generator = new UniqueNameGenerator(SqlCompletionContributor.collectExistingNames(expression), FunctionUtil.id());
        StringBuilder sb = new StringBuilder();
        stack.push(expression);
        while (!stack.isEmpty()) {
            SqlExpression fromExpression;
            SqlFromClause fromClause;
            SqlExpression expr = (SqlExpression)stack.pop();
            if (expr instanceof SqlReferenceExpression) {
                String text;
                SqlIdentifier identifier = ((SqlReferenceExpression)expr).getIdentifier();
                String string = text = identifier != null ? identifier.getName() : expr.getText();
                if (!"*".equals(text)) {
                    if (sb.length() > 0) {
                        sb.append("_");
                    }
                    sb.append(text);
                }
            }
            if (expr instanceof SqlAsExpression) {
                if (sb.length() > 0) {
                    sb.append("_");
                }
                sb.append(expr.getName());
                continue;
            }
            if (expr instanceof SqlParenthesizedExpression) {
                SqlExpression item = (SqlExpression)ContainerUtil.getFirstItem((List)((SqlParenthesizedExpression)expr).getExpressionList());
                if (item == null) continue;
                stack.push(item);
                continue;
            }
            if (expr instanceof SqlBinaryExpression) {
                SqlExpression l = ((SqlBinaryExpression)expr).getLOperand();
                SqlExpression r = ((SqlBinaryExpression)expr).getROperand();
                if (r != null) {
                    stack.push(r);
                }
                stack.push(l);
                continue;
            }
            if (!(expr instanceof SqlQueryExpression)) continue;
            SqlQueryExpression query = (SqlQueryExpression)expr;
            SqlSelectClause selectClause = query.getSelectClause();
            SqlTableExpression tableExpression = query.getTableExpression();
            SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
            if (selectClause != null) {
                List expressions = selectClause.getExpressions();
                ListIterator it = expressions.listIterator(expressions.size());
                while (it.hasPrevious()) {
                    stack.push(it.previous());
                }
            }
            if ((fromExpression = fromClause != null ? fromClause.getFromExpression() : null) == null) continue;
            stack.push(fromExpression);
        }
        SqlCompletionContributor.appendSuggestions((Set<String>)result, sb.toString(), generator);
        final SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)expression);
        List nonKeywords = ContainerUtil.filter((Collection)result, (Condition)new Condition<String>(){

            public boolean value(String s) {
                return !dialect.getKeywords().contains(s);
            }
        });
        final Case idCase = SqlCompletionContributor.getDefaultCase(SqlCompletionUtil.getIdentifierCase(expression.getProject()));
        final Case qidCase = SqlCompletionContributor.getDefaultCase(SqlCompletionUtil.getQuotedIdentifierCase(expression.getProject()));
        SqlCodeStyleSettings settings = SqlCompletionUtil.settings(expression.getProject());
        final boolean force = settings != null && settings.QUOTE_IDENTIFIER == 0;
        boolean suppress = true;
        List list = ContainerUtil.map((Collection)nonKeywords, (Function)new Function<String, String>(){

            public String fun(String s) {
                return SqlCompletionContributor.quoteIdentifierIfNeeded(s, dialect.getDatabaseDialect(), idCase, qidCase, force, true);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "suggestAliasName"));
        }
        return list;
    }

    @NotNull
    private static Case getDefaultCase(@NotNull Case c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/sql/completion/SqlCompletionContributor", "getDefaultCase"));
        }
        Case case_ = c == Case.EXACT ? Case.LOWER : c;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "getDefaultCase"));
        }
        return case_;
    }

    @NotNull
    private static String quoteIdentifierIfNeeded(@NotNull String id, @NotNull DatabaseDialect dialect, @NotNull Case idCase, @NotNull Case qidCase, boolean force, boolean suppress) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/completion/SqlCompletionContributor", "quoteIdentifierIfNeeded"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlCompletionContributor", "quoteIdentifierIfNeeded"));
        }
        if (idCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idCase", "com/intellij/sql/completion/SqlCompletionContributor", "quoteIdentifierIfNeeded"));
        }
        if (qidCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qidCase", "com/intellij/sql/completion/SqlCompletionContributor", "quoteIdentifierIfNeeded"));
        }
        if (!dialect.isQuotedIdentifier(id)) {
            id = dialect.quoteIdentifier(id, force, suppress);
        }
        Case curCase = dialect.isQuotedIdentifier(id) ? qidCase : idCase;
        String string = curCase.apply(id);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "quoteIdentifierIfNeeded"));
        }
        return string;
    }

    @NotNull
    private static Collection<String> collectExistingNames(@Nullable SqlExpression expression) {
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, SqlStatement.class);
        if (statement == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "collectExistingNames"));
            }
            return list;
        }
        final THashSet strings = new THashSet();
        statement.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiNamedElement) {
                    ContainerUtil.addIfNotNull((Collection)strings, (Object)((PsiNamedElement)element).getName());
                    super.visitElement(element);
                } else if (element instanceof SqlNameElement) {
                    ContainerUtil.addIfNotNull((Collection)strings, (Object)((SqlNameElement)element).getName());
                } else {
                    super.visitElement(element);
                }
            }
        });
        THashSet tHashSet = strings;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionContributor", "collectExistingNames"));
        }
        return tHashSet;
    }

    private static void appendSuggestions(Set<String> result, String text, UniqueNameGenerator generator) {
        String[] words = NameUtil.splitNameIntoWords((String)text);
        if (words.length > 0) {
            result.add(generator.generateUniqueName(words[0].substring(0, 1)));
            if (words.length > 1) {
                String abbreviation = "";
                String lastWord = null;
                for (String word : words) {
                    int i;
                    for (i = 1; i < word.length() && !Character.isLetter(word.charAt(i - 1)) && word.charAt(i - 1) != '.'; ++i) {
                    }
                    abbreviation = abbreviation + word.substring(0, i);
                    if (!Character.isLetter(word.charAt(0))) continue;
                    lastWord = word;
                }
                result.add(generator.generateUniqueName(abbreviation));
                if (lastWord != null && lastWord != words[0]) {
                    result.add(generator.generateUniqueName(lastWord.substring(0, 1)));
                    result.add(generator.generateUniqueName((String)ObjectUtils.chooseNotNull((Object)StringUtil.unpluralize((String)lastWord), (Object)lastWord)));
                }
            }
        }
    }

    private static void suggestTableColumnListAtOnce(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx dialect, @NotNull CompletionResultSet result) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/sql/completion/SqlCompletionContributor", "suggestTableColumnListAtOnce"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlCompletionContributor", "suggestTableColumnListAtOnce"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "suggestTableColumnListAtOnce"));
        }
        SqlTableColumnsList columnsList = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)position, SqlTableColumnsList.class);
        if (columnsList == null) {
            return;
        }
        SqlReferenceExpression tableReference = columnsList.getTableReference();
        DasTable resolve = SqlCompletionContributor.retrieveTable((PsiElement)tableReference);
        if (resolve == null) {
            return;
        }
        List<SqlReferenceExpression> colRefs = SqlImplUtil.getReferenceList(columnsList);
        if (colRefs.size() > 1) {
            return;
        }
        JBIterable columns = DasUtil.getColumns((DasObject)resolve);
        SqlCompletionContributor.processColumns(dialect.getDatabaseDialect(), (Iterable<? extends DasColumn>)columns.filter((Condition)new Condition<DasColumn>(){

            public boolean value(DasColumn info) {
                return !DasUtil.isAutoVal((DasColumn)info);
            }
        }), result);
    }

    private static void processColumns(@NotNull DatabaseDialectEx dialect, @NotNull Iterable<? extends DasColumn> columns, @NotNull CompletionResultSet result) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlCompletionContributor", "processColumns"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/completion/SqlCompletionContributor", "processColumns"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "processColumns"));
        }
        if (Iterables.size(columns) <= 1) {
            return;
        }
        LookupElement all = SqlCompletionContributor.createAllColumnsLookupElement(columns, dialect);
        if (all != null) {
            result.addElement(all);
        }
    }

    @Nullable
    private static LookupElement createAllColumnsLookupElement(@NotNull Iterable<? extends DasColumn> columns, @NotNull DatabaseDialectEx dialect) {
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/sql/completion/SqlCompletionContributor", "createAllColumnsLookupElement"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/completion/SqlCompletionContributor", "createAllColumnsLookupElement"));
        }
        DdlBuilder classic = new DdlBuilder().withDialect(dialect);
        boolean first = true;
        for (DasColumn dasColumn : columns) {
            if (first) {
                first = false;
            } else {
                classic.symbol(",").space();
            }
            classic.suppressQuoteIdentifiers(SqlImplUtil.hasPlainIdentifier(dasColumn, dialect));
            classic.columnRef(dasColumn.getName());
        }
        String statement = classic.getStatement();
        if (statement.isEmpty()) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)statement).withIcon(DatabaseIcons.Col).withInsertHandler((InsertHandler)new BasicInsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                if (context.getCompletionChar() != ')') {
                    Editor editor = context.getEditor();
                    Document document = editor.getDocument();
                    context.commitDocument();
                    int offset = context.getTailOffset();
                    PsiElement at = context.getFile().findElementAt(offset > 1 ? offset - 1 : offset);
                    SqlTableColumnsList tcl = (SqlTableColumnsList)PsiTreeUtil.getParentOfType((PsiElement)at, SqlTableColumnsList.class);
                    SqlValuesExpression values = (SqlValuesExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)tcl, SqlValuesExpression.class);
                    if (values != null) {
                        return;
                    }
                    SqlReferenceList list = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)at, SqlReferenceList.class);
                    if (list != null) {
                        ASTNode right = list.getNode().findChildByType((IElementType)SqlTokens.SQL_RIGHT_PAREN);
                        String what = right == null ? ") " : " ";
                        int where = right == null ? offset : right.getStartOffset() + 1;
                        document.insertString(where, (CharSequence)what);
                        editor.getCaretModel().moveToOffset(where + what.length());
                        AutoPopupController.getInstance((Project)at.getProject()).autoPopupMemberLookup(editor, null);
                    }
                }
            }
        }), (double)100.0);
    }

    private static void suggestJoinTables(@NotNull PsiElement position, final @NotNull SqlLanguageDialectEx sqlDialect, final @NotNull CompletionResultSet resultSet) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinTables"));
        }
        if (sqlDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlDialect", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinTables"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinTables"));
        }
        SqlJoinExpression join = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class);
        if (join == null) {
            return;
        }
        PsiElement parent = position.getParent();
        if (parent == null) {
            return;
        }
        ASTNode joinNode = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent.getNode());
        if (joinNode == null || joinNode.getElementType() != SqlCommonKeywords.SQL_JOIN && joinNode.getElementType() != SqlTokens.SQL_COMMA) {
            return;
        }
        if (parent instanceof SqlReferenceExpression) {
            PsiReference reference = parent.getReference();
            if (!(reference instanceof SqlReferenceImpl)) {
                return;
            }
            final HashSet fromLeft = ContainerUtil.newHashSet();
            SqlJoinExpression topmost = (SqlJoinExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)join, SqlJoinExpression.class);
            topmost = topmost == null ? join : topmost;
            topmost.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    ContainerUtil.addAllNotNull((Collection)fromLeft, (Object[])new DasTable[]{SqlCompletionContributor.retrieveTable(element)});
                    super.visitElement(element);
                }
            });
            final HashSet fks = ContainerUtil.newHashSet();
            for (DasTable tableLongInfo : fromLeft) {
                Iterables.addAll((Collection)fks, (Iterable)DasUtil.getForeignKeys((DasTable)tableLongInfo));
            }
            ((SqlReferenceImpl)reference).processResolveVariants(new SqlScopeProcessor(false, sqlDialect, SqlImplUtil.getDataSources(parent)){

                @Override
                public boolean isResultEmpty() {
                    return false;
                }

                @Override
                public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/completion/SqlCompletionContributor$13", "executeTarget"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/completion/SqlCompletionContributor$13", "executeTarget"));
                    }
                    if (element instanceof DasTable) {
                        this.addLookupElement((DasTable)element, element);
                    }
                    return true;
                }

                private void addLookupElement(@Nullable DasTable table, Object toAdd) {
                    if (table == null) {
                        return;
                    }
                    int priority = Comparing.equal((Object)table, (Object)toAdd) ? 90 : 100;
                    for (final DasForeignKey fk : fks) {
                        if (!SqlCompletionContributor.cheapEquals(table, fk) || !table.equals(fk.getRefTable())) continue;
                        SqlCompletionUtil.addLookupElement(sqlDialect, toAdd, (Consumer<LookupElement>)resultSet, false, priority);
                        return;
                    }
                    for (final DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                        DasTable info = (DasTable)ContainerUtil.find((Iterable)fromLeft, (Condition)new Condition<DasTable>(){

                            public boolean value(DasTable info) {
                                return SqlCompletionContributor.cheapEquals(info, fk);
                            }
                        });
                        if (info == null || !fromLeft.contains(fk.getRefTable())) continue;
                        SqlCompletionUtil.addLookupElement(sqlDialect, toAdd, (Consumer<LookupElement>)resultSet, false, priority);
                        return;
                    }
                }
            });
        }
    }

    public static boolean cheapEquals(@NotNull DasTable table, @NotNull DasForeignKey fk) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/sql/completion/SqlCompletionContributor", "cheapEquals"));
        }
        if (fk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fk", "com/intellij/sql/completion/SqlCompletionContributor", "cheapEquals"));
        }
        return !(!Comparing.strEqual((String)table.getName(), (String)fk.getRefTableName(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getSchema((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableSchema()) && !Comparing.strEqual((String)DasUtil.getSchema((DasObject)table), (String)fk.getRefTableSchema(), (boolean)false) || !StringUtil.isEmpty((String)DasUtil.getCatalog((DasObject)table)) && !StringUtil.isEmpty((String)fk.getRefTableCatalog()) && !Comparing.strEqual((String)DasUtil.getCatalog((DasObject)table), (String)fk.getRefTableCatalog(), (boolean)false));
    }

    private static void suggestJoinConditions(@NotNull PsiElement position, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinConditions"));
        }
        if (sqlDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlDialect", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinConditions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "suggestJoinConditions"));
        }
        PsiElement parent = position.getParent();
        if (parent == null) {
            return;
        }
        ASTNode sibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)parent.getNode());
        if (sibling == null || sibling.getElementType() != SqlCommonKeywords.SQL_ON) {
            return;
        }
        SqlJoinExpression join = (SqlJoinExpression)PsiTreeUtil.getParentOfType((PsiElement)position, SqlJoinExpression.class);
        LinkedHashSet left = ContainerUtil.newLinkedHashSet();
        LinkedHashSet right = ContainerUtil.newLinkedHashSet();
        if (join != null) {
            SqlCompletionContributor.collectTables((SqlExpression)join, join, left, right);
        }
        Project project = position.getProject();
        SqlCompletionContributor.processTables(project, left, right, sqlDialect, result, join == null ? null : join.getLOperand());
    }

    private static void collectTables(@Nullable SqlExpression o, @NotNull SqlJoinExpression place, @NotNull Collection<Trinity<DasTable, String, SqlExpression>> l, @NotNull Collection<Trinity<DasTable, String, SqlExpression>> r) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/completion/SqlCompletionContributor", "collectTables"));
        }
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/sql/completion/SqlCompletionContributor", "collectTables"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/sql/completion/SqlCompletionContributor", "collectTables"));
        }
        if (o instanceof SqlJoinExpression) {
            SqlExpression left = ((SqlJoinExpression)o).getLOperand();
            SqlExpression right = ((SqlJoinExpression)o).getROperand();
            if (o == place) {
                SqlCompletionContributor.collectTables(right, place, l, l);
                SqlCompletionContributor.collectTables(left, place, r, r);
            } else {
                SqlCompletionContributor.collectTables(left, place, l, l);
                SqlCompletionContributor.collectTables(right, place, r, r);
            }
            return;
        }
        Trinity<DasTable, String, SqlExpression> trinity = o instanceof SqlAsExpression ? SqlCompletionContributor.retrieveTable(((SqlAsExpression)o).getExpression(), o.getName()) : SqlCompletionContributor.retrieveTable(o, null);
        ContainerUtil.addAllNotNull(l, (Object[])new Trinity[]{trinity});
        ContainerUtil.addAllNotNull(r, (Object[])new Trinity[]{trinity});
    }

    @Nullable
    private static Trinity<DasTable, String, SqlExpression> retrieveTable(@Nullable SqlExpression place, @Nullable String alias) {
        DasTable table = SqlCompletionContributor.retrieveTable((PsiElement)place);
        return table == null ? null : Trinity.create((Object)table, (Object)alias, (Object)place);
    }

    @Nullable
    private static DasTable retrieveTable(@Nullable PsiElement e) {
        ObjectKind kind;
        if (e instanceof SqlReferenceExpression && (kind = ((SqlReferenceExpression)e).getReferenceElementType().getTargetKind()) == ObjectKind.TABLE) {
            for (ResolveResult result : ((SqlReferenceExpression)e).multiResolve(true)) {
                if (!result.isValidResult() || !(result.getElement() instanceof DasTable)) continue;
                return (DasTable)result.getElement();
            }
        }
        return null;
    }

    private static void processTables(@NotNull Project project, @NotNull Collection<Trinity<DasTable, String, SqlExpression>> left, @NotNull Collection<Trinity<DasTable, String, SqlExpression>> right, @NotNull SqlLanguageDialectEx sqlDialect, @NotNull CompletionResultSet result, @Nullable SqlExpression lOperand) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/completion/SqlCompletionContributor", "processTables"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/sql/completion/SqlCompletionContributor", "processTables"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/sql/completion/SqlCompletionContributor", "processTables"));
        }
        if (sqlDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlDialect", "com/intellij/sql/completion/SqlCompletionContributor", "processTables"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "processTables"));
        }
        for (Trinity<DasTable, String, SqlExpression> l : left) {
            for (Trinity<DasTable, String, SqlExpression> r : right) {
                SqlCompletionContributor.processForeignKeys(project, sqlDialect, l, r, result, lOperand);
                SqlCompletionContributor.processForeignKeys(project, sqlDialect, r, l, result, lOperand);
            }
        }
    }

    private static void processForeignKeys(@NotNull Project project, @NotNull SqlLanguageDialectEx sqlDialect, final @NotNull Trinity<DasTable, String, SqlExpression> left, final @NotNull Trinity<DasTable, String, SqlExpression> right, @NotNull CompletionResultSet result, @Nullable SqlExpression lOperand) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/completion/SqlCompletionContributor", "processForeignKeys"));
        }
        if (sqlDialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlDialect", "com/intellij/sql/completion/SqlCompletionContributor", "processForeignKeys"));
        }
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/sql/completion/SqlCompletionContributor", "processForeignKeys"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/sql/completion/SqlCompletionContributor", "processForeignKeys"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "processForeignKeys"));
        }
        final DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
        boolean ancestor = PsiTreeUtil.isContextAncestor((PsiElement)lOperand, (PsiElement)((PsiElement)right.third), (boolean)false);
        for (final DasForeignKey key : DasUtil.getForeignKeys((DasTable)((DasTable)right.first))) {
            if (!((DasTable)left.first).equals(key.getRefTable())) continue;
            MultiRef cols = key.getColumnsRef();
            MultiRef refCols = key.getRefColumns();
            if (cols.size() != refCols.size()) continue;
            final DdlBuilder builder = new DdlBuilder().withDialect(dialect).applyCodeStyle(project);
            boolean first = true;
            Iterator refIt = refCols.names().iterator();
            for (final String name : cols.names()) {
                if (first) {
                    first = false;
                } else {
                    builder.space().keyword("and").space();
                }
                final String refName = (String)refIt.next();
                Runnable leftPart = new Runnable(){

                    @Override
                    public void run() {
                        builder.suppressQuoteIdentifiers(SqlImplUtil.hasPlainIdentifier(key.getTable(), dialect)).identifier(right.second == null ? key.getTableName() : (String)right.second).symbol(".").identifier(name);
                    }
                };
                Runnable rightPart = new Runnable(){

                    @Override
                    public void run() {
                        builder.suppressQuoteIdentifiers(SqlImplUtil.hasPlainIdentifier(key.getRefTable(), dialect)).identifier(left.second == null ? key.getRefTableName() : (String)left.second).symbol(".").identifier(refName);
                    }
                };
                (ancestor ? leftPart : rightPart).run();
                builder.space().symbol("=").space();
                (ancestor ? rightPart : leftPart).run();
            }
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)builder.getStatement()).withIcon(DatabaseIcons.ColBlueKey), (double)90.0));
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        DatabaseDialectEx dialect;
        char quote;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/sql/completion/SqlCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/completion/SqlCompletionContributor", "fillCompletionVariants"));
        }
        SqlPrefixedElement prefixed = (SqlPrefixedElement)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), SqlPrefixedElement.class, (boolean)false);
        String prefix = StringUtil.notNullize((String)(prefixed == null ? null : prefixed.getNamePrefix()));
        String searchPrefix = result.getPrefixMatcher().getPrefix();
        if (searchPrefix.length() > prefix.length() && ((quote = searchPrefix.charAt(prefix.length())) == (dialect = SqlImplUtil.getSqlDialectSafe(parameters.getPosition()).getDatabaseDialect()).openQuote() || quote == '\"')) {
            result = result.withPrefixMatcher(prefix + result.getPrefixMatcher().getPrefix().substring(prefix.length() + 1));
        }
        super.fillCompletionVariants(parameters, result);
    }
}

