/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IntInlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SqlTypesStatisticIndex
extends FileBasedIndexExtension<String, Integer> {
    public static final int VERSION = 0;
    public static final EnumeratorStringDescriptor DESCRIPTOR = new EnumeratorStringDescriptor();
    private final DataExternalizer<Integer> myExternalizer = new IntInlineKeyDescriptor();
    public static final ID<String, Integer> NAME = ID.create((String)"sql.types.count.index");
    public static final DataIndexer<String, Integer, FileContent> INDEXER = new DataIndexer<String, Integer, FileContent>(){

        @NotNull
        public Map<String, Integer> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/sql/completion/SqlTypesStatisticIndex$1", "map"));
            }
            PsiFile file = inputData.getPsiFile();
            if (!(file instanceof SqlFile)) {
                Map<String, Integer> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex$1", "map"));
                }
                return map;
            }
            SqlLanguageDialect language = ((SqlFile)file).getSqlLanguage();
            final String id = language.getID();
            final HashMap<String, Integer> map = new HashMap<String, Integer>();
            file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(PsiElement element) {
                    PsiElement child;
                    if (element instanceof SqlTypeElement && (child = element.getFirstChild()) != null) {
                        String name;
                        Integer current = (Integer)map.get(name = id + "::" + child.getText());
                        map.put(name, current != null ? current + 1 : 0);
                    }
                    super.visitElement(element);
                }
            });
            HashMap<String, Integer> hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex$1", "map"));
            }
            return hashMap;
        }
    };

    @NotNull
    public ID<String, Integer> getName() {
        ID<String, Integer> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Integer, FileContent> getIndexer() {
        DataIndexer<String, Integer, FileContent> dataIndexer = INDEXER;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = DESCRIPTOR;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Integer> getValueExternalizer() {
        DataExternalizer<Integer> dataExternalizer = this.myExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{SqlFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlTypesStatisticIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }
}

