/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.DataSourceManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

@com.intellij.openapi.components.State(name="SqlDataSourceStorage", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/sqlDataSources.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class SqlDataSourceStorage
implements PersistentStateComponent<State> {
    private final Project myProject;
    private final List<SqlDataSourceImpl> myDataSources = ContainerUtil.createLockFreeCopyOnWriteList();

    public static SqlDataSourceStorage getInstance(Project project) {
        return (SqlDataSourceStorage)ServiceManager.getService((Project)project, SqlDataSourceStorage.class);
    }

    public SqlDataSourceStorage(Project project, DataSourceManager dataSourceManager) {
        this.myProject = project;
    }

    public State getState() {
        State state = new State();
        for (SqlDataSourceImpl dataSource : this.myDataSources) {
            state.dataSources.add(dataSource.getState());
        }
        return state;
    }

    public void loadState(State state) {
        this.myDataSources.clear();
        for (SqlDataSourceImpl.State dataSourceState : state.dataSources) {
            SqlDataSourceImpl dataSource = new SqlDataSourceImpl(null, this.myProject, null);
            dataSource.loadState(dataSourceState);
            this.addDataSource(dataSource);
        }
    }

    public List<SqlDataSource> getDataSources() {
        return new ArrayList<SqlDataSource>(this.myDataSources);
    }

    public void removeDataSource(SqlDataSourceImpl dataSource) {
        this.myDataSources.remove((Object)dataSource);
        dataSource.dropFilePointers();
    }

    public void addDataSource(SqlDataSourceImpl dataSource) {
        dataSource.init();
        dataSource.initFilePointers();
        this.myDataSources.add(dataSource);
    }

    public static class State {
        public List<SqlDataSourceImpl.State> dataSources = new ArrayList<SqlDataSourceImpl.State>();
    }
}

