/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.NameChecker;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDialectImplUtil {
    public static Logger LOG = Logger.getInstance((String)"com.intellij.sql.dialects.DialectSupport");
    public static final PairConsumer<RawConnectionConfig, PairConsumer<String, ObjectKind>> USER_NAME_SCHEMA_PROVIDER = new PairConsumer<RawConnectionConfig, PairConsumer<String, ObjectKind>>(){

        public void consume(RawConnectionConfig info, PairConsumer<String, ObjectKind> consumer) {
            Pair<String, String> credentials = DatabaseCredentials.getInstance().getCredentialsNoUI((DatabaseSystem)info);
            if (StringUtil.isNotEmpty((String)((String)credentials.first))) {
                consumer.consume(credentials.first, (Object)ObjectKind.SCHEMA);
            }
        }
    };

    private SqlDialectImplUtil() {
    }

    @NotNull
    public static String getDialectHelpResource(Class dialectClass, @NonNls String name) throws IOException {
        String text;
        String resourceName = null;
        InputStream zipIs = null;
        for (Class c = dialectClass; c != null; c = c.getSuperclass()) {
            String specificResourceName = "help/" + SqlDialectImplUtil.getSqlDialectName(c) + "-help.zip";
            zipIs = c.getClassLoader().getResourceAsStream(specificResourceName);
            String string = resourceName = zipIs != null || resourceName == null ? specificResourceName : resourceName;
            if (zipIs != null) break;
        }
        if (zipIs == null) {
            throw new IOException(SqlMessages.message("help.file.0.not.found", resourceName));
        }
        try {
            text = SqlDialectImplUtil.loadFileFromZip(zipIs, name);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new IOException(SqlMessages.message("help.file.0.not.found", name) + "\n" + e.getMessage(), e);
        }
        if (text == null) {
            throw new IOException(SqlMessages.message("help.file.0.not.found", resourceName + "!/" + name));
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getDialectHelpResource"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String loadFileFromZip(InputStream stream, @NonNls String fileName) throws IOException {
        if (stream == null) {
            return null;
        }
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(stream);
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.getName().equalsIgnoreCase(fileName)) {
                    String string = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(zip)));
                    return string;
                }
                zipEntry = zip.getNextEntry();
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
        return null;
    }

    public static Set<String> getAllKeywordsFromDefinition(Collection<SqlFunctionDefinition> definitions, Set<String> keywords) {
        for (SqlFunctionDefinition definition : definitions) {
            for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
                SqlDialectImplUtil.getAllKeywordsFromDefinition(prototype, keywords);
            }
        }
        return keywords;
    }

    public static void getAllKeywordsFromDefinition(SqlFunctionDefinition.ParameterBlock block, Set<String> keywords) {
        for (SqlFunctionDefinition.Parameter parameter : block.getParams()) {
            if (parameter instanceof SqlFunctionDefinition.Keyword) {
                keywords.add(((SqlFunctionDefinition.Keyword)parameter).getName());
                continue;
            }
            if (!(parameter instanceof SqlFunctionDefinition.ParameterBlock)) continue;
            SqlDialectImplUtil.getAllKeywordsFromDefinition((SqlFunctionDefinition.ParameterBlock)parameter, keywords);
        }
    }

    @NotNull
    private static String getSqlDialectName(@NotNull Class<?> dialectClass) {
        if (dialectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectClass", "com/intellij/sql/dialects/SqlDialectImplUtil", "getSqlDialectName"));
        }
        String className = dialectClass.getName();
        int endIndex = className.indexOf("Dialect");
        String string = className.substring(className.lastIndexOf(46) + 1, endIndex > -1 ? endIndex : className.length()).toLowerCase(Locale.ENGLISH);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "getSqlDialectName"));
        }
        return string;
    }

    @NotNull
    public static Map<String, DasObject> buildEntities(@NotNull ObjectKind kind, String ... names) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/dialects/SqlDialectImplUtil", "buildEntities"));
        }
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (String name : names) {
            result.put(name, new ReservedEntity(name, kind));
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "buildEntities"));
        }
        return linkedHashMap;
    }

    public static boolean checkFileImports(SqlFile sqlFile, DasObject object, @Nullable PsiElement place) {
        SqlLanguageDialectEx dialect = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        SqlFile casing = object instanceof DbElement ? ((DbElement)object).getDataSource().getModel() : sqlFile;
        ImportInfo info = SqlDialectImplUtil.getNearestImportInfo(place, SqlDialectImplUtil.buildImports(sqlFile), object.getKind());
        while (info != null) {
            NameChecker nameChecker = new NameChecker(info.name, info.casing, true, dialect, (CasingProvider)casing);
            if (nameChecker.checkName(object, null)) {
                return true;
            }
            info = info.next;
        }
        return false;
    }

    @Nullable
    public static ImportInfo getNearestImportInfo(PsiElement place, List<ImportInfo> infos, ObjectKind type) {
        PsiElement p;
        if (infos.isEmpty()) {
            return null;
        }
        for (p = place; p != null; p = p.getContext()) {
            if (p instanceof DummyHolder) continue;
            if (p instanceof StubBasedPsiElement && ((StubBasedPsiElement)p).getStub() != null || p instanceof PsiFileWithStubSupport && ((PsiFileWithStubSupport)p).getStubTree() != null) break;
            if (!(p instanceof PsiFile)) continue;
            p = null;
            break;
        }
        if (p == null) {
            p = place;
        }
        for (ImportInfo info : ContainerUtil.reverse(infos)) {
            if (info.kind != type || !SqlDialectImplUtil.placeBefore(info.element, p)) continue;
            return info;
        }
        return null;
    }

    public static boolean placeBefore(PsiElement p1, PsiElement p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        if (p1 instanceof StubBasedPsiElement && p2 instanceof StubBasedPsiElement) {
            StubElement s1 = ((StubBasedPsiElement)p1).getStub();
            StubElement s2 = ((StubBasedPsiElement)p2).getStub();
            if (s1 != null && s2 != null) {
                StubElement e;
                ArrayList<StubElement> parents1 = new ArrayList<StubElement>();
                for (e = s1; e != null; e = e.getParentStub()) {
                    parents1.add(e);
                }
                StubElement prevE = null;
                for (e = s2; e != null; e = e.getParentStub()) {
                    if (e == s1) {
                        return true;
                    }
                    int idx = parents1.indexOf(e);
                    if (idx != -1) {
                        if (idx == 0 || prevE == null) {
                            return true;
                        }
                        StubElement prev1 = (StubElement)parents1.get(idx - 1);
                        for (StubElement element : e.getChildrenStubs()) {
                            if (element == prev1) {
                                return true;
                            }
                            if (element != prevE) continue;
                            return false;
                        }
                        throw new AssertionError();
                    }
                    prevE = e;
                }
            }
        }
        return p1.getTextRange().getStartOffset() < p2.getTextRange().getStartOffset();
    }

    @NotNull
    public static List<ImportInfo> buildImports(final SqlFile sqlFile) {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)sqlFile, (CachedValueProvider)new CachedValueProvider<List<ImportInfo>>(){

            public CachedValueProvider.Result<List<ImportInfo>> compute() {
                return new CachedValueProvider.Result(SqlDialectImplUtil.calcImports(sqlFile), new Object[]{sqlFile, DbPsiFacade.getInstance((Project)sqlFile.getProject())});
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "buildImports"));
        }
        return list;
    }

    @NotNull
    protected static List<ImportInfo> calcImports(SqlFile sqlFile) {
        Object info;
        final ArrayList result = ContainerUtil.newArrayList();
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        DatabaseDialectEx dialect = language.getDatabaseDialect();
        PairConsumer<RawConnectionConfig, PairConsumer<String, ObjectKind>> importProvider = language.getImportProvider();
        if (importProvider != null) {
            PairConsumer<String, ObjectKind> consumer = new PairConsumer<String, ObjectKind>(){

                public void consume(String s, ObjectKind type) {
                    result.add(new ImportInfo(null, s, type, Case.MIXED, null));
                }
            };
            for (DbDataSource element : SqlDataSourceMappings.getInstance(sqlFile.getProject()).getDataSources((PsiFile)sqlFile)) {
                if (!(element.getDelegate() instanceof RawConnectionConfig) || DbImplUtil.getDatabaseDialect((DbElement)element) != dialect) continue;
                info = (RawConnectionConfig)element.getDelegate();
                importProvider.consume(info, (Object)consumer);
            }
        }
        for (SqlElement statement : sqlFile.getDdl()) {
            if (!(statement instanceof SqlUseDatabaseStatement)) continue;
            SqlUseDatabaseStatement useStatement = (SqlUseDatabaseStatement)statement;
            info = null;
            for (SqlReferenceExpression ref : ContainerUtil.iterateBackward((List)useStatement.getUseReferences())) {
                ObjectKind kind = ref.getReferenceElementType().getTargetKind();
                boolean isPlain = SqlImplUtil.hasPlainIdentifier(ref, dialect);
                info = new ImportInfo((PsiElement)statement, ref.getName(), kind, sqlFile.getCasing(kind, null).choose(isPlain), (ImportInfo)info);
            }
            ContainerUtil.addIfNotNull((Collection)result, info);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectImplUtil", "calcImports"));
        }
        return arrayList;
    }

    public static Set<String> loadSystemVars(SqlLanguageDialect dialect) {
        return SqlDialectImplUtil.loadTokens(dialect, "systemVars.txt");
    }

    public static <T> JBIterable<T> staticFields(@NotNull Class<?> clazz, final @NotNull Class<T> fieldC) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/dialects/SqlDialectImplUtil", "staticFields"));
        }
        if (fieldC == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldC", "com/intellij/sql/dialects/SqlDialectImplUtil", "staticFields"));
        }
        return JBIterable.of((Object[])clazz.getFields()).filter((Condition)new Condition<Field>(){

            public boolean value(Field field) {
                return Modifier.isStatic(field.getModifiers()) && fieldC.isAssignableFrom(field.getType());
            }
        }).transform((Function)new Function<Field, Object>(){

            public Object fun(Field field) {
                try {
                    return field.get(null);
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
        }).filter(Conditions.notNull()).filter(fieldC);
    }

    public static List<ReservedEntity.Typed> loadEntities(SqlLanguageDialect dialect) {
        ArrayList result = ContainerUtil.newArrayList();
        String invalid = null;
        THashMap kindMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (Object kind : SqlDialectImplUtil.staticFields(SqlDbElementType.class, ObjectKind.class)) {
            kindMap.put(kind.name(), kind);
        }
        THashMap typeMap = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        for (SqlType type : SqlDialectImplUtil.staticFields(SqlType.class, SqlType.class)) {
            typeMap.put(type.getDisplayName(), type);
        }
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), "simpleEntities.txt");
            if (StringUtil.isNotEmpty((String)tokens)) {
                for (String typed : tokens.split("(?m)\\n")) {
                    String[] split = typed.split(":");
                    String name = split[0].trim();
                    ObjectKind objectType = (ObjectKind)kindMap.get(split[1].trim());
                    SqlType type = (SqlType)typeMap.get(split[2].trim());
                    if (split.length != 3 || objectType == null || type == null) {
                        if (invalid != null) continue;
                        invalid = typed;
                        continue;
                    }
                    result.add(new ReservedEntity.Typed(name, objectType, type));
                }
            }
            if (invalid != null) {
                LOG.error("Invalid entity: `" + invalid + "`");
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static Set<String> loadTokens(SqlLanguageDialect dialect, String fileName) {
        THashSet result = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            String tokens = SqlDialectImplUtil.loadDialectResource(dialect.getClass(), fileName);
            if (StringUtil.isNotEmpty((String)tokens)) {
                Collections.addAll(result, tokens.split("(?m)\\s+"));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return result;
    }

    public static String loadDialectResource(Class dialectClass, String name) throws IOException {
        String dialectName = dialectClass.getName();
        String packageName = dialectName.substring(0, dialectName.lastIndexOf(46) + 1).replace('.', '/');
        String xmlResource = packageName + name;
        InputStream xmlIs = dialectClass.getClassLoader().getResourceAsStream(xmlResource);
        return xmlIs == null ? "" : FileUtil.loadTextAndClose((Reader)new InputStreamReader(xmlIs));
    }

    public static class ImportInfo {
        public final PsiElement element;
        public final String name;
        public final ObjectKind kind;
        public final Case casing;
        public final ImportInfo next;

        private ImportInfo(@Nullable PsiElement element, String name, ObjectKind kind, Case casing, @Nullable ImportInfo next) {
            this.element = element;
            this.name = name;
            this.kind = kind;
            this.casing = casing;
            this.next = next;
        }
    }
}

