/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlDialectPusher;
import com.intellij.sql.psi.SqlDialectsUtil;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="SqlDialectMappings", storages={@Storage(file="$PROJECT_FILE$"), @Storage(file="$PROJECT_CONFIG_DIR$/sqldialects.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class SqlDialectMappings
extends LanguagePerFileMappings<SqlLanguageDialect> {
    public static final String DEFAULT_DIALECT_PROPERTY = "DBE.Default.Dialect";
    public static final Key<SqlLanguageDialect> SQL_DIALECT_KEY = Key.create((String)"SQL_LANGUAGE_DIALECT");
    private static final NotNullLazyValue<SqlLanguageDialectEx> ourDefaultDialect = new NotNullLazyValue<SqlLanguageDialectEx>(){

        @NotNull
        protected SqlLanguageDialectEx compute() {
            String dialectId = PropertiesComponent.getInstance().getValue(SqlDialectMappings.DEFAULT_DIALECT_PROPERTY);
            Language language = dialectId != null ? Language.findLanguageByID((String)dialectId) : null;
            SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)((Object)(language instanceof SqlLanguageDialectEx ? language : SqlDialectsUtil.GENERIC));
            if (sqlLanguageDialectEx == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectMappings$1", "compute"));
            }
            return sqlLanguageDialectEx;
        }
    };
    private final SqlDialectPusher myPusherInstance = new SqlDialectPusher();

    public static SqlDialectMappings getInstance(Project project) {
        return (SqlDialectMappings)((Object)ServiceManager.getService((Project)project, SqlDialectMappings.class));
    }

    protected FilePropertyPusher<SqlLanguageDialect> getFilePropertyPusher() {
        return this.myPusherInstance;
    }

    @NotNull
    public static SqlLanguageDialectEx getDefaultSqlDialect() {
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)((Object)ourDefaultDialect.getValue());
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectMappings", "getDefaultSqlDialect"));
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    public static SqlLanguageDialect getMapping(@Nullable Project project, @Nullable VirtualFile file) {
        if (project != null) {
            SqlLanguageDialect sqlLanguageDialect = SqlDialectMappings.getInstance(project).getMapping(file);
            if (sqlLanguageDialect == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectMappings", "getMapping"));
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect mapping = (SqlLanguageDialect)SqlDialectMappings.getMappingInner((VirtualFile)file, null, SQL_DIALECT_KEY);
        SqlLanguageDialectEx sqlLanguageDialectEx = mapping == null ? SqlDialectMappings.getDefaultSqlDialect() : mapping;
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectMappings", "getMapping"));
        }
        return sqlLanguageDialectEx;
    }

    public SqlDialectMappings(Project project) {
        super(project);
    }

    @NotNull
    public SqlLanguageDialect getMapping(@Nullable VirtualFile file) {
        SqlLanguageDialect sqlLanguageDialect = (SqlLanguageDialect)ObjectUtils.assertNotNull((Object)super.getMapping(file));
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectMappings", "getMapping"));
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public SqlLanguageDialect getDefaultMapping(@Nullable VirtualFile file) {
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlDialectMappings.getDefaultSqlDialect();
        if (sqlLanguageDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/SqlDialectMappings", "getDefaultMapping"));
        }
        return sqlLanguageDialectEx;
    }

    protected String serialize(SqlLanguageDialect sqlLanguageDialect) {
        return sqlLanguageDialect.getID();
    }

    public List<SqlLanguageDialect> getAvailableValues() {
        return SqlDialectMappings.getAvailableDialects();
    }

    public static List<SqlLanguageDialect> getAvailableDialects() {
        ArrayList result = ContainerUtil.newArrayList();
        for (Language language : LanguageUtil.getLanguageDialects((Language)SqlLanguage.INSTANCE)) {
            if (language instanceof InjectableLanguage || !(language instanceof SqlLanguageDialect)) continue;
            result.add((SqlLanguageDialect)language);
        }
        return result;
    }
}

