/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.derby;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.derby.DerbyReservedKeywords;
import com.intellij.sql.dialects.derby.DerbyTokens;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.highlighting.QuoteIdentifierQuickFix;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyDialect
extends SqlLanguageDialectEx {
    public static final DerbyDialect INSTANCE = new DerbyDialect();

    public DerbyDialect() {
        super("Derby");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.DerbyDialect derbyDialect = com.intellij.database.dialects.DerbyDialect.INSTANCE;
        if (derbyDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/derby/DerbyDialect", "getDatabaseDialect"));
        }
        return derbyDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/derby/DerbyDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(DerbyTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/derby/DerbyDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/derby/DerbyDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/derby/DerbyDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/derby/DerbyDialect", "processReservedEntitiesWithType"));
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_SESSION.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_SESSION, element, (SqlType)SqlType.REFERENCE, false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        ASTNode astNode = o.getNode();
        assert (astNode != null);
        String text = astNode.getText();
        if (text.length() > 0 && !Character.isLetter(text.charAt(0))) {
            return manager.createProblemDescriptor((PsiElement)o, SqlMessages.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }

    public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, PsiElement place) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/derby/DerbyDialect", "isImportedAtPlace"));
        }
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/sql/dialects/derby/DerbyDialect", "isImportedAtPlace"));
        }
        if (super.isImportedAtPlace(sqlFile, dbElement, place)) {
            return true;
        }
        if (dbElement.getKind() == ObjectKind.SCHEMA && Comparing.equal((String)dbElement.getName(), (String)"APP", (boolean)false)) {
            return true;
        }
        return SqlDialectImplUtil.checkFileImports(sqlFile, dbElement, place);
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(DerbyReservedKeywords.class);
        static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ});
        static ReservedEntity RE_SESSION = new ReservedEntity("session", ObjectKind.NONE);

        private LazyData() {
        }
    }
}

