/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.functions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionDefinitionParser;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionsUtil {
    private static final Key<SqlFunctionDefinition.Prototype> EXPLICIT_FUNCTION_PROTOTYPE = Key.create((String)"EXPLICIT_FUNCTION_PROTOTYPE");

    public static Map<String, SqlFunctionDefinition> loadFunctionDefinition(@NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "loadFunctionDefinition"));
        }
        THashMap map = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        try {
            Class<?> dialectClass = ((Object)((Object)dialect)).getClass();
            SqlFunctionDefinitionParser parser = new SqlFunctionDefinitionParser(dialect);
            for (SqlFunctionDefinition definition : parser.parse(SqlFunctionsUtil.getDialectFunctionDefinitions(dialectClass))) {
                SqlFunctionDefinition def = map.put(definition.getName().toUpperCase(), definition);
                assert (def == null) : definition.getName() + " already exists";
            }
        }
        catch (IOException e) {
            SqlDialectImplUtil.LOG.error((Throwable)e);
        }
        return map;
    }

    @NotNull
    public static String getDialectFunctionDefinitions(Class dialectClass) throws IOException {
        String string = SqlDialectImplUtil.loadDialectResource(dialectClass, "functions.xml");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getDialectFunctionDefinitions"));
        }
        return string;
    }

    @Nullable
    public static SqlReferenceElementType getReferenceType(SqlFunctionDefinition.ReferenceParameter parameter) {
        return (SqlReferenceElementType)SqlTokenRegistry.findCompositeType((String)("SQL_" + parameter.getRefTypeName() + "_REFERENCE"));
    }

    public static boolean isAssignable(SqlFunctionDefinition.Parameter parameter, SqlExpression expression) {
        if (parameter instanceof SqlFunctionDefinition.ReferenceParameter) {
            SqlReferenceElementType refType = SqlFunctionsUtil.getReferenceType((SqlFunctionDefinition.ReferenceParameter)parameter);
            return refType == null || SqlScopeProcessor.acceptsElement(expression, SqlImplUtil.getSqlDialectSafe((PsiElement)expression), Collections.singleton(refType.getTargetKind()), false, false);
        }
        if (parameter instanceof SqlFunctionDefinition.SimpleParameter) {
            SqlFunctionDefinition.Type type = ((SqlFunctionDefinition.SimpleParameter)parameter).getType();
            SqlType exprType = expression.getSqlType();
            if (type == SqlFunctionDefinition.TABLE && exprType instanceof SqlTableType) {
                return true;
            }
            SqlType sqlType = type.getSqlType();
            return sqlType == null || SqlImplUtil.isAssignable(sqlType, exprType);
        }
        return false;
    }

    public static void setExplicitPrototype(@Nullable SqlExpression expr, SqlFunctionDefinition.Prototype prototype) {
        if (expr != null) {
            expr.putUserData(EXPLICIT_FUNCTION_PROTOTYPE, (Object)prototype);
        }
    }

    @Nullable
    public static SqlFunctionDefinition.Prototype chooseTheBestPrototype(SqlFunctionCallExpression expression, boolean returnTypeOnly) {
        SqlFunctionDefinition.Prototype explicitPrototype = (SqlFunctionDefinition.Prototype)expression.getUserData(EXPLICIT_FUNCTION_PROTOTYPE);
        if (explicitPrototype != null) {
            return explicitPrototype;
        }
        SqlFunctionDefinition definition = (SqlFunctionDefinition)((Object)ObjectUtils.tryCast((Object)expression.getFunctionDefinition(), SqlFunctionDefinition.class));
        if (definition == null) {
            return null;
        }
        if (returnTypeOnly) {
            SqlFunctionDefinition.Prototype cur = null;
            for (SqlFunctionDefinition.Prototype p : definition.getPrototypes()) {
                if (cur == null) {
                    cur = p;
                    continue;
                }
                if (Comparing.equal((Object)cur.getReturnType(), (Object)p.getReturnType())) continue;
                cur = null;
                break;
            }
            if (cur != null) {
                return cur;
            }
        }
        Map<SqlFunctionDefinition.Prototype, Map<PsiElement, SqlFunctionDefinition.Parameter>> map = SqlFunctionsUtil.getAcceptedPrototypes(definition, expression.getParameterList());
        SqlFunctionDefinition.Prototype maxMatched = null;
        int maxMatchedCount = -1;
        for (SqlFunctionDefinition.Prototype prototype : map.keySet()) {
            Map<PsiElement, SqlFunctionDefinition.Parameter> mapping = map.get(prototype);
            int count = 0;
            for (PsiElement element : mapping.keySet()) {
                if (!(element instanceof SqlExpression) || !SqlFunctionsUtil.isAssignable(mapping.get(element), (SqlExpression)element)) continue;
                ++count;
            }
            if (maxMatchedCount >= count) continue;
            maxMatchedCount = count;
            maxMatched = prototype;
        }
        return maxMatched;
    }

    @NotNull
    private static Map<SqlFunctionDefinition.Prototype, Map<PsiElement, SqlFunctionDefinition.Parameter>> getAcceptedPrototypes(@NotNull SqlFunctionDefinition definition, @Nullable SqlExpressionList parameterList) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getAcceptedPrototypes"));
        }
        ASTNode astNode = parameterList == null ? null : parameterList.getNode();
        ASTNode[] nodes = astNode == null ? ASTNode.EMPTY_ARRAY : astNode.getChildren(null);
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (SqlFunctionDefinition.Prototype prototype : definition.getPrototypes()) {
            Map<PsiElement, SqlFunctionDefinition.Parameter> map = SqlFunctionsUtil.mapArguments(prototype, nodes);
            if (map == null) continue;
            result.put(prototype, map);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "getAcceptedPrototypes"));
        }
        return linkedHashMap;
    }

    public static Map<PsiElement, SqlFunctionDefinition.Parameter> mapArguments(@NotNull SqlFunctionDefinition.Prototype prototype, @Nullable SqlExpressionList parameterList) {
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        ASTNode astNode = parameterList == null ? null : parameterList.getNode();
        ASTNode[] nodes = astNode == null ? ASTNode.EMPTY_ARRAY : astNode.getChildren(null);
        return SqlFunctionsUtil.mapArguments(prototype, nodes);
    }

    private static Map<PsiElement, SqlFunctionDefinition.Parameter> mapArguments(@NotNull SqlFunctionDefinition.Prototype prototype, @NotNull ASTNode[] paramNodes) {
        if (prototype == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prototype", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        if (paramNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramNodes", "com/intellij/sql/dialects/functions/SqlFunctionsUtil", "mapArguments"));
        }
        if (paramNodes.length == 0) {
            return prototype.getParams().length == 0 ? Collections.emptyMap() : null;
        }
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        PsiElement prev = null;
        for (ASTNode node : paramNodes) {
            Object value = SqlInfoElementType.getValue(node);
            if (!(value instanceof SqlFunctionDefinition.Parameter)) {
                PsiElement psi = node.getPsi();
                if (psi instanceof PsiWhiteSpace || psi instanceof PsiComment) continue;
                prev = psi;
                continue;
            }
            int prototypeId = ((SqlFunctionDefinition.Parameter)value).getPrototypeId();
            if (prev == null || prototypeId != prototype.getPrototypeId() && prototypeId != -1) continue;
            map.put(prev, (SqlFunctionDefinition.Parameter)value);
        }
        return map;
    }
}

