/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mysql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mysql.MysqlOptionalKeywords;
import com.intellij.sql.dialects.mysql.MysqlReservedKeywords;
import com.intellij.sql.dialects.mysql.MysqlTokens;
import com.intellij.sql.dialects.mysql.MysqlTypes;
import com.intellij.sql.dialects.mysql.psi.MysqlDelimiterStatementImpl;
import com.intellij.sql.dialects.mysql.refactoring.MysqlExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlDialect
extends SqlLanguageDialectEx {
    public static final MysqlDialect INSTANCE = new MysqlDialect();
    private static final PairConsumer<RawConnectionConfig, PairConsumer<String, ObjectKind>> MY_IMPORTS_PROVIDER = new PairConsumer<RawConnectionConfig, PairConsumer<String, ObjectKind>>(){

        public void consume(RawConnectionConfig connectionInfo, PairConsumer<String, ObjectKind> consumer) {
            String url = connectionInfo.getUrl();
            if (StringUtil.isEmpty((String)url) || !url.startsWith("jdbc:mysql:")) {
                return;
            }
            int paramsIdx = url.indexOf(63);
            int end = paramsIdx > 0 ? paramsIdx : url.length();
            int start = url.lastIndexOf(47, end - 1);
            if (start > -1) {
                String databaseName = url.substring(start + 1, end);
                consumer.consume((Object)databaseName, (Object)ObjectKind.DATABASE);
            }
        }
    };

    public MysqlDialect() {
        super("MySQL");
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.MysqlDialect mysqlDialect = com.intellij.database.dialects.MysqlDialect.INSTANCE;
        if (mysqlDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDatabaseDialect"));
        }
        return mysqlDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(MysqlTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getKeywords"));
        }
        return set;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Map<String, SqlFunctionDefinition.Type> map = Types.types;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getBuiltInTypes"));
        }
        return map;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getSystemVariables"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mysql/MysqlDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/mysql/MysqlDialect", "processReservedEntitiesWithType"));
        }
        if (!MysqlDialect.processReservedEntitiesWithTypeDual(name, element, resolve, processor)) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, PsiElement place) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/mysql/MysqlDialect", "isImportedAtPlace"));
        }
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/sql/dialects/mysql/MysqlDialect", "isImportedAtPlace"));
        }
        ObjectKind type = dbElement.getKind();
        if ((type == ObjectKind.DATABASE || type == ObjectKind.SCHEMA) && StringUtil.isEmpty((String)dbElement.getName())) {
            return true;
        }
        return SqlDialectImplUtil.checkFileImports(sqlFile, dbElement, place);
    }

    public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mysql/MysqlDialect", "isResolveTargetAccepted"));
        }
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/sql/dialects/mysql/MysqlDialect", "isResolveTargetAccepted"));
        }
        return element instanceof DasNamespace && expectedTypes.contains(ObjectKind.SCHEMA) || super.isResolveTargetAccepted(element, type, expectedTypes);
    }

    @Override
    @Nullable
    public PairConsumer<RawConnectionConfig, PairConsumer<String, ObjectKind>> getImportProvider() {
        return MY_IMPORTS_PROVIDER;
    }

    @Override
    public boolean isVariablePrefix(@Nullable String prefix) {
        return "@".equals(prefix) || "@@".equals(prefix);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/sql/dialects/mysql/MysqlDialect", "isAutoIncrementColumn"));
        }
        if (super.isAutoIncrementColumn(column)) {
            return true;
        }
        String type = column.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @Override
    @NotNull
    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDelimiterAt"));
        }
        String result = null;
        if (offset > 0) {
            for (MysqlDelimiterStatementImpl delimiter : SqlImplUtil.iterarateStatementsBackward((PsiFile)file, offset).filter(MysqlDelimiterStatementImpl.class)) {
                if (delimiter.getDelimiter() == null) continue;
                result = delimiter.getDelimiter();
                break;
            }
        }
        if (result == null) {
            String string = super.getDelimiterAt(file, offset);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDelimiterAt"));
            }
            return string;
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/mysql/MysqlDialect", "getDelimiterAt"));
        }
        return string;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new MysqlExtractVariableHelper();
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/mysql/MysqlDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/mysql/MysqlDialect", "supportsSql92CharSetSpecFor"));
        }
        return element == SqlCompositeElementTypes.SQL_STRING_LITERAL || element == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || element == SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    public static class Types {
        public static Map<String, SqlFunctionDefinition.Type> types = ContainerUtil.newMapFromValues(Arrays.asList(new SqlFunctionDefinition.Type("Geometry", "geometric object", null), new SqlFunctionDefinition.Type("Point", "point", null), new SqlFunctionDefinition.Type("Curve", "curve", null), new SqlFunctionDefinition.Type("LineString", "line string", null), new SqlFunctionDefinition.Type("Line", "line", null), new SqlFunctionDefinition.Type("LinearRing", "linear ring", null), new SqlFunctionDefinition.Type("Surface", "surface", null), new SqlFunctionDefinition.Type("Polygon", "polygon", null), new SqlFunctionDefinition.Type("GeometryCollection", "geometry collection", null), new SqlFunctionDefinition.Type("MultiPoint", "multi point", null), new SqlFunctionDefinition.Type("MultiCurve", "multi curve", null), new SqlFunctionDefinition.Type("MultiLineString", "multi line string", null), new SqlFunctionDefinition.Type("MultiSurface", "multi surface", null), new SqlFunctionDefinition.Type("MultiPolygon", "multi polygon", null)).iterator(), (Convertor)new Convertor<SqlFunctionDefinition.Type, String>(){

            public String convert(SqlFunctionDefinition.Type o) {
                return o.getName();
            }
        });
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(MysqlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.MYSQL_DELIMITER_TOKEN})});
        static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_INVERT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_NULLSAFE_EQ, SqlElementTypes.SQL_OP_LEFT_SHIFT, SqlElementTypes.SQL_OP_RIGHT_SHIFT, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT2, SqlElementTypes.SQL_OP_ASSIGN, MysqlReservedKeywords.MYSQL_REGEXP, MysqlReservedKeywords.MYSQL_RLIKE, MysqlOptionalKeywords.MYSQL_SOUNDS, MysqlReservedKeywords.MYSQL_DIV, MysqlReservedKeywords.MYSQL_MOD, MysqlReservedKeywords.MYSQL_XOR, MysqlReservedKeywords.MYSQL_BINARY});
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_LOOP, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end loop", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{SqlElementTypes.SQL_LOOP}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{SqlElementTypes.SQL_THEN, SqlElementTypes.SQL_THEN_CLAUSE, SqlElementTypes.SQL_IF_STATEMENT}, "", "end if", 2, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{SqlElementTypes.SQL_IF}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlTypes.MYSQL_DO, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "end while", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_WHILE}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build()), new SubstitutionDescriptorImpl.DelimiterAware(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT, SqlElementTypes.SQL_LOOP_STATEMENT}, "", "until  end repeat", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(new IElementType[]{MysqlReservedKeywords.MYSQL_REPEAT}).opt(new IElementType[]{SqlElementTypes.SQL_LABEL_BACK_REFERENCE}).opt(new IElementType[]{SqlElementTypes.SQL_SEMICOLON, SqlTokens.MYSQL_DELIMITER_TOKEN}).build())));

        private LazyData() {
        }
    }
}

