/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.InjectableLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.dialects.postgres.PostgresReservedKeywords;
import com.intellij.sql.dialects.postgres.PostgresTokens;
import com.intellij.sql.dialects.postgres.psi.PgCodeBlockElementType;
import com.intellij.sql.dialects.postgres.psi.PgCreateRuleStatement;
import com.intellij.sql.dialects.postgres.refactoring.PostgresExtractVariableHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlForLoopStatement;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturningClause;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresDialect
extends SqlLanguageDialectEx {
    public static final PostgresDialect INSTANCE = new PostgresDialect();

    public PostgresDialect() {
        super("PostgreSQL");
    }

    protected PostgresDialect(@NonNls @NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/sql/dialects/postgres/PostgresDialect", "<init>"));
        }
        super(id);
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.PostgresDialect postgresDialect = com.intellij.database.dialects.PostgresDialect.INSTANCE;
        if (postgresDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getDatabaseDialect"));
        }
        return postgresDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return LazyData.ourReservedTokens.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = LazyData.ourFunctionMap;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getSupportedFunctions"));
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Map<String, SqlFunctionDefinition.Type> map = Types.types;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getBuiltInTypes"));
        }
        return map;
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(PostgresTokens.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getKeywords"));
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getSystemVariables"));
        }
        return set;
    }

    @NotNull
    public Set<String> getExceptionNames() {
        Set<String> set = LazyData.ourExceptionNames;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getExceptionNames"));
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        SqlReferenceElementType type;
        SqlDmlInstruction insert;
        Object type2;
        SyntaxTraverser.ApiEx api;
        PsiElement conflictAction;
        String nameUC;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/postgres/PostgresDialect", "processReservedEntitiesWithType"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/dialects/postgres/PostgresDialect", "processReservedEntitiesWithType"));
        }
        String string = nameUC = name == null ? null : name.toUpperCase(Locale.ENGLISH);
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_EXCLUDED.name, resolve) && (conflictAction = (PsiElement)(api = SyntaxTraverser.psiApi()).parents((Object)element).filter(PostgresDialect.isType((IElementType)PostgresElementTypes.PG_CONFLICT_ACTION_CLAUSE)).first()) != null && !api.children((Object)conflictAction).filter(PostgresDialect.isType((IElementType)SqlTokens.SQL_UPDATE)).isEmpty() && !processor.executeTarget((DasObject)LazyData.RE_EXCLUDED, element, (SqlType)((type2 = (insert = (SqlDmlInstruction)api.parents((Object)element).filter(SqlDmlInstruction.class).first()) == null ? SqlType.UNKNOWN : insert.getTargetExpression().getSqlType()) == SqlType.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type2), false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensetiveOrTrue(name, PostgresDialect.RE_NEW.name, resolve) || SqlImplUtil.equalsInsensetiveOrTrue(name, PostgresDialect.RE_OLD.name, resolve)) {
            SqlTargetContextProvider statement = (SqlTargetContextProvider)PsiTreeUtil.getParentOfType((PsiElement)element, PgCreateRuleStatement.class);
            boolean triggerFunction = false;
            if (statement == null) {
                SqlCreateFunctionStatementImpl function = PostgresDialect.getEnclosingFunction(element);
                triggerFunction = PostgresDialect.isTriggerFunction(function);
                statement = PostgresDialect.findCreateTriggerStatement(function);
            }
            if (statement == null) {
                statement = (SqlTargetContextProvider)PsiTreeUtil.getParentOfType((PsiElement)element, SqlCreateTriggerStatement.class);
            }
            if (statement != null) {
                SqlReferenceExpression expression = statement.getTargetContextExpression();
                type2 = expression == null ? SqlType.UNKNOWN : expression.getSqlType();
                if (!processor.executeTarget((DasObject)RE_NEW, element, (SqlType)(type2 == SqlType.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type2), false, ResolveState.initial())) {
                    return false;
                }
                if (!processor.executeTarget((DasObject)RE_OLD, element, (SqlType)(type2 == SqlType.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type2), false, ResolveState.initial())) {
                    return false;
                }
            } else if (triggerFunction) {
                if (!processor.executeTarget((DasObject)RE_NEW, element, (SqlType)SqlTableTypeBase.EMPTY_TABLE, false, ResolveState.initial())) {
                    return false;
                }
                if (!processor.executeTarget((DasObject)RE_OLD, element, (SqlType)SqlTableTypeBase.EMPTY_TABLE, false, ResolveState.initial())) {
                    return false;
                }
            }
        }
        if (this.inPl(element)) {
            if (SqlImplUtil.equalsInsensetiveOrTrue(LazyData.RE_FOUND.name, name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_FOUND, element, (SqlType)SqlType.BOOLEAN, false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensetiveOrTrue(LazyData.SQLSTATE.name, name, resolve) && PostgresDialect.raiseStatement(element) && !processor.executeTarget((DasObject)LazyData.SQLSTATE, element, (SqlType)SqlType.INTEGER, false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensetiveOrTrue(LazyData.SQLERRM.name, name, resolve) && PostgresDialect.raiseStatement(element) && !processor.executeTarget((DasObject)LazyData.SQLERRM, element, (SqlType)SqlType.STRING, false, ResolveState.initial())) {
                return false;
            }
        }
        if (!(resolve && !LazyData.RE_OPS.containsKey(nameUC) || processor.executeTarget(LazyData.RE_OPS.get(nameUC), element, (SqlType)SqlType.REFERENCE, false, ResolveState.initial()))) {
            return false;
        }
        SqlCreateFunctionStatementImpl function = PostgresDialect.getEnclosingFunction(element);
        if (PostgresDialect.isTriggerFunction(function) || PostgresDialect.findCreateTriggerStatement(function) != null) {
            for (DasObject entity : LazyData.TRIGGER_STRING_IMPLICITS.values()) {
                if (PostgresDialect.processReservedEntitiesWithTypeSimple(entity, (SqlType)SqlType.STRING, name, element, resolve, processor, true, false)) continue;
                return false;
            }
            if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_TG_NARGS.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_TG_NARGS, element, (SqlType)SqlType.INTEGER, false, ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensetiveOrTrue(name, LazyData.RE_TG_ARGV.name, resolve) && !processor.executeTarget((DasObject)LazyData.RE_TG_ARGV, element, (SqlType)SqlType.ARRAY, false, ResolveState.initial())) {
                return false;
            }
        }
        if (processor.getExpectedTypes().contains(ObjectKind.COLUMN)) {
            for (DasObject entity : LazyData.RESERVED_INTEGER_ENTITIES.values()) {
                if (PostgresDialect.processReservedEntitiesWithTypeSimple(entity, (SqlType)SqlType.INTEGER, name, element, resolve, processor, true, false)) continue;
                return false;
            }
        }
        if (element instanceof SqlReferenceExpression) {
            SqlType querySqlType;
            SqlQueryExpression query;
            SqlReferenceExpression variableRef;
            SqlForLoopStatement forLoop;
            SqlExpression qualifier = ((SqlReferenceExpression)element).getQualifierExpression();
            PsiElement qualifierTarget = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
            SqlForLoopStatement sqlForLoopStatement = forLoop = qualifierTarget == null ? null : (SqlForLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlForLoopStatement.class);
            while (!(forLoop == null || (variableRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)forLoop, SqlReferenceExpression.class)) != null && qualifierTarget.equals(variableRef.resolve()))) {
                forLoop = (SqlForLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)forLoop, SqlForLoopStatement.class, (boolean)true);
            }
            if (forLoop != null && (query = (SqlQueryExpression)PsiTreeUtil.getChildOfType((PsiElement)forLoop, SqlQueryExpression.class)) != null && (querySqlType = query.getSqlType()) instanceof SqlTableType) {
                return SqlImplUtil.processDeclarationsInType((SqlTableType)querySqlType, (PsiScopeProcessor)processor, ResolveState.initial());
            }
        }
        if (element instanceof SqlReferenceExpression && (type = ((SqlReferenceExpression)element).getReferenceElementType()) == SqlCompositeElementTypes.SQL_TABLESPACE_REFERENCE) {
            if (!PostgresDialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_PG_DEFAULT, (SqlType)SqlType.REFERENCE, name, element, resolve, processor, false, false)) {
                return false;
            }
            if (!PostgresDialect.processReservedEntitiesWithTypeSimple((DasObject)LazyData.RE_PG_GLOBAL, (SqlType)SqlType.REFERENCE, name, element, resolve, processor, false, false)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE(), (Condition)Conditions.is((Object)type));
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "isType"));
        }
        return condition;
    }

    private boolean inPl(PsiElement element) {
        return this == PlDialect.INSTANCE || PsiTreeUtil.getParentOfType((PsiElement)element, PgCodeBlockElementType.BodyElement.class) != null;
    }

    private static boolean raiseStatement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/postgres/PostgresDialect", "raiseStatement"));
        }
        SqlStatement statement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class);
        return statement != null && statement.getNode().getElementType() == PostgresElementTypes.PG_RAISE_STATEMENT;
    }

    private static boolean isTriggerFunction(@Nullable SqlCreateFunctionStatementImpl function) {
        if (function == null) {
            return false;
        }
        PsiElement returns = PsiTreeUtil.getChildOfType((PsiElement)function, SqlReturnsClause.class);
        return returns != null && StringUtil.containsIgnoreCase((String)returns.getText(), (String)"trigger");
    }

    private static SqlCreateTriggerStatement findCreateTriggerStatement(final @Nullable SqlCreateFunctionStatementImpl function) {
        if (function == null) {
            return null;
        }
        return (SqlCreateTriggerStatement)CachedValuesManager.getCachedValue((PsiElement)function, (CachedValueProvider)new CachedValueProvider<SqlCreateTriggerStatement>(){

            @Nullable
            public CachedValueProvider.Result<SqlCreateTriggerStatement> compute() {
                PsiReference reference;
                SqlCreateTriggerStatement statement = null;
                Iterator iterator = ReferencesSearch.search((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)function), (SearchScope)new LocalSearchScope((PsiElement)function.getContainingFile())).iterator();
                while (iterator.hasNext() && (statement = (SqlCreateTriggerStatement)PsiTreeUtil.getParentOfType((PsiElement)(reference = (PsiReference)iterator.next()).getElement(), SqlCreateTriggerStatement.class)) == null) {
                }
                return CachedValueProvider.Result.createSingleDependency(statement, (Object)PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
    }

    @Override
    @NotNull
    public SqlType getDefinitionType(@NotNull SqlTypedDefinition definition, int usageOffset) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/sql/dialects/postgres/PostgresDialect", "getDefinitionType"));
        }
        SqlTypeElement element = definition.getTypeElement();
        if (this.inPl((PsiElement)definition) && element != null && StringUtil.equalsIgnoreCase((CharSequence)"record", (CharSequence)element.getText())) {
            SqlBlockStatementImpl block = (SqlBlockStatementImpl)PsiTreeUtil.getTopmostParentOfType((PsiElement)definition, SqlBlockStatementImpl.class);
            Query search = block == null ? ReferencesSearch.search((PsiElement)definition) : ReferencesSearch.search((PsiElement)definition, (SearchScope)new LocalSearchScope((PsiElement)block));
            Collection all = search.findAll();
            PsiReference required = null;
            for (PsiReference ref : all) {
                int offset;
                if (ref.getElement().getParent() instanceof SqlSelectIntoClause) {
                    required = ref;
                }
                if ((offset = ref.getElement().getTextOffset()) < usageOffset) continue;
                break;
            }
            if (required != null) {
                SqlType type;
                SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)required.getElement(), SqlQueryExpression.class);
                if (query != null) {
                    SqlType sqlType = query.getSqlType();
                    if (sqlType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getDefinitionType"));
                    }
                    return sqlType;
                }
                SqlReturningClause returningClause = (SqlReturningClause)PsiTreeUtil.getParentOfType((PsiElement)required.getElement(), SqlReturningClause.class);
                SqlType sqlType = type = returningClause != null ? returningClause.getSqlType() : null;
                if (type != null) {
                    SqlType sqlType2 = type;
                    if (sqlType2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getDefinitionType"));
                    }
                    return sqlType2;
                }
            }
        }
        SqlType sqlType = super.getDefinitionType(definition, usageOffset);
        if (sqlType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/postgres/PostgresDialect", "getDefinitionType"));
        }
        return sqlType;
    }

    @Override
    public void addReservedEntityTargets(String name, Collection<PsiElement> result, SqlElement element) {
        ArrayList parameters;
        SqlCreateFunctionStatementImpl function;
        int parameterIndex;
        if (StringUtil.startsWithChar((CharSequence)name, (char)'$') && (parameterIndex = StringUtil.parseInt((String)name.substring(1), (int)0) - 1) > -1 && (function = PostgresDialect.getEnclosingFunction((PsiElement)element)) != null && parameterIndex < (parameters = ContainerUtil.newArrayList(function.getArguments())).size()) {
            result.add((PsiElement)parameters.get(parameterIndex));
        }
    }

    @Nullable
    private static SqlCreateFunctionStatementImpl getEnclosingFunction(PsiElement element) {
        return (SqlCreateFunctionStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlCreateFunctionStatementImpl.class});
    }

    public boolean isImportedAtPlace(@NotNull SqlFile sqlFile, @NotNull DasObject dbElement, @Nullable PsiElement place) {
        if (sqlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sqlFile", "com/intellij/sql/dialects/postgres/PostgresDialect", "isImportedAtPlace"));
        }
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/sql/dialects/postgres/PostgresDialect", "isImportedAtPlace"));
        }
        if (super.isImportedAtPlace(sqlFile, dbElement, place)) {
            return true;
        }
        if (dbElement.getKind() == ObjectKind.SCHEMA && Comparing.equal((String)dbElement.getName(), (String)"public", (boolean)false)) {
            return true;
        }
        return SqlDialectImplUtil.checkFileImports(sqlFile, dbElement, place);
    }

    public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/dialects/postgres/PostgresDialect", "isResolveTargetAccepted"));
        }
        if (expectedTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypes", "com/intellij/sql/dialects/postgres/PostgresDialect", "isResolveTargetAccepted"));
        }
        if (type == SqlDbElementType.LOCAL_ALIAS && expectedTypes.contains(ObjectKind.COLUMN)) {
            PsiElement parent = element.getParent();
            return parent instanceof SqlFromClause || parent instanceof SqlJoinExpression;
        }
        if (type == PostgresElementTypes.Extra.EXTENSION && expectedTypes.contains(PostgresElementTypes.Extra.FOREIGN_DATA_WRAPPER)) {
            return true;
        }
        if (type == SqlDbElementType.USER && expectedTypes.contains(SqlDbElementType.ROLE)) {
            return true;
        }
        return super.isResolveTargetAccepted(element, type, expectedTypes);
    }

    @Override
    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/sql/dialects/postgres/PostgresDialect", "isAutoIncrementColumn"));
        }
        if (super.isAutoIncrementColumn(column)) {
            return true;
        }
        String type = column.getDataType().getSpecification();
        return StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"bigserial") || StringUtil.equalsIgnoreCase((CharSequence)type, (CharSequence)"serial");
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PostgresExtractVariableHelper();
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/sql/dialects/postgres/PostgresDialect", "shouldQuotedTypeReferenceBeChecked"));
        }
        return !Types.builtinTypes.contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final Set<String> ourExceptionNames = Collections.unmodifiableSet(SqlDialectImplUtil.loadTokens(INSTANCE, "exceptions.txt"));
        static final TokenSet ourReservedTokens = SqlTokenRegistry.getTokenSet(PostgresReservedKeywords.class);
        static final TokenSet ourSupportedOperators = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_QUESTION_MARK, SqlTokens.PG_OP_CUSTOM});
        static final Map<String, DasObject> TRIGGER_STRING_IMPLICITS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "TG_NAME", "TG_WHEN", "TG_LEVEL", "TG_OP", "TG_RELID", "TG_RELNAME", "TG_TABLE_NAME", "TG_TABLE_SCHEMA", "TG_TAG", "TG_EVENT");
        static final ReservedEntity RE_TG_NARGS = new ReservedEntity("TG_NARGS", ObjectKind.COLUMN);
        static final ReservedEntity RE_TG_ARGV = new ReservedEntity("TG_ARGV", ObjectKind.COLUMN);
        static final Map<String, DasObject> RESERVED_INTEGER_ENTITIES = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "OID", "TABLEOID", "XMIN", "CMIN", "XMAX", "CMAX", "CTID");
        static final Map<String, DasObject> RE_OPS = SqlDialectImplUtil.buildEntities(ObjectKind.COLUMN, "INTEGER_OPS", "TEXT_PATTERN_OPS", "INT8_OPS", "INT4_OPS", "INT2_OPS", "VARCHAR_PATTERN_OPS", "BPCHAR_PATTERN_OPS", "JSONB_PATH_OPS");
        static final ReservedEntity RE_EXCLUDED = new ReservedEntity("EXCLUDED", SqlDbElementType.TABLE);
        static final ReservedEntity RE_FOUND = new ReservedEntity("FOUND", ObjectKind.COLUMN);
        static final ReservedEntity SQLSTATE = new ReservedEntity("SQLSTATE", ObjectKind.COLUMN);
        static final ReservedEntity SQLERRM = new ReservedEntity("SQLERRM", ObjectKind.COLUMN);
        static final ReservedEntity RE_PG_DEFAULT = new ReservedEntity("pg_default", SqlDbElementType.TABLESPACE);
        static final ReservedEntity RE_PG_GLOBAL = new ReservedEntity("pg_global", SqlDbElementType.TABLESPACE);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_FOR_LOOP_STATEMENT}, "", "end loop;", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_LOOP, SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE, SqlTokens.SQL_SEMICOLON}).mask(true, true, false, false)), new SubstitutionDescriptorImpl(new IElementType[]{SqlCommonKeywords.SQL_THEN, SqlCompositeElementTypes.SQL_THEN_CLAUSE, SqlCompositeElementTypes.SQL_IF_STATEMENT}, "", "end if;", 2, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlCommonKeywords.SQL_END, SqlCommonKeywords.SQL_IF, SqlTokens.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }

    public static class Types {
        public static Map<String, SqlFunctionDefinition.Type> types = ContainerUtil.newMapFromValues(Arrays.asList(new SqlFunctionDefinition.Type("dpn", "double precision or numeric", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("bigint", "bigint", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("numeric", "numeric", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("dp", "double precision", (SqlType)SqlType.REAL), new SqlFunctionDefinition.Type("bytea", "bytea", (SqlType)SqlType.BYTES), new SqlFunctionDefinition.Type("name", "name", (SqlType)SqlType.STRING), new SqlFunctionDefinition.Type("str[]", "str[]", (SqlType)SqlType.ARRAY), new SqlFunctionDefinition.Type("oid", "oid", null), new SqlFunctionDefinition.Type("gobject", "geometric object", null), new SqlFunctionDefinition.Type("circle", "circle", null), new SqlFunctionDefinition.Type("path", "path", null), new SqlFunctionDefinition.Type("box", "box", null), new SqlFunctionDefinition.Type("polygon", "polygon", null), new SqlFunctionDefinition.Type("lseg", "lseg", null), new SqlFunctionDefinition.Type("point", "point", null), new SqlFunctionDefinition.Type("line", "line", null), new SqlFunctionDefinition.Type("cidr", "cidr", null), new SqlFunctionDefinition.Type("inet", "inet", null), new SqlFunctionDefinition.Type("macaddr", "macaddr", null), new SqlFunctionDefinition.Type("tsvector", "tsvector", null), new SqlFunctionDefinition.Type("tsquery", "tsquery", null), new SqlFunctionDefinition.Type("trigger", "trigger", null), new SqlFunctionDefinition.Type("range", "range", null), new SqlFunctionDefinition.Type("txid_snapshot", "txid_snapshot", null), new SqlFunctionDefinition.Type("void", "void", null), new SqlFunctionDefinition.Type("record", "record", null), new SqlFunctionDefinition.Type("enum", "enum", null), new SqlFunctionDefinition.Type("xml", "xml", null), new SqlFunctionDefinition.Type("float4", "float4", null), new SqlFunctionDefinition.Type("int2vector", "int2vector", null), new SqlFunctionDefinition.Type("json", "json", null), new SqlFunctionDefinition.Type("jsonb", "jsonb", null)).iterator(), (Convertor)new Convertor<SqlFunctionDefinition.Type, String>(){

            public String convert(SqlFunctionDefinition.Type o) {
                return o.getName();
            }
        });
        public static final Set<String> builtinTypes = ContainerUtil.newHashSet((Object[])new String[]{"bool", "bytea", "char", "int8", "int2", "int4", "regproc", "text", "oid", "tid", "xid", "cid", "json", "xml", "pg_node_tree", "smgr", "path", "polygon", "float4", "float8", "abstime", "reltime", "tinterval", "unknown", "circle", "money", "macaddr", "inet", "cidr", "aclitem", "bpchar", "varchar", "date", "time", "timestamp", "timestamptz", "interval", "timetz", "bit", "varbit", "numeric", "refcursor", "regprocedure", "regoper", "regoperator", "regclass", "regtype", "uuid", "tsvector", "gtsvector", "tsquery", "regconfig", "regdictionary", "txid_snapshot", "int4range", "numrange", "tsrange", "tstzrange", "daterange", "int8range", "record", "cstring", "any", "anyarray", "void", "trigger", "event_trigger", "language_handler", "internal", "opaque", "anyelement", "anynonarray", "anyenum", "fdw_handler", "anyrange", "cardinal_number", "character_data", "sql_identifier", "time_stamp", "yes_or_no"});
    }

    public static class PlDialect
    extends PostgresDialect
    implements InjectableLanguage {
        public static final PlDialect INSTANCE = new PlDialect();

        public PlDialect() {
            super("PostgresPLSQL");
        }
    }
}

