/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sybase;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.common.SqlGeneratedParser;
import com.intellij.sql.dialects.sybase.AseDdlParsing;
import com.intellij.sql.dialects.sybase.AseDmlParsing;
import com.intellij.sql.dialects.sybase.AseElementTypes;
import com.intellij.sql.dialects.sybase.AseGeneratedParser;
import com.intellij.sql.dialects.sybase.SybaseDialect;
import com.intellij.sql.dialects.sybase.SybaseExpressionParsing;
import com.intellij.sql.dialects.sybase.SybaseOptionalKeywords;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;

public class SybaseParser
extends SqlParser {
    public SybaseParser() {
        super(SybaseDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    protected void parseScriptDefault(PsiBuilder builder) {
        SqlGeneratedParserUtil.parseAsTree(builder, 0, SQL_DUMMY_BLOCK, false, new GeneratedParserUtilBase.Parser(){

            public boolean parse(PsiBuilder builder, int level) {
                return SybaseParser.this.parseBatchBlock(builder, AseElementTypes.ASE_BATCH_BLOCK, SybaseOptionalKeywords.ASE_GO);
            }
        }, GeneratedParserUtilBase.TRUE_CONDITION);
    }

    @Override
    public IElementType parseLiteralOther(PsiBuilder builder, int level) {
        if (GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)"$action", (boolean)true)) {
            return SQL_SPECIAL_LITERAL;
        }
        return super.parseLiteralOther(builder, level);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        boolean result = AseGeneratedParser.statement(builder, level);
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_SEMICOLON)) {
            this.statementSeparatorParsed();
        }
        return result;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return AseGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return AseDmlParsing.query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level) {
        return AseDdlParsing.type_element(builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = SybaseExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error("<expression> expected");
        }
        return result;
    }

    @Override
    protected boolean allowNoStatementSeparator() {
        return true;
    }

    @Override
    public boolean parseJdbcFunctionCallExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParser.possible_no_paren_database_function_call_expression(builder, level);
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType paramToken, IElementType resultType) {
        String tokenText = builder.getTokenText();
        if (this.getLanguage().getSupportedFunctions().containsKey(tokenText)) {
            return false;
        }
        return super.parseParameterReferenceInner(builder, paramToken, resultType);
    }
}

