/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.generation.surroundWith;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.generation.surroundWith.SqlSurrounderBase;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuoteSurrounder
extends SqlSurrounderBase {
    public String getTemplateDescription() {
        return SqlMessages.message("surround.with.quote.template", new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/sql/generation/surroundWith/SqlQuoteSurrounder", "isApplicable"));
        }
        return true;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement[] elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/generation/surroundWith/SqlQuoteSurrounder", "surroundElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/generation/surroundWith/SqlQuoteSurrounder", "surroundElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/sql/generation/surroundWith/SqlQuoteSurrounder", "surroundElements"));
        }
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])elements);
        if (element == null) {
            return null;
        }
        DatabaseDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element).getDatabaseDialect();
        return SqlQuoteSurrounder.surroundElementsWith(editor, Character.toString(dialect.openQuote()), Character.toString(dialect.closeQuote()));
    }
}

