/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public class QuoteIdentifierQuickFix
implements LocalQuickFix {
    private final SqlLanguageDialect myDialect;

    public QuoteIdentifierQuickFix(SqlLanguageDialect dialect) {
        this.myDialect = dialect;
    }

    @NotNull
    public String getName() {
        String string = SqlMessages.message("quickfix.name.quote.identifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/QuoteIdentifierQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/QuoteIdentifierQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/sql/highlighting/QuoteIdentifierQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/sql/highlighting/QuoteIdentifierQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof SqlIdentifier)) {
            return;
        }
        SqlImplUtil.quoteIdentifier(project, (SqlIdentifier)element, this.myDialect);
    }
}

